/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.join;

import crazydev.common.math.CdSortingGraph;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderSchedulingPolicy;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderTwoTableDataView;
import crazydev.iccube.builder.model.impl.view.join.OlapBuilderJoinDataViewLogic;
import crazydev.iccube.builder.model.impl.view.join.OlapBuilderJoinDataViewValidator;
import crazydev.iccube.builder.model.impl.view.join.OlapBuilderJoinType;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroupId;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="joinDataView")
public class OlapBuilderJoinDataView
extends OlapBuilderTwoTableDataView<OlapBuilderJoinDataView, OlapBuilderJoinDataViewLogic> {
    public static final CdProperty LEFT_JOIN_COLUMNS_REFS = new CdReadWriteProperty(OlapBuilderJoinDataView.class, "leftJoinColRefs");
    public static final CdProperty RIGHT_JOIN_COLUMNS_REFS = new CdReadWriteProperty(OlapBuilderJoinDataView.class, "rightJoinColRefs");
    public static final CdProperty IGNORE_LEFT_COLUMNS = new CdReadWriteProperty(OlapBuilderJoinDataView.class, "ignoreLeftColumns");
    public static final CdProperty IGNORE_RIGHT_COLUMNS = new CdReadWriteProperty(OlapBuilderJoinDataView.class, "ignoreRightColumns");
    public static final CdProperty INCLUDED_RIGHT_COLUMNS = new CdReadWriteProperty(OlapBuilderJoinDataView.class, "includedRightColumns");
    public static final CdProperty JOIN_TYPE = new CdReadWriteProperty(OlapBuilderJoinDataView.class, "joinType");
    public static final CdProperty RIGHT_TABLE_AS_ARRAY = new CdReadWriteProperty(OlapBuilderJoinDataView.class, "rightTableAsArray");
    @XmlElement(name="leftJoinColumns", required=true)
    private List<OlapBuilderDataColumnRef> leftJoinColRefs;
    @XmlElement(name="rightJoinColumns", required=true)
    private List<OlapBuilderDataColumnRef> rightJoinColRefs;
    @XmlElement(name="ignoreLeftColumns", required=true)
    private List<OlapBuilderDataColumnRef> ignoreLeftColumns;
    @XmlElement(name="ignoreRightColumns", required=true)
    private List<OlapBuilderDataColumnRef> ignoreRightColumns;
    @XmlElement(name="includedRightColumns", required=true)
    private List<OlapBuilderDataColumnRef> includedRightColumns;
    @XmlElement(name="joinType", required=true)
    private OlapBuilderJoinType joinType;
    @XmlElement(name="rightTableAsArray", required=true)
    private boolean rightTableAsArray;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> leftJoinColumnsDef;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> rightJoinColumnsDefs;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> ignoreLeftColumnsDefs;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> ignoreRightColumnsDefs;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> includedRightColumnsDefs;

    @Override
    @Nullable
    public String getHelpUrl() {
        return "etl_join";
    }

    @Override
    public UxBuilderDataViewTypeGroupId getUxGroupId() {
        return UxBuilderDataViewTypeGroupId.dvTypeGroupClassic;
    }

    @Override
    protected OlapBuilderJoinDataViewLogic createLogic() {
        return new OlapBuilderJoinDataViewLogic(this);
    }

    @Override
    public OlapBuilderSchedulingPolicy schedulingPolicy() {
        return OlapBuilderSchedulingPolicy.POST_ORDER;
    }

    @Override
    public void solveDirectReferencesColumns(OlapBuilderReferenceSolver referenceSolver) {
        super.solveDirectReferencesColumns(referenceSolver);
        this.leftJoinColumnsDef = referenceSolver.getColumns(this.underlyingLeft, this.leftJoinColRefs);
        this.rightJoinColumnsDefs = referenceSolver.getColumns(this.underlyingRight, this.rightJoinColRefs);
        this.ignoreLeftColumnsDefs = referenceSolver.getColumns(this.underlyingLeft, this.ignoreLeftColumns);
        this.ignoreRightColumnsDefs = referenceSolver.getColumns(this.underlyingRight, this.ignoreRightColumns);
        this.includedRightColumnsDefs = referenceSolver.getColumns(this.underlyingRight, this.includedRightColumns);
    }

    @Override
    public void onReferenceSolved(OlapBuilderErrorManager errorManager, CdSortingGraph<IOlapBuilderTabularDataDef> graph) {
        super.onReferenceSolved(errorManager, graph);
        graph.setOneOneRelation((Object)this.underlyingLeft, (Object)this);
        if (this.underlyingLeft != null && this.underlyingRight != null) {
            graph.setParentChild(this.getName(), (Object)this.underlyingRight, (Object)this.underlyingLeft);
        }
    }

    @Override
    public String getInternalFriendlyTypeName() {
        StringBuilder sb = this.getFriendlyNames(this.getDirectUnderlyings());
        return "Join View ( " + sb.toString() + " )";
    }

    @Override
    public OlapValidator<OlapBuilderValidationContext, IOlapBuilderSchemaDef, OlapBuilderJoinDataView> getValidator() {
        return new OlapBuilderJoinDataViewValidator();
    }

    public List<IOlapBuilderDataColumnDef> getLeftJoinColumnsDef() {
        return this.leftJoinColumnsDef;
    }

    public List<IOlapBuilderDataColumnDef> getRightJoinColumnsDefs() {
        return this.rightJoinColumnsDefs;
    }

    public List<IOlapBuilderDataColumnDef> getIgnoreLeftColumnsDefs() {
        return this.ignoreLeftColumnsDefs == null ? Collections.emptyList() : this.ignoreLeftColumnsDefs;
    }

    public List<IOlapBuilderDataColumnDef> getIgnoreRightColumnsDefs() {
        return this.ignoreRightColumnsDefs == null ? Collections.emptyList() : this.ignoreRightColumnsDefs;
    }

    public List<IOlapBuilderDataColumnDef> getIncludedRightColumnsDefs() {
        return this.includedRightColumnsDefs == null ? Collections.emptyList() : this.includedRightColumnsDefs;
    }

    public boolean isEmpty() {
        return this.tableLeftId == null || this.tableRightId == null || this.leftJoinColumnsDef == null || this.rightJoinColumnsDefs == null;
    }

    public OlapBuilderJoinType getJoinType() {
        return this.joinType;
    }

    public boolean isRightTableAsArray() {
        return this.rightTableAsArray;
    }
}

