/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.javasimple;

import crazydev.common.javacompiler.CompilationException;
import crazydev.common.javacompiler.CompiledCode;
import crazydev.common.javacompiler.InMemoryJavaCompiler;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseLanguageDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseLanguageDataViewLogic;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseSimpleJavaDataView<P, N extends OlapBuilderBaseSimpleJavaDataView, T extends OlapBuilderBaseLanguageDataViewLogic<N>>
extends OlapBuilderBaseLanguageDataView<N, T> {
    public static final CdProperty JAVA_CODE = new CdReadWriteProperty(OlapBuilderBaseSimpleJavaDataView.class, "javaCode");
    @XmlElement(name="javaCode", required=false)
    protected String javaCode;
    @XmlElement(name="compiledCode", required=false)
    @Nullable
    private CompiledCode compiledCode;
    @XmlTransient
    private P instance;

    public void destroyInstance() {
        this.instance = null;
    }

    public P getOrCreateInstance() throws Exception {
        return this.getOrCreateInstance(true);
    }

    public P getOrCreateInstance(boolean recompileOnVersionError) throws Exception {
        if (this.javaCode == null) {
            return null;
        }
        if (this.instance == null || this.compiledCode == null || this.needsRecompile()) {
            String javaClassFullName = this.getJavaClassFullName();
            InMemoryJavaCompiler javaCompiler = InMemoryJavaCompiler.newDefaultInstance((int)1);
            if (this.needsRecompile()) {
                this.compile(javaCompiler, javaClassFullName, this.javaCode, this.getName());
            } else {
                javaCompiler.getClassloader().addCode(this.compiledCode);
            }
            if (this.isAJavaClassDefinition(this.javaCode)) {
                try {
                    javaCompiler.loadClasses(this.compiledCode);
                    Class clazz = javaCompiler.getClass(javaClassFullName);
                    this.instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (UnsupportedClassVersionError ex) {
                    if (recompileOnVersionError) {
                        this.compiledCode = null;
                        return this.getOrCreateInstance(false);
                    }
                    throw ex;
                }
            } else {
                this.instance = Class.forName(this.javaCode).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        return this.instance;
    }

    private boolean needsRecompile() {
        return this.javaCode == null || this.compiledCode == null || !this.compiledCode.checkSourceCode(this.javaCode);
    }

    public boolean needsRecompile(String newJavaCode) {
        return newJavaCode == null || this.javaCode == null || this.compiledCode == null || !this.compiledCode.checkSourceCode(newJavaCode);
    }

    private void compile(InMemoryJavaCompiler javaCompiler, String javaClassFullName, String methodBody, String viewName) throws CompilationException {
        if (this.isAJavaClassDefinition(methodBody)) {
            long startMS = System.currentTimeMillis();
            OlapLoggers.BUILDER_VIEW_JAVA.info((Object)("Compiling JAVA view " + viewName));
            this.actualCompile(javaCompiler, javaClassFullName, methodBody);
            OlapLoggers.BUILDER_VIEW_JAVA.info((Object)"Compiling JAVA view done");
            OlapLoggers.CHECKPOINTS.info((Object)"[ic3] Java view [%s] compiled in [%s]".formatted(viewName, CdTimeUtils.formatMillisEx((long)startMS)));
        } else {
            OlapLoggers.BUILDER_VIEW_JAVA.info((Object)("Using existing class '" + methodBody + "'  in JAVA view " + viewName));
            this.compiledCode = new CompiledCode(Collections.emptyList());
            this.compiledCode.setSourceCode(methodBody);
        }
    }

    private boolean isAJavaClassDefinition(String methodBody) {
        return methodBody.contains("\n") || methodBody.contains("\r");
    }

    private void actualCompile(InMemoryJavaCompiler javaCompiler, String javaClassFullName, String methodBody) throws CompilationException {
        if (!InMemoryJavaCompiler.hasJavaCompilerInstalled()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.JDK_NOT_INSTALLED, new Serializable[]{this.getInternalFriendlyTypeName()});
        }
        String sourceCode = this.buildJavaClassCode(methodBody);
        OlapLoggers.BUILDER_VIEW_JAVA.info((Object)(this.getName() + " class " + javaClassFullName));
        OlapLoggers.BUILDER_VIEW_JAVA.info((Object)sourceCode);
        CompiledCode code = javaCompiler.compile(javaClassFullName, sourceCode);
        code.setSourceCode(methodBody);
        this.compiledCode = code;
    }

    protected abstract String buildJavaClassCode(String var1);

    private String getJavaClassFullName() {
        return this.packageName() + "." + this.getJavaClassName();
    }

    @NotNull
    protected String packageName() {
        return "iccube.pub";
    }

    protected abstract String getJavaClassName();

    public String getJavaCode() {
        return this.javaCode;
    }

    public void addColumn(String columnName, Class columnType, String columnDescription, boolean isArray) {
        List<IOlapBuilderDataColumnDef> selectedColumns = this.getSelectedColumns();
        Optional<IOlapBuilderDataColumnDef> alreadyThere = selectedColumns.stream().filter(c -> c.getName().equals(columnName)).findFirst();
        if (alreadyThere.isPresent()) {
            return;
        }
        OlapBuilderInputType type = OlapBuilderInputType.findByJavaClass(columnType);
        if (type == null) {
            throw new RuntimeException("Unsupported column type Java Class [" + String.valueOf(columnType) + "]");
        }
        OlapBuilderDataColumn column = new OlapBuilderDataColumn(type, "view-generated", columnName, isArray);
        Optional<Integer> maxIndex = selectedColumns.stream().map(IOlapBuilderDataColumnDef::getIndex).max(Integer::compareTo);
        column.setIndex(maxIndex.orElse(0) + 1);
        selectedColumns.add(column);
    }
}

