/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.javascript.tablecache;

import crazydev.common.collection.CdArrays;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheRowWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheTableWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderTableCacheIndex;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnCountRowsAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapComparableEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedListFactory;
import crazydev.iccube.pub.view.IOlapCachedTable;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderTableCache {
    private static final OlapFactPaginatedListFactory factory = new OlapFactPaginatedListFactory(15);
    final Map<List<String>, OlapBuilderTableCacheIndex> indexMap = new ConcurrentHashMap<List<String>, OlapBuilderTableCacheIndex>();
    final List<IOlapBuilderDataColumnDef> selectedColumns;
    final ArrayList<OlapScalarEntityFactColumn> values;
    private final OlapBuilderContext context;
    private final String name;
    private final Object LOCK = new Object();
    private final IOlapDataTableDef tableCache;

    public OlapBuilderTableCache(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        this.context = context;
        this.tableCache = new TableDef(this);
        this.selectedColumns = tabularData.getSelectedColumns();
        this.values = new ArrayList(this.selectedColumns.size());
        for (int i = 0; i < this.selectedColumns.size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = this.selectedColumns.get(i);
            OlapScalarEntityFactColumn dataCol = this.createColumn(columnDef);
            this.values.add(dataCol);
        }
        this.name = tabularData.getName();
    }

    OlapBuilderTableCache(OlapBuilderContext context, List<IOlapBuilderDataColumnDef> columns, ArrayList<OlapScalarEntityFactColumn> values, String name) {
        this.context = context;
        this.selectedColumns = columns;
        this.values = values;
        this.name = name;
        this.tableCache = new TableDef(this);
    }

    OlapBuilderContext context() {
        return this.context;
    }

    OlapScalarEntityFactColumn createColumn(IOlapBuilderDataColumnDef columnDef) {
        if (columnDef.getType().isString() || columnDef.isArray()) {
            return new OlapComparableEntityFactColumn(factory, null, OlapBuilderInputType.STRING);
        }
        return columnDef.getType().createScalarEntityFactColumn(factory, null);
    }

    public String getTableName() {
        return this.name;
    }

    public void onNewRow(int rowNb, IOlapBuilderTableRow data) {
        for (int i = 0; i < this.selectedColumns.size(); ++i) {
            OlapScalarEntityFactColumn factColumn = this.values.get(i);
            IOlapBuilderDataColumnDef columnDef = this.selectedColumns.get(i);
            factColumn.addNewValue(data.getJavaNativeDataValue(columnDef));
        }
    }

    public void trimToSize() {
        for (OlapScalarEntityFactColumn value : this.values) {
            value.trimToSize();
        }
    }

    OlapScalarEntityFactColumn getDataColumn(int colIdx) {
        return this.values.get(colIdx);
    }

    int getExistingColumnIndex(String columnName) {
        int idx = this.getColumnIndex(columnName);
        if (idx < 0) {
            throw new RuntimeException("Could not find column '" + columnName + "' in table '" + this.getTableName() + "'");
        }
        return idx;
    }

    private int getColumnIndex(String columnName) {
        for (int i = 0; i < this.selectedColumns.size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = this.selectedColumns.get(i);
            if (!columnDef.getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int getExistingColumnIndex(IOlapColumnDef columnDef) {
        if (!this.selectedColumns.contains(columnDef)) {
            throw new RuntimeException("Column '" + String.valueOf(columnDef) + "' does not belong to table '" + this.getTableName() + "'");
        }
        return columnDef.getIndex();
    }

    public IOlapBuilderDataColumnDef getExistingColumn(String columnName) {
        for (int i = 0; i < this.selectedColumns.size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = this.selectedColumns.get(i);
            if (!columnDef.getName().equals(columnName)) continue;
            return columnDef;
        }
        throw new RuntimeException("Could not find column '" + columnName + "' in table '" + this.getTableName() + "'");
    }

    public int size() {
        return this.values.isEmpty() ? 0 : this.values.get(0).size();
    }

    @Nullable
    public Comparable getValue(int rowNumber, int columnIdx) {
        OlapScalarEntityFactColumn colValues = this.values.get(columnIdx);
        if (rowNumber < 0 || rowNumber >= colValues.size()) {
            throw new RuntimeException("IndexOutOfBoundsException [" + rowNumber + "] - " + colValues.size());
        }
        return colValues.getValueAsObject(rowNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int rowNumber, int columnIdx, Comparable newValue) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapScalarEntityFactColumn colValues = this.values.get(columnIdx);
            if (rowNumber < 0 || rowNumber >= colValues.size()) {
                throw new RuntimeException("IndexOutOfBoundsException [" + rowNumber + "] - " + colValues.size());
            }
            this.values.get(columnIdx).setValueAt(rowNumber, newValue, OlapFactRowAggregationType.UPDATE_ON_CELL);
            this.clearCache(this.selectedColumns.get(columnIdx).getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void clearCache(String columnName) {
        Object object = this.LOCK;
        synchronized (object) {
            this.indexMap.keySet().stream().filter(key -> key.contains(columnName)).forEach(this.indexMap::remove);
        }
    }

    public OlapBuilderTableCacheIndex getIndex(String[] columnNames) {
        List<String> key = Arrays.asList(columnNames);
        OlapBuilderTableCacheIndex index = this.indexMap.get(key);
        if (index != null) {
            return index;
        }
        return this.createIndex(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapBuilderTableCacheIndex createIndex(List<String> columnNames) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapBuilderTableCacheIndex index = this.indexMap.get(columnNames);
            if (index != null) {
                return index;
            }
            index = new OlapBuilderTableCacheIndex(this, columnNames);
            this.indexMap.put(columnNames, index);
            return index;
        }
    }

    @Nullable
    public Object aggregate(String columnName, OlapAggregationType type) {
        OlapScalarEntityFactColumn dataColumn = this.values.get(this.getExistingColumnIndex(columnName));
        OlapScalarEntityFactColumn.Aggregator aggregator = this.getAggregator(type, dataColumn);
        dataColumn.aggregateRange(aggregator, 0, dataColumn.size());
        return aggregator.asScalarEntity().asValue();
    }

    public Object aggregate(String columnName, OlapAggregationType type, IntArrayList rowId) {
        OlapScalarEntityFactColumn dataColumn = this.values.get(this.getExistingColumnIndex(columnName));
        OlapScalarEntityFactColumn.Aggregator aggregator = this.getAggregator(type, dataColumn);
        dataColumn.aggregatePoints(aggregator, rowId.elements(), rowId.size());
        return aggregator.asScalarEntity().asValue();
    }

    public Object aggregate(String columnName, OlapAggregationType type, int rowId) {
        OlapScalarEntityFactColumn dataColumn = this.values.get(this.getExistingColumnIndex(columnName));
        OlapScalarEntityFactColumn.Aggregator aggregator = this.getAggregator(type, dataColumn);
        dataColumn.aggregateRange(aggregator, rowId, rowId + 1);
        return aggregator.asScalarEntity().asValue();
    }

    private OlapScalarEntityFactColumn.Aggregator getAggregator(OlapAggregationType type, OlapScalarEntityFactColumn dataColumn) {
        return type == OlapAggregationType.COUNT ? new OlapFactColumnCountRowsAggregator() : dataColumn.createAggregator(type);
    }

    public Object[] distinct(String columnName) {
        return this.getIndex(new String[]{columnName}).distinct()[0];
    }

    public Object[][] distinct(String[] columnNames) {
        return this.getIndex(columnNames).distinct();
    }

    public Stream<OlapBuilderCacheRowWrapper> stream(final OlapBuilderCacheTableWrapper tableWrapper) {
        Iterator<OlapBuilderCacheRowWrapper> iterable = new Iterator<OlapBuilderCacheRowWrapper>(){
            int currRowIdx;
            final /* synthetic */ OlapBuilderTableCache this$0;
            {
                OlapBuilderTableCache olapBuilderTableCache = this$0;
                Objects.requireNonNull(olapBuilderTableCache);
                this.this$0 = olapBuilderTableCache;
                this.currRowIdx = -1;
            }

            @Override
            public boolean hasNext() {
                int size = this.this$0.size();
                return this.currRowIdx < size && ++this.currRowIdx < size;
            }

            @Override
            public OlapBuilderCacheRowWrapper next() {
                return new OlapBuilderCacheRowWrapper(tableWrapper, this.currRowIdx);
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterable, 0), false);
    }

    public int getPrevRowNotNull(int rowNumber, String columnName) {
        OlapScalarEntityFactColumn dataColumn = this.values.get(this.getExistingColumnIndex(columnName));
        for (int i = rowNumber - 1; i >= 0; --i) {
            if (dataColumn.getValueAsObject(i) == null) continue;
            return i;
        }
        return -1;
    }

    public int getNextRowNotNull(int rowNumber, String columnName) {
        OlapScalarEntityFactColumn dataColumn = this.values.get(this.getExistingColumnIndex(columnName));
        for (int i = rowNumber + 1; i < dataColumn.size(); ++i) {
            if (dataColumn.getValueAsObject(i) == null) continue;
            return i;
        }
        return -1;
    }

    public void replace(String columnName, @Nullable Comparable lookupValue, @Nullable Comparable newValue) {
        boolean replaced = false;
        OlapScalarEntityFactColumn dataColumn = this.values.get(this.getExistingColumnIndex(columnName));
        for (int i = 0; i < dataColumn.size(); ++i) {
            Comparable comparable = dataColumn.getValueAsObject(i);
            if ((lookupValue != null || comparable != null) && (lookupValue == null || !lookupValue.equals(comparable))) continue;
            dataColumn.setValueAt(i, newValue, OlapFactRowAggregationType.UPDATE_ON_CELL);
            replaced = true;
        }
        if (replaced) {
            this.clearCache(columnName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillMissingPrevious(String columnName) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapScalarEntityFactColumn dataColumn = this.values.get(this.getExistingColumnIndex(columnName));
            Comparable currentNotNullValue = null;
            boolean filledAllNull = true;
            for (int i = 0; i < dataColumn.size(); ++i) {
                Comparable comparable = dataColumn.getValueAsObject(i);
                if (this.isMissing(comparable)) {
                    if (currentNotNullValue != null) {
                        dataColumn.setValueAt(i, currentNotNullValue, OlapFactRowAggregationType.UPDATE_ON_CELL);
                    } else {
                        filledAllNull = false;
                    }
                }
                currentNotNullValue = comparable == null ? currentNotNullValue : comparable;
            }
            this.clearCache(columnName);
            return filledAllNull;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillMissingNext(String columnName) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapScalarEntityFactColumn dataColumn = this.values.get(this.getExistingColumnIndex(columnName));
            Comparable currentNotNullValue = null;
            boolean filledAllNull = true;
            for (int i = dataColumn.size() - 1; i >= 0; --i) {
                Comparable comparable = dataColumn.getValueAsObject(i);
                if (this.isMissing(comparable)) {
                    if (currentNotNullValue != null) {
                        dataColumn.setValueAt(i, currentNotNullValue, OlapFactRowAggregationType.UPDATE_ON_CELL);
                    } else {
                        filledAllNull = false;
                    }
                }
                currentNotNullValue = comparable == null ? currentNotNullValue : comparable;
            }
            this.clearCache(columnName);
            return filledAllNull;
        }
    }

    private boolean isMissing(Comparable comparable) {
        return comparable == null;
    }

    public ArrayList<String> columns() {
        ArrayList<String> cols = new ArrayList<String>();
        for (IOlapBuilderDataColumnDef columnDef : this.selectedColumns) {
            cols.add(columnDef.getName());
        }
        return cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(String[] columnName, int orderDirection) {
        Object object = this.LOCK;
        synchronized (object) {
            int i;
            List columns2Compare = Arrays.stream(columnName).map(this::getColumnIndex).collect(Collectors.toList());
            ArrayList<Integer> rowId = new ArrayList<Integer>();
            for (i = 0; i < this.size(); ++i) {
                rowId.add(i);
            }
            rowId.sort((o1, o2) -> orderDirection * this.getIntegerComparator(columns2Compare, (int)o1, (int)o2));
            for (i = 0; i < this.values.size(); ++i) {
                OlapScalarEntityFactColumn column = this.values.get(i);
                OlapScalarEntityFactColumn newColumn = this.createColumn(this.selectedColumns.get(i));
                for (Integer newRowPos : rowId) {
                    newColumn.addNewValue(column.getValueAsObject(newRowPos));
                }
                this.values.set(i, newColumn);
            }
        }
    }

    @NotNull
    private int getIntegerComparator(List<Integer> columns2Compare, int o1, int o2) {
        for (Integer colId : columns2Compare) {
            Comparable v2;
            Comparable v1 = this.values.get(colId).getValueAsObject(o1);
            if (v1 == (v2 = this.values.get(colId).getValueAsObject(o2))) continue;
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            int cv = v1.compareTo(v2);
            if (cv == 0) continue;
            return cv;
        }
        return 0;
    }

    public IOlapCachedTable groupBy(String[] groupByColumns, String[] aggregationColumns, String[] aggregationTypes) {
        for (int i = 0; i < aggregationColumns.length; ++i) {
            String aggregationColumn = aggregationColumns[i];
            if (!CdArrays.contains((Object)aggregationColumn, (Object[])groupByColumns)) continue;
            throw new RuntimeException("GroupBy has the same column on the aggregated columns list " + aggregationColumn);
        }
        OlapBuilderTableCacheIndex index = this.getIndex(groupByColumns);
        return index.groupBy(groupByColumns, aggregationColumns, aggregationTypes);
    }

    public IOlapDataTableDef getTableDef() {
        return this.tableCache;
    }

    public Object getLock() {
        return this.LOCK;
    }

    private class TableDef
    implements IOlapDataTableDef {
        final /* synthetic */ OlapBuilderTableCache this$0;

        private TableDef(OlapBuilderTableCache olapBuilderTableCache) {
            OlapBuilderTableCache olapBuilderTableCache2 = olapBuilderTableCache;
            Objects.requireNonNull(olapBuilderTableCache2);
            this.this$0 = olapBuilderTableCache2;
        }

        @Override
        public String getName() {
            return this.this$0.getTableName();
        }

        @Override
        public List<? extends IOlapColumnDef> getColumns() {
            return this.this$0.selectedColumns;
        }
    }
}

