/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.javascript.tablecache;

import crazydev.common.collection.CdSingleItemList;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheRowListWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheRowWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderTableCache;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderTableCacheIndex;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.pub.view.IOlapCachedRowList;
import crazydev.iccube.pub.view.IOlapCachedTable;
import crazydev.iccube.pub.view.IOlapCachedTableRow;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderCacheTableWrapper
implements IOlapCachedTable {
    final OlapBuilderTableCache tableCache;

    public OlapBuilderCacheTableWrapper(OlapBuilderTableCache tableCache) {
        this.tableCache = tableCache;
    }

    @Override
    public OlapBuilderCacheRowWrapper row(int rowNumber) {
        if (rowNumber < 0 || rowNumber >= this.count()) {
            throw new RuntimeException("IndexOutOfBoundsException [" + rowNumber + "] - " + this.count());
        }
        return new OlapBuilderCacheRowWrapper(this, rowNumber);
    }

    @Override
    public int count() {
        return this.tableCache.size();
    }

    @Override
    @Nullable
    public Object sum(String columnName) {
        return this.tableCache.aggregate(columnName, OlapAggregationType.SUM);
    }

    @Override
    public int countNotNull(String columnName) {
        return ((Number)this.tableCache.aggregate(columnName, OlapAggregationType.COUNT)).intValue();
    }

    @Override
    @Nullable
    public Object min(String columnName) {
        return this.tableCache.aggregate(columnName, OlapAggregationType.MIN);
    }

    @Override
    @Nullable
    public Object max(String columnName) {
        return this.tableCache.aggregate(columnName, OlapAggregationType.MAX);
    }

    @Override
    public Object[] distinct(String columnName) {
        return this.tableCache.distinct(columnName);
    }

    @Override
    public Object[][] distinct(String[] columnNames) {
        return this.tableCache.distinct(columnNames);
    }

    @Override
    public Object aggregate(String columnName, String aggregationType) {
        return this.tableCache.aggregate(columnName, OlapAggregationType.valueOf(aggregationType));
    }

    @Override
    public ArrayList<String> columns() {
        return this.tableCache.columns();
    }

    @Override
    public Stream<OlapBuilderCacheRowWrapper> stream() {
        return this.tableCache.stream(this);
    }

    @Override
    public IOlapCachedTable groupBy(String[] groupByColumns, String[] aggregationColumns, String[] aggregationTypes) {
        return this.tableCache.groupBy(groupByColumns, aggregationColumns, aggregationTypes);
    }

    @Override
    public IOlapCachedRowList filter(String columnName, Object value) {
        OlapBuilderTableCacheIndex index = this.tableCache.getIndex(new String[]{columnName});
        return new OlapBuilderCacheRowListWrapper(this, index, index.rows((List<Object>)new CdSingleItemList(value)));
    }

    @Override
    public IOlapCachedRowList filter(String[] columnName, Object[] values) {
        OlapBuilderTableCacheIndex index = this.tableCache.getIndex(columnName);
        return new OlapBuilderCacheRowListWrapper(this, index, index.rows(Arrays.asList(values)));
    }

    @Override
    public IOlapCachedTableRow firstMatching(String columnName, Object value) {
        OlapBuilderTableCacheIndex index = this.tableCache.getIndex(new String[]{columnName});
        return index.firstMatching(this, (List<Object>)new CdSingleItemList(value));
    }

    @Override
    public IOlapCachedTableRow firstMatching(String[] columnName, Object[] values) {
        OlapBuilderTableCacheIndex index = this.tableCache.getIndex(columnName);
        return index.firstMatching(this, Arrays.asList(values));
    }

    @Override
    public Comparable get(int rowId, String columnName) {
        return this.tableCache.getValue(rowId, this.tableCache.getExistingColumnIndex(columnName));
    }

    @Override
    public void set(int rowId, String columnName, Comparable newValue) {
        this.tableCache.setValue(rowId, this.tableCache.getExistingColumnIndex(columnName), newValue);
    }

    @Override
    public void replace(String columnName, Comparable lookupValue, Comparable newValue) {
        this.tableCache.replace(columnName, lookupValue, newValue);
    }

    @Override
    public void fillMissingPrev(String columnName) {
        this.tableCache.fillMissingPrevious(columnName);
    }

    @Override
    public void fillMissingNext(String columnName) {
        this.tableCache.fillMissingNext(columnName);
    }

    @Override
    public void sortAsc(String ... columnName) {
        this.tableCache.sort(columnName, 1);
    }

    @Override
    public void sortDesc(String ... columnName) {
        this.tableCache.sort(columnName, -1);
    }

    public IOlapDataTableDef getTableDef() {
        return this.tableCache.getTableDef();
    }

    public List<? extends IOlapColumnDef> getColumns() {
        return this.tableCache.selectedColumns;
    }

    public IOlapColumnDef getColumn(String columnName) {
        return this.tableCache.getExistingColumn(columnName);
    }
}

