/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.javascript.tablecache;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.IOlapCachedTableRowWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheMissingRowWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheTableWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderTableCache;
import crazydev.iccube.pub.view.IOlapCachedTable;
import crazydev.iccube.pub.view.IOlapCachedTableRow;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderCacheRowWrapper
implements IOlapCachedTableRowWrapper {
    private final OlapBuilderCacheTableWrapper tableWrapper;
    private final OlapBuilderTableCache tableCache;
    private final int rowNumber;

    OlapBuilderCacheRowWrapper(OlapBuilderCacheTableWrapper tableWrapper, int rowNumber) {
        this.tableWrapper = tableWrapper;
        this.rowNumber = rowNumber;
        this.tableCache = tableWrapper.tableCache;
    }

    @Override
    public OlapBuilderContext context() {
        return this.tableCache.context();
    }

    @Override
    public IOlapDataTableDef getTableDef() {
        return this.tableWrapper.getTableDef();
    }

    @Override
    public Comparable get(IOlapColumnDef columnDef) {
        int columnIdx = this.tableCache.getExistingColumnIndex(columnDef);
        return this.tableCache.getValue(this.rowNumber, columnIdx);
    }

    @Override
    public Comparable get(String columnName) {
        int columnIdx = this.tableCache.getExistingColumnIndex(columnName);
        return this.tableCache.getValue(this.rowNumber, columnIdx);
    }

    @Override
    public List<? extends IOlapColumnDef> getColumns() {
        return this.tableWrapper.getColumns();
    }

    @Override
    public IOlapColumnDef getColumn(String columnName) {
        return this.tableWrapper.getColumn(columnName);
    }

    @Override
    public void set(String columnName, Comparable newValue) {
        int columnIdx = this.tableCache.getExistingColumnIndex(columnName);
        Comparable typedValue = this.convertValue(this.tableWrapper.getColumn(columnName), newValue);
        this.tableCache.setValue(this.rowNumber, columnIdx, typedValue);
    }

    @Override
    public void set(IOlapColumnDef columnDef, Comparable newValue) {
        int columnIdx = this.tableCache.getExistingColumnIndex(columnDef);
        Comparable typedValue = this.convertValue(columnDef, newValue);
        this.tableCache.setValue(this.rowNumber, columnIdx, typedValue);
    }

    @Override
    public IOlapCachedTableRow prevRowNotNull(String columnName) {
        int idx = this.tableCache.getPrevRowNotNull(this.rowNumber, columnName);
        if (idx == -1) {
            return new OlapBuilderCacheMissingRowWrapper(this.tableWrapper);
        }
        return this.tableWrapper.row(idx);
    }

    @Override
    public IOlapCachedTableRow nextRowNotNull(String columnName) {
        int idx = this.tableCache.getNextRowNotNull(this.rowNumber, columnName);
        if (idx == -1) {
            return new OlapBuilderCacheMissingRowWrapper(this.tableWrapper);
        }
        return this.tableWrapper.row(idx);
    }

    @Override
    public IOlapCachedTableRow prevRow() {
        return this.rowNumber == 0 ? new OlapBuilderCacheMissingRowWrapper(this.tableWrapper) : this.tableWrapper.row(this.rowNumber - 1);
    }

    @Override
    public IOlapCachedTableRow nextRow() {
        return this.rowNumber + 1 >= this.tableWrapper.count() ? new OlapBuilderCacheMissingRowWrapper(this.tableWrapper) : this.tableWrapper.row(this.rowNumber + 1);
    }

    @Override
    @Nullable
    public IOlapCachedTableRow row(int rowNumber) {
        return this.tableWrapper.row(rowNumber);
    }

    @Override
    public int index() {
        return this.rowNumber;
    }

    @Override
    public IOlapCachedTable table() {
        return this.tableWrapper;
    }

    @Override
    public boolean isMissing() {
        return false;
    }
}

