/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.javascript.tablecache;

import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheRowWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheTableWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderTableCacheIndex;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.pub.view.IOlapCachedRowList;
import crazydev.iccube.pub.view.IOlapCachedTable;
import java.util.Collections;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderCacheRowListWrapper
implements IOlapCachedRowList {
    private final OlapBuilderCacheTableWrapper tableWrapper;
    private final OlapBuilderTableCacheIndex cacheIndex;
    @Nullable
    private final Object rowList;

    public OlapBuilderCacheRowListWrapper(OlapBuilderCacheTableWrapper tableWrapper, OlapBuilderTableCacheIndex cacheIndex, @Nullable Object rowList) {
        this.tableWrapper = tableWrapper;
        this.cacheIndex = cacheIndex;
        this.rowList = rowList;
    }

    @Override
    public int count() {
        return this.cacheIndex.count(this.rowList);
    }

    @Override
    @Nullable
    public Object sum(String columnName) {
        return this.cacheIndex.aggregate(this.rowList, columnName, OlapAggregationType.SUM);
    }

    @Override
    public int countNotNull(String columnName) {
        return ((Number)this.cacheIndex.aggregate(this.rowList, columnName, OlapAggregationType.COUNT)).intValue();
    }

    @Override
    @Nullable
    public Object min(String columnName) {
        return this.cacheIndex.aggregate(this.rowList, columnName, OlapAggregationType.MIN);
    }

    @Override
    @Nullable
    public Object max(String columnName) {
        return this.cacheIndex.aggregate(this.rowList, columnName, OlapAggregationType.MAX);
    }

    @Override
    @Nullable
    public Object aggregate(String columnName, String aggregationType) {
        return this.cacheIndex.aggregate(this.rowList, columnName, OlapAggregationType.valueOf(aggregationType));
    }

    @Override
    public Stream<OlapBuilderCacheRowWrapper> stream() {
        if (this.rowList == null) {
            return Collections.emptyList().stream();
        }
        return this.cacheIndex.stream(this.tableWrapper, this.rowList);
    }

    @Override
    public IOlapCachedTable table() {
        return this.tableWrapper;
    }
}

