/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.java;

import crazydev.common.math.CdSortingGraph;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifiers;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.java.OlapBuilderJavaDataViewLogic;
import crazydev.iccube.builder.model.impl.view.java.OlapBuilderJavaDataViewValidator;
import crazydev.iccube.builder.model.impl.view.javasimple.OlapBuilderBaseSimpleJavaDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.pub.view.IOlapBuilderViewLogic;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="javaDataView")
public class OlapBuilderJavaDataView
extends OlapBuilderBaseSimpleJavaDataView<IOlapBuilderViewLogic, OlapBuilderJavaDataView, OlapBuilderJavaDataViewLogic> {
    public static final CdProperty CACHED_TABULARDATA_IDS = new CdReadWriteProperty(OlapBuilderJavaDataView.class, "cachedTabularDataIds"){

        public Class<?> getType() {
            return OlapBuilderTabularDataXmlIdentifiers.class;
        }
    };
    @XmlElement(name="cachedTabularDataIds")
    protected List<String> cachedTabularDataIds;
    @XmlTransient
    protected List<IOlapBuilderTabularDataDef> cachedTables = Collections.emptyList();

    public OlapBuilderJavaDataView() {
        this.javaCode = "package " + this.packageName() + ";\nimport java.util.*;\nimport java.lang.*;\nimport org.joda.time.*;\nimport crazydev.iccube.pub.view.*;\nimport crazydev.common.collection.CdIComparableList;\n\npublic class " + this.getJavaClassName() + " implements IOlapBuilderViewLogic\n{\n//\npublic " + this.getJavaClassName() + "(){}\n\n// Initialize your code here if needed (cached tables are already available)\npublic void onInitMainTable(Map<String, IOlapCachedTable> cachedTables, IOlapDataTableDef mainTable)\n{\n}\n\n// Called each time a row from the main table is read\n// row : should not be cached as after the call the row might not be longer accessible (you can copy it using the context)\npublic boolean onNewRow(IOlapViewContext context, Map<String, IOlapCachedTable> cachedTables, IOlapDataTableDef mainTable, IOlapReadOnlyDataRow mainTableRow)\n{\n   final IOlapDataTableRow row = context.copyRow(mainTableRow);\n// or\n// final IOlapDataTableRow row = context.newRow();\n// \n// row.set( \"viewColName\", mainTableRow.getAsDouble(\"mainTableCol\") * 2.3 );\n\n    context.fireRow(row);\n    return true; // false to stop\n}\n\n// Called when all reading is done, you can fire generated rows here\npublic void onProcessingCompleted(IOlapViewContext context, Map<String, IOlapCachedTable> cachedTables)\n{\n}\n\n// Called for each row and cached table, return false to not send the row to the cache\n// public boolean onNewCachedRow(IOlapDataTableDef tableDef, IOlapReadOnlyDataRow row)\n//{ some internal caching; return false; }\n\n// uncomment this if you want to manage synchronization on your own (default is true)\n// public boolean synchronizeOnRow(){return false;}\n}";
    }

    @Override
    @Nullable
    public String getHelpUrl() {
        return "etl_java";
    }

    @Override
    protected String buildJavaClassCode(String javaCode) {
        return javaCode;
    }

    @Override
    protected String getJavaClassName() {
        return "CustomJavaView";
    }

    @Override
    public List<String> getInternalTabularDataIds() {
        List<String> list = super.getInternalTabularDataIds();
        if (this.cachedTabularDataIds != null) {
            list.addAll(this.cachedTabularDataIds);
        }
        return list;
    }

    @Override
    protected List<IOlapBuilderTabularDataDef> getInternalUnderlyings() {
        List<IOlapBuilderTabularDataDef> list = super.getInternalUnderlyings();
        if (this.cachedTables != null) {
            list.addAll(this.cachedTables);
        }
        return list;
    }

    @Override
    protected OlapBuilderJavaDataViewLogic createLogic() {
        return new OlapBuilderJavaDataViewLogic(this);
    }

    @Override
    public void solveDirectReferences(OlapBuilderReferenceSolver referenceSolver) {
        super.solveDirectReferences(referenceSolver);
        if (this.cachedTabularDataIds != null) {
            this.cachedTables = this.cachedTabularDataIds.stream().map(referenceSolver::getTabularData).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    @Override
    public void solveDirectReferencesColumns(OlapBuilderReferenceSolver referenceSolver) {
        super.solveDirectReferencesColumns(referenceSolver);
    }

    @Override
    public void onReferenceSolved(OlapBuilderErrorManager errorManager, CdSortingGraph<IOlapBuilderTabularDataDef> graph) {
        super.onReferenceSolved(errorManager, graph);
        if (!this.cacheMainTable()) {
            this.cachedTables.forEach(dataDef -> graph.setParentChild(this.getName(), dataDef, (Object)this.underlying));
        }
        if (this.cachedTables != null && this.cachedTables.indexOf(this.underlying) != -1) {
            errorManager.addError(OlapBuilderErrorCode.DATA_VIEW_CACHED_TABLE_COLLISSION, new Serializable[0]);
        }
    }

    private boolean cacheMainTable() {
        return false;
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "Java +" + this.getName();
    }

    @Override
    public OlapValidator<OlapBuilderValidationContext, IOlapBuilderSchemaDef, OlapBuilderJavaDataView> getValidator() {
        return new OlapBuilderJavaDataViewValidator();
    }
}

