/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.groupby;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.view.groupby.Aggregators;
import crazydev.iccube.builder.model.impl.view.groupby.OlapBuilderGroupByDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.view.OlapBuilderBaseDataViewValidator;
import java.io.Serializable;
import java.util.HashSet;
import java.util.function.Function;

public class OlapBuilderGroupByDataViewValidator
extends OlapBuilderBaseDataViewValidator<OlapBuilderGroupByDataView> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderGroupByDataView view) {
        super.doValidate(context, schemaDef, view);
        try {
            Function<Integer, Aggregators.AggregateFunction> aggregates = view.getAggregateFunctions();
            HashSet<String> names = new HashSet<String>();
            if (view.getAggreColDefs().size() < view.getAggregateFunctionSize()) {
                context.addError(OlapBuilderGroupByDataView.GROUP_BY, OlapBuilderErrorCode.DATA_GROUP_AGGREGATIONS_SIZE_MISMATCH, (Serializable)Integer.valueOf(view.getAggreColDefs().size()), (Serializable)Integer.valueOf(view.getAggregateFunctionSize()));
            }
            for (int i = 0; i < view.getAggreColDefs().size(); ++i) {
                IOlapBuilderDataColumnDef columnDef = view.getAggreColDefs().get(i);
                Aggregators.AggregateFunction aggreF = aggregates.apply(i);
                String nameForColumn = aggreF.nameForColumn(columnDef.getName());
                if (names.add(nameForColumn)) continue;
                context.addError(OlapBuilderGroupByDataView.AGGREGATEFUNCTION, OlapBuilderErrorCode.DATA_GROUP_DUPLICATED_AGGREGATIONS, new Serializable[]{nameForColumn});
            }
        }
        catch (OlapBuilderErrorException ex) {
            context.addError(OlapBuilderGroupByDataView.AGGREGATEFUNCTION, ex.getError());
        }
    }
}

