/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.groupby;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdSortedList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.model.impl.view.groupby.Aggregator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Aggregators {

    static class Array
    implements Aggregator {
        List<Comparable> values = new ArrayList<Comparable>();

        Array() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            this.values.add(value);
        }

        @Override
        public Comparable value() {
            return this.values.isEmpty() ? null : new CdComparableArray(this.values);
        }
    }

    static class Distinct
    implements Aggregator {
        CdSortedList<Comparable> unique = new CdSortedList(Comparator.naturalOrder());

        Distinct() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            this.unique.addIfMissing((Object)value);
        }

        @Override
        public Comparable value() {
            return this.unique.isEmpty() ? null : new CdComparableArray(this.unique);
        }
    }

    static class Avg
    extends Sum {
        int count;

        Avg() {
        }

        @Override
        public void aggregateDouble(double number) {
            super.aggregateDouble(number);
            ++this.count;
        }

        @Override
        public Comparable value() {
            return this.count == 0 ? null : Double.valueOf(this.sum / (double)this.count);
        }
    }

    static class SumInteger
    implements Aggregator {
        Integer sum;

        SumInteger() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            if (value instanceof Number) {
                int number = ((Number)((Object)value)).intValue();
                this.sum = this.sum == null ? number : this.sum + number;
            }
        }

        @Override
        public Comparable value() {
            return this.sum;
        }
    }

    static class Sum
    extends Numerical {
        Double sum;

        Sum() {
        }

        @Override
        public void aggregateDouble(double number) {
            this.sum = this.sum == null ? number : this.sum + number;
        }

        @Override
        public Comparable value() {
            return this.sum;
        }
    }

    static abstract class Numerical
    implements Aggregator {
        Numerical() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            if (value instanceof Number) {
                this.aggregateDouble(((Number)((Object)value)).doubleValue());
            }
        }

        abstract void aggregateDouble(double var1);
    }

    static class Count
    implements Aggregator {
        int count;

        Count() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            ++this.count;
        }

        @Override
        public Comparable value() {
            return Integer.valueOf(this.count);
        }
    }

    static class Last
    implements Aggregator {
        Comparable val;

        Last() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            this.val = value;
        }

        @Override
        public Comparable value() {
            return this.val;
        }
    }

    static class First
    implements Aggregator {
        Comparable val;

        First() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            this.val = this.val == null ? value : this.val;
        }

        @Override
        public Comparable value() {
            return this.val;
        }
    }

    static class Max
    implements Aggregator {
        Comparable val;

        Max() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            this.val = this.val == null ? value : (this.val.compareTo(value) > 0 ? this.val : value);
        }

        @Override
        public Comparable value() {
            return this.val;
        }
    }

    static class Min
    implements Aggregator {
        Comparable val;

        Min() {
        }

        @Override
        public void _aggregateNotNull(@NotNull Comparable value) {
            this.val = this.val == null ? value : (this.val.compareTo(value) < 0 ? this.val : value);
        }

        @Override
        public Comparable value() {
            return this.val;
        }
    }

    public static enum AggregateFunction {
        DEFAULT,
        SUM,
        SUM_INT,
        AVG,
        COUNT,
        ARRAY,
        DISTINCT,
        MIN,
        MAX,
        FIRST,
        LAST;


        Aggregator build() {
            switch (this.ordinal()) {
                case 3: {
                    return new Avg();
                }
                case 0: 
                case 2: {
                    return new SumInteger();
                }
                case 1: {
                    return new Sum();
                }
                case 7: {
                    return new Min();
                }
                case 8: {
                    return new Max();
                }
                case 5: {
                    return new Array();
                }
                case 6: {
                    return new Distinct();
                }
                case 4: {
                    return new Count();
                }
                case 9: {
                    return new First();
                }
                case 10: {
                    return new Last();
                }
            }
            throw new CdShouldNotBeHereProgrammingException("Unknown aggregation " + this.name());
        }

        public String nameForColumn(String columnName) {
            if (this == FIRST) {
                return columnName;
            }
            return this.name() + "(" + columnName + ")";
        }

        public OlapBuilderInputType getType(OlapBuilderInputType type) {
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 3: {
                    return OlapBuilderInputType.DOUBLE;
                }
                case 2: {
                    return OlapBuilderInputType.INTEGER;
                }
                case 4: {
                    return OlapBuilderInputType.INTEGER;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return type;
                }
            }
            throw new CdShouldNotBeHereProgrammingException("Unknown aggregation " + this.name());
        }

        public boolean isArray() {
            return this == DISTINCT || this == ARRAY;
        }
    }
}

