/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.dump;

import crazydev.common.utils.CdCsvUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderSingleTableDataViewLogic;
import crazydev.iccube.builder.model.impl.view.dump.OlapBuilderDumpDataView;
import crazydev.iccube.fs.OlapFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderDumpDataViewLogic
extends OlapBuilderSingleTableDataViewLogic<OlapBuilderDumpDataView> {
    private PrintStream out;
    private String columnSeparator;

    public OlapBuilderDumpDataViewLogic(OlapBuilderDumpDataView view) {
        super(view);
    }

    @Override
    public List<IOlapBuilderDataColumnDef> doSetupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        this.underlyingColumnDefs.clear();
        List<IOlapBuilderDataColumnDef> underlyings = ((OlapBuilderDumpDataView)this.view).getDirectUnderlying().getSelectedColumns();
        ArrayList<IOlapBuilderDataColumnDef> list = new ArrayList<IOlapBuilderDataColumnDef>(underlyings.size());
        for (int i = 0; i < underlyings.size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = underlyings.get(i);
            IOlapBuilderDataColumnDef forView = columnDef.duplicateForView(null);
            list.add(forView);
            this.underlyingColumnDefs.put(forView, columnDef);
        }
        return list;
    }

    @Override
    public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingStarted(context, tabularData);
        try {
            this.columnSeparator = CdCsvUtils.unescapeJava((String)((OlapBuilderDumpDataView)this.view).getColumnSeparator());
            OlapFile file = ((OlapBuilderDumpDataView)this.view).createFile(context.asRuntimeContext());
            if (file.isDirectory()) {
                file = file.getFileSystem().create(file, ((OlapBuilderDumpDataView)this.view).getName() + "_dump.txt");
            }
            this.out = file.createPrintStream();
            for (IOlapBuilderDataColumnDef column : ((OlapBuilderDumpDataView)this.view).getSelectedColumns()) {
                this.out.print(column.getName());
                this.out.print(this.columnSeparator);
            }
            this.out.println();
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.toString()});
        }
    }

    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        for (IOlapBuilderDataColumnDef column : tabularData.getSelectedColumns()) {
            Comparable value = data.getJavaNativeDataValue(column);
            if (value != null) {
                this.out.print(value);
            }
            this.out.print(this.columnSeparator);
        }
        this.out.println();
        return ((OlapBuilderDumpDataView)this.view).fireTableNewRow(context, originalTable, partition, rowNb, columnDef -> data.getJavaNativeDataValue((IOlapBuilderDataColumnDef)this.underlyingColumnDefs.get(columnDef)));
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        if (this.out != null) {
            this.out.flush();
        }
        super.onTableProcessingCompleted(context, tabularData);
    }

    @Override
    public void onTableProcessingFinally(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        IOUtils.closeQuietly((OutputStream)this.out);
        super.onTableProcessingFinally(context, tabularData);
    }
}

