/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.common;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifiers;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBaseBuilderMultiTableDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataViewLogic;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class OlapBuilderMultiTableDataView<VIEW extends OlapBuilderBaseDataView, LOGIC extends OlapBuilderBaseDataViewLogic<VIEW>>
extends OlapBaseBuilderMultiTableDataView<VIEW, LOGIC> {
    public static final CdProperty TABULAR_DATA = new CdReadWriteProperty(OlapBuilderMultiTableDataView.class, "tabularDataIds"){

        public Class<?> getType() {
            return OlapBuilderTabularDataXmlIdentifiers.class;
        }
    };
    @XmlElement(name="tableId")
    protected List<String> tabularDataIds;
    @XmlTransient
    protected List<IOlapBuilderTabularDataDef> underlyings;

    @Override
    public void solveDirectReferences(OlapBuilderReferenceSolver referenceSolver) {
        this.underlyings = new ArrayList<IOlapBuilderTabularDataDef>();
        List<String> tabularDataIds = this.getInternalTabularDataIds();
        for (String id : tabularDataIds) {
            IOlapBuilderTabularDataDef underlying = referenceSolver.getTabularData(id);
            if (underlying == null) continue;
            this.underlyings.add(underlying);
        }
    }

    @Override
    public List<String> getInternalTabularDataIds() {
        return this.tabularDataIds;
    }

    @Override
    protected List<IOlapBuilderTabularDataDef> getInternalUnderlyings() {
        return this.underlyings == null ? Collections.emptyList() : this.underlyings;
    }
}

