/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.common;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderSchedulingPolicy;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseLanguageDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderMultiTableDataViewLogic;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheTableWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderTableCache;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.view.IOlapCachedTable;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapReadOnlyDataRow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseLanguageDataViewLogic<T extends OlapBuilderBaseLanguageDataView>
extends OlapBuilderMultiTableDataViewLogic<T> {
    protected final Map<String, IOlapBuilderDataColumnDef> mapUnderlyingRows = new HashMap<String, IOlapBuilderDataColumnDef>();
    protected final Map<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> mapViewToUnderlying = new HashMap<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>();
    private final Map<String, IOlapBuilderDataColumnDef> mapRowsName = new HashMap<String, IOlapBuilderDataColumnDef>();
    private final Map<String, OlapBuilderTableCache> tableCacheMap = new ConcurrentHashMap<String, OlapBuilderTableCache>();
    private List<IOlapBuilderDataColumnDef> columns;
    private HashMap<String, IOlapCachedTable> cachedTables;
    private boolean simultaneousRows;
    private ConcurrentHashMap<Integer, Object> isMainTableInitalized = new ConcurrentHashMap();

    public OlapBuilderBaseLanguageDataViewLogic(T view) {
        super(view);
    }

    @Override
    public List<IOlapBuilderDataColumnDef> doSetupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        OlapLoggers.BUILDER.debug((Object)("[view] [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "] set-selected-columns"));
        this.tableCacheMap.clear();
        this.simultaneousRows = ((OlapBuilderBaseLanguageDataView)this.view).schedulingPolicy() != OlapBuilderSchedulingPolicy.POST_ORDER;
        IOlapBuilderTabularDataDef underlying = ((OlapBuilderBaseLanguageDataView)this.view).getDirectUnderlying();
        if (underlying == null) {
            return new ArrayList<IOlapBuilderDataColumnDef>();
        }
        for (IOlapBuilderDataColumnDef underlyingRow : underlying.getSelectedColumns()) {
            this.mapUnderlyingRows.put(underlyingRow.getName(), underlyingRow);
        }
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        List<IOlapBuilderDataColumnDef> resolvedForwardedColDefs = ((OlapBuilderBaseLanguageDataView)this.view).createResolvedForwardedColDefs();
        HashMap<String, IOlapBuilderDataColumnDef> mapForwardedRowsName = new HashMap<String, IOlapBuilderDataColumnDef>();
        for (IOlapBuilderDataColumnDef underlyingRow : resolvedForwardedColDefs) {
            IOlapBuilderDataColumnDef duplicatedForView = underlyingRow.duplicateForView(null);
            columns.add(duplicatedForView);
            mapForwardedRowsName.put(underlyingRow.getName(), underlyingRow);
            this.mapViewToUnderlying.put(duplicatedForView, underlyingRow);
        }
        List<IOlapBuilderDataColumnDef> colDefs = ((OlapBuilderBaseLanguageDataView)this.view).getColDefs();
        for (int i = 0; i < colDefs.size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = colDefs.get(i);
            IOlapBuilderDataColumnDef resolvedDef = (IOlapBuilderDataColumnDef)mapForwardedRowsName.get(columnDef.getName());
            if (resolvedDef != null) {
                if (resolvedDef.getType() == columnDef.getType() && resolvedDef.isArray() == columnDef.isArray()) continue;
                columns.remove(resolvedDef);
                columns.add(columnDef);
                continue;
            }
            columns.add(columnDef);
        }
        this.columns = Collections.unmodifiableList(columns);
        this.refreshColumnCache();
        return columns;
    }

    @Override
    protected void onProcessingPreInit(OlapBuilderContext context) {
        super.onProcessingPreInit(context);
        OlapLoggers.BUILDER.debug((Object)("[view] [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "] on-processing-pre-init (clear-caches)"));
        this.cachedTables = null;
        this.tableCacheMap.clear();
        this.isMainTableInitalized.clear();
    }

    @Override
    public void onTableProcessingPreInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingPreInit(context, tabularData);
        OlapLoggers.BUILDER.debug((Object)("[view] [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "] on-table-processing-pre-init [" + tabularData.getName() + "]"));
        if (this.isNotMainTable(tabularData)) {
            OlapLoggers.BUILDER.debug((Object)("[view] [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "] on-table-processing-pre-init [" + tabularData.getName() + "] cached"));
            this.tableCacheMap.put(tabularData.getName(), new OlapBuilderTableCache(context, tabularData));
        }
    }

    @Override
    protected void onProcessingInit(OlapBuilderContext context) {
        super.onProcessingInit(context);
        this.assertAvailable(context);
    }

    @Override
    public void onTableProcessingInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingInit(context, tabularData);
        OlapLoggers.BUILDER.debug((Object)("[view] [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "] table-processing-init [" + tabularData.getName() + "]"));
    }

    protected void refreshColumnCache() {
        this.mapRowsName.clear();
        this.columns.forEach(column -> this.mapRowsName.put(column.getName(), (IOlapBuilderDataColumnDef)column));
    }

    protected abstract void assertAvailable(OlapBuilderContext var1);

    protected void onInitMainTable(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        OlapLoggers.BUILDER.debug((Object)("[view] [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "] on-init-main-table [" + tabularData.getName() + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        if (this.isNotMainTable(tabularData)) {
            OlapBuilderTableCache cacheTable = this.getCacheTable(tabularData);
            if (cacheTable == null) {
                throw new RuntimeException("internal error: unexpected missing cached table [" + tabularData.getName() + "] in view [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "]");
            }
            if (this.simultaneousRows) {
                Object object = cacheTable.getLock();
                synchronized (object) {
                    this.onNewRowForCache(cacheTable, data, rowNb);
                }
            } else {
                this.onNewRowForCache(cacheTable, data, rowNb);
            }
            return true;
        }
        this.isMainTableInitalized.computeIfAbsent(0, o -> {
            this.onInitMainTable(context, tabularData);
            return true;
        });
        return this.onMainTableNewRowNotSynchronized(context, originalTable, tabularData, partition, rowNb, data);
    }

    protected void onNewRowForCache(OlapBuilderTableCache cacheTable, IOlapBuilderTableRow row, int rowNb) {
        cacheTable.onNewRow(rowNb, row);
    }

    protected boolean onMainTableNewRowNotSynchronized(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        OlapLoggers.BUILDER.debug((Object)("[view] [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "] table-processing-completed [" + tabularData.getName() + "]"));
        if (this.isMainTable(tabularData)) {
            this.onMainTableProcessingCompleted(context, tabularData);
            this.clear();
        } else {
            this.trimToSize(tabularData);
        }
        super.onTableProcessingCompleted(context, tabularData);
    }

    private void clear() {
        OlapLoggers.BUILDER.debug((Object)("[view] [" + ((OlapBuilderBaseLanguageDataView)this.view).getName() + "] clear (clear-caches)"));
        this.tableCacheMap.clear();
        if (this.cachedTables != null) {
            this.cachedTables.clear();
        }
    }

    protected abstract void onMainTableProcessingCompleted(OlapBuilderContext var1, IOlapBuilderTabularDataDef var2);

    protected boolean isNotMainTable(IOlapBuilderTabularDataDef tabularData) {
        return !this.isMainTable(tabularData);
    }

    private boolean isMainTable(IOlapBuilderTabularDataDef tabularData) {
        return tabularData == ((OlapBuilderBaseLanguageDataView)this.view).getDirectUnderlying();
    }

    private OlapBuilderTableCache getCacheTable(IOlapBuilderTabularDataDef tabularData) {
        return this.tableCacheMap.get(tabularData.getName());
    }

    private void trimToSize(IOlapBuilderTabularDataDef table) {
        OlapBuilderTableCache cacheTable = this.getCacheTable(table);
        if (cacheTable != null) {
            cacheTable.trimToSize();
        }
    }

    protected Map<String, IOlapCachedTable> getCachedTables() {
        if (this.cachedTables == null) {
            this.cachedTables = this.doCachedTables();
        }
        return this.cachedTables;
    }

    @NotNull
    private synchronized HashMap<String, IOlapCachedTable> doCachedTables() {
        if (this.cachedTables == null) {
            HashMap<String, IOlapCachedTable> cached = new HashMap<String, IOlapCachedTable>(this){
                final /* synthetic */ OlapBuilderBaseLanguageDataViewLogic this$0;
                {
                    OlapBuilderBaseLanguageDataViewLogic olapBuilderBaseLanguageDataViewLogic = this$0;
                    Objects.requireNonNull(olapBuilderBaseLanguageDataViewLogic);
                    this.this$0 = olapBuilderBaseLanguageDataViewLogic;
                }

                @Override
                public IOlapCachedTable get(Object key) {
                    IOlapCachedTable table = (IOlapCachedTable)super.get(key);
                    if (table == null) {
                        table = (IOlapCachedTable)super.get(String.valueOf(key) + " (buffer)");
                    }
                    if (table == null) {
                        throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"There is no table with name [" + String.valueOf(key) + "] in the cache : " + String.valueOf(this.keySet())});
                    }
                    return table;
                }
            };
            this.tableCacheMap.forEach((key, table) -> cached.put(table.getTableName(), new OlapBuilderCacheTableWrapper((OlapBuilderTableCache)table)));
            return cached;
        }
        return this.cachedTables;
    }

    public boolean simultaneousRows() {
        return this.simultaneousRows;
    }

    protected OlapBuilderMultiTableDataViewLogic.OlapNewDataRow emptyRow() {
        return new OlapBuilderMultiTableDataViewLogic.OlapNewDataRow(((OlapBuilderBaseLanguageDataView)this.view).getName(), this.mapRowsName, this.columns);
    }

    protected OlapBuilderMultiTableDataViewLogic.OlapNewDataRow copyRow(IOlapReadOnlyDataRow rowToCopy) {
        OlapBuilderMultiTableDataViewLogic.OlapNewDataRow newRow = new OlapBuilderMultiTableDataViewLogic.OlapNewDataRow(((OlapBuilderBaseLanguageDataView)this.view).getName(), this.mapRowsName, this.columns);
        rowToCopy.getTableDef().getColumns().forEach(col -> newRow.set(this.mapRowsName.get(col.getName()), rowToCopy.get((IOlapColumnDef)col)));
        return newRow;
    }
}

