/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.common;

import crazydev.common.math.CdSortingGraph;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifier;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderSchedulingPolicy;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.view.common.OlapBaseBuilderMultiTableDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseLanguageDataViewLogic;
import crazydev.iccube.builder.model.impl.view.javascript.OlapBuilderViewForwardedColumnType;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroupId;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapBuilderBaseLanguageDataView<N extends OlapBuilderBaseLanguageDataView, T extends OlapBuilderBaseLanguageDataViewLogic<N>>
extends OlapBaseBuilderMultiTableDataView<N, T> {
    public static final CdProperty TABULAR_DATA = new CdReadWriteProperty(OlapBuilderBaseLanguageDataView.class, "tabularDataId"){

        public Class<?> getType() {
            return OlapBuilderTabularDataXmlIdentifier.class;
        }
    };
    public static final CdProperty SCHEDULING_POLICY = new CdReadWriteProperty(OlapBuilderBaseLanguageDataView.class, "rowSchedulingPolicy");
    public static final CdProperty FORWARD_COLUMN_TYPE = new CdReadWriteProperty(OlapBuilderBaseLanguageDataView.class, "forwardedColumnType");
    public static final CdProperty FORWARD_COLUMN_REFS = new CdReadWriteProperty(OlapBuilderBaseLanguageDataView.class, "forwardedColRefs");
    public static final CdProperty COLUMN_DEFS = new CdReadWriteProperty(OlapBuilderBaseLanguageDataView.class, "columnDefs"){

        public Object get(Object bean) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
            return super.get(bean);
        }

        public void set(Object bean, Object value) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
            super.set(bean, value);
            try {
                OlapBuilderBaseDataView.synchronizeColumns(((OlapBuilderBaseLanguageDataView)bean)::setColDefs, (String)value);
            }
            catch (IOException | RuntimeException ex) {
                OlapLoggers.BUILDER_VIEW_JAVASCRIPT.error((Object)"[builder] UI columns error", (Throwable)ex);
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_VIEW_JS_COLS, ex);
            }
        }
    };
    @XmlAttribute(name="tableId")
    protected String tabularDataId;
    @XmlTransient
    protected IOlapBuilderTabularDataDef underlying;
    @XmlElement(name="columnDefs", required=false)
    private String columnDefs;
    @XmlElements(value={@XmlElement(name="column", type=OlapBuilderDataColumn.class)})
    private List<IOlapBuilderDataColumnDef> colDefs;
    @XmlElement(name="rowSchedulingPolicy", required=false)
    @Nullable
    private OlapBuilderSchedulingPolicy rowSchedulingPolicy;
    @XmlElement(name="forwardedColumnType", required=true)
    private OlapBuilderViewForwardedColumnType forwardedColumnType = OlapBuilderViewForwardedColumnType.ALL;
    @XmlElement(name="forwardedColumnRef", required=false)
    private List<OlapBuilderDataColumnRef> forwardedColRefs;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> forwardedColDefs;

    public OlapBuilderBaseLanguageDataView() {
    }

    public OlapBuilderBaseLanguageDataView(String name, IOlapBuilderTabularDataDef underlying) {
        super(name);
        this.underlying = underlying;
    }

    @Override
    public UxBuilderDataViewTypeGroupId getUxGroupId() {
        return UxBuilderDataViewTypeGroupId.dvTypeGroupSourceCode;
    }

    public IOlapBuilderTabularDataDef getDirectUnderlying() {
        return this.underlying;
    }

    @Override
    public void solveDirectReferencesColumns(OlapBuilderReferenceSolver referenceSolver) {
        super.solveDirectReferencesColumns(referenceSolver);
        this.forwardedColDefs = referenceSolver.getColumns(this.underlying, this.forwardedColRefs);
    }

    @Override
    public void onReferenceSolved(OlapBuilderErrorManager errorManager, CdSortingGraph<IOlapBuilderTabularDataDef> graph) {
        super.onReferenceSolved(errorManager, graph);
        graph.setOneOneRelation((Object)this.underlying, (Object)this);
    }

    @Override
    public void solveDirectReferences(OlapBuilderReferenceSolver referenceSolver) {
        this.underlying = referenceSolver.getTabularData(this.tabularDataId);
        this.forwardedColDefs = null;
    }

    public String getColumnDefs() {
        return this.columnDefs;
    }

    public void setColumnDefs(String columnDefs) {
        this.columnDefs = columnDefs;
    }

    @Override
    public OlapBuilderSchedulingPolicy schedulingPolicy() {
        return this.rowSchedulingPolicy;
    }

    public List<IOlapBuilderDataColumnDef> getColDefs() {
        if (this.colDefs == null) {
            return Collections.emptyList();
        }
        return this.colDefs;
    }

    public void setColDefs(List<IOlapBuilderDataColumnDef> colDefs) {
        this.colDefs = colDefs;
    }

    public OlapBuilderViewForwardedColumnType getForwardedColumnType() {
        return this.forwardedColumnType;
    }

    public void setForwardedColumnType(OlapBuilderViewForwardedColumnType forwardedColumnType) {
        this.forwardedColumnType = forwardedColumnType;
    }

    public void setForwardedColRefs(List<OlapBuilderDataColumnRef> forwardedColRefs) {
        this.forwardedColRefs = forwardedColRefs;
    }

    public List<IOlapBuilderDataColumnDef> getForwardedColDefs() {
        if (this.forwardedColDefs != null) {
            return this.forwardedColDefs;
        }
        return Collections.emptyList();
    }

    public List<IOlapBuilderDataColumnDef> createResolvedForwardedColDefs() {
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        if (this.underlying == null) {
            return columns;
        }
        List<IOlapBuilderDataColumnDef> tColumns = this.underlying.getSelectedColumns();
        OlapBuilderViewForwardedColumnType forwardedColDefsType = this.getForwardedColumnType();
        List<IOlapBuilderDataColumnDef> forwardedColDefs = this.getForwardedColDefs();
        switch (forwardedColDefsType) {
            case ALL: {
                columns.addAll(tColumns);
                break;
            }
            case ALL_BUT_SELECTION: {
                for (IOlapBuilderDataColumnDef tColumn : tColumns) {
                    if (forwardedColDefs.contains(tColumn)) continue;
                    columns.add(tColumn);
                }
                break;
            }
            case SELECTION: {
                columns.addAll(forwardedColDefs);
                break;
            }
        }
        return columns;
    }

    public String getTabularDataId() {
        return this.tabularDataId;
    }

    @Override
    public List<String> getInternalTabularDataIds() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.tabularDataId != null) {
            list.add(this.tabularDataId);
        }
        return list;
    }

    @Override
    protected List<IOlapBuilderTabularDataDef> getInternalUnderlyings() {
        ArrayList<IOlapBuilderTabularDataDef> list = new ArrayList<IOlapBuilderTabularDataDef>();
        if (this.underlying != null) {
            list.add(this.underlying);
        }
        return list;
    }
}

