/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.common;

import crazydev.common.math.CdSortingGraph;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataViewLogic;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OlapBaseBuilderMultiTableDataView<VIEW extends OlapBuilderBaseDataView, LOGIC extends OlapBuilderBaseDataViewLogic<VIEW>>
extends OlapBuilderBaseDataView<VIEW, LOGIC> {
    public OlapBaseBuilderMultiTableDataView() {
    }

    public OlapBaseBuilderMultiTableDataView(String name) {
        super(name);
    }

    @Override
    public boolean hasDirectUnderlying(String id) {
        List<String> tabularDataIds = this.getInternalTabularDataIds();
        return tabularDataIds != null && tabularDataIds.contains(id);
    }

    @Override
    public abstract List<String> getInternalTabularDataIds();

    @Override
    protected List<IOlapBuilderDataColumnDef> doCreateSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        return this.logic.setupSelectedColumns(errorManager, referenceSolver);
    }

    @Override
    public void onReferenceSolved(OlapBuilderErrorManager errorManager, CdSortingGraph<IOlapBuilderTabularDataDef> graph) {
        super.onReferenceSolved(errorManager, graph);
        this.logic.onReferenceSolved(errorManager);
    }

    @Override
    public void onReferenceSolvedFinished(OlapBuilderErrorManager errorManager) {
        super.onReferenceSolvedFinished(errorManager);
    }

    @Override
    public List<IOlapBuilderTabularDataDef> getDirectUnderlyings() {
        ArrayList<IOlapBuilderTabularDataDef> tables = new ArrayList<IOlapBuilderTabularDataDef>();
        List<IOlapBuilderTabularDataDef> internalUnderlyings = this.getInternalUnderlyings();
        if (internalUnderlyings != null) {
            tables.addAll(internalUnderlyings);
        }
        return tables;
    }

    @NotNull
    protected StringBuilder getFriendlyNames(List<IOlapBuilderTabularDataDef> underlyings) {
        StringBuilder sb = new StringBuilder();
        if (underlyings != null) {
            for (IOlapBuilderTabularDataDef underlying : underlyings) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(underlying.getName());
            }
        } else {
            sb.append("<null>");
        }
        return sb;
    }

    protected abstract List<IOlapBuilderTabularDataDef> getInternalUnderlyings();

    public int getDirectUnderlyingsCount() {
        List<IOlapBuilderTabularDataDef> underlyings = this.getInternalUnderlyings();
        return underlyings != null ? underlyings.size() : 0;
    }

    @Override
    protected void doConnectToUnderlyingTables() {
        List<IOlapBuilderTabularDataDef> underlyings = this.getInternalUnderlyings();
        if (underlyings != null) {
            for (IOlapBuilderTabularDataDef underlying : underlyings) {
                underlying.addListener(this.logic);
            }
        }
    }

    @Override
    protected void doDisconnectFromUnderlyingTables() {
        List<IOlapBuilderTabularDataDef> underlyings = this.getInternalUnderlyings();
        if (underlyings != null) {
            for (IOlapBuilderTabularDataDef underlying : underlyings) {
                underlying.removeListener(this.logic);
            }
        }
    }

    @Override
    public void undoSwitchTableIfColliding(String toId) {
        String viewId = this.getId();
        List<String> tabularDataIds = this.getInternalTabularDataIds();
        for (int i = 0; i < tabularDataIds.size(); ++i) {
            String id = tabularDataIds.get(i);
            if (!viewId.equals(id)) continue;
            tabularDataIds.set(i, toId);
        }
    }

    @Override
    public void onReferenceStarted() {
        super.onReferenceStarted();
        List<IOlapBuilderTabularDataDef> internalUnderlyings = this.getInternalUnderlyings();
        for (IOlapBuilderTabularDataDef underlying : internalUnderlyings) {
            underlying.onReferenceStarted();
        }
    }
}

