/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.colsrows;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRow;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.view.colsrows.OlapBuilderColsRowsDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderSingleTableDataViewLogic;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderColsRowsDataViewLogic
extends OlapBuilderSingleTableDataViewLogic<OlapBuilderColsRowsDataView> {
    private volatile int rowNumber;
    private final List<ToColumnInfo> toColInfos = new ArrayList<ToColumnInfo>();
    private final List<IOlapBuilderDataColumnDef> fromIdxCols = new ArrayList<IOlapBuilderDataColumnDef>();
    private final List<String> fromIdxColsIds = new ArrayList<String>();

    public OlapBuilderColsRowsDataViewLogic(OlapBuilderColsRowsDataView view) {
        super(view);
    }

    @Override
    public List<IOlapBuilderDataColumnDef> doSetupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        Object toCol;
        List<IOlapBuilderDataColumnDef> colDefs;
        this.toColInfos.clear();
        this.fromIdxCols.clear();
        this.fromIdxColsIds.clear();
        IOlapBuilderTabularDataDef underlying = ((OlapBuilderColsRowsDataView)this.view).getDirectUnderlying();
        if (underlying == null) {
            return new ArrayList<IOlapBuilderDataColumnDef>();
        }
        List<IOlapBuilderDataColumnDef> underlyingColumns = underlying.getSelectedColumns();
        if (((OlapBuilderColsRowsDataView)this.view).inverseColSelection()) {
            List<IOlapBuilderDataColumnDef> userSelectedColDefs = ((OlapBuilderColsRowsDataView)this.view).getColDefs();
            colDefs = new ArrayList<IOlapBuilderDataColumnDef>();
            for (IOlapBuilderDataColumnDef underlyingColumn : underlyingColumns) {
                if (userSelectedColDefs.contains(underlyingColumn)) continue;
                toCol = underlyingColumn.duplicateForView(null);
                toCol.setIndex(underlyingColumn.getIndex());
                colDefs.add((IOlapBuilderDataColumnDef)toCol);
            }
        } else {
            colDefs = ((OlapBuilderColsRowsDataView)this.view).getColDefs();
        }
        ArrayList<IOlapBuilderDataColumnDef> toCols = new ArrayList<IOlapBuilderDataColumnDef>();
        for (IOlapBuilderDataColumnDef underlyingColumn : underlyingColumns) {
            if (colDefs.contains(underlyingColumn)) continue;
            toCol = underlyingColumn.duplicateForView(null);
            toCols.add((IOlapBuilderDataColumnDef)toCol);
            this.toColInfos.add(new ToColumnInfo((IOlapBuilderDataColumnDef)toCol, ToColumnKind.FORWARDED, underlyingColumn));
        }
        OlapBuilderInputType valType = null;
        String valTableType = null;
        for (IOlapBuilderDataColumnDef colDef : colDefs) {
            if (valType == null) {
                valType = colDef.getType();
                valTableType = colDef.getTableType();
            }
            this.fromIdxCols.add(colDef);
        }
        for (int ii = 0; ii < colDefs.size(); ++ii) {
            String id = ((OlapBuilderColsRowsDataView)this.view).getIndexColumnNameContent(colDefs, ii);
            this.fromIdxColsIds.add(id);
        }
        String indexColName = ((OlapBuilderColsRowsDataView)this.view).getIndexColumnName();
        OlapBuilderDataColumn toCol2 = new OlapBuilderDataColumn(OlapBuilderColsRowsDataViewLogic.idColumnType(this.fromIdxColsIds, ((OlapBuilderColsRowsDataView)this.view).getIndexColumnType()), OlapBuilderInputType.STRING.name(), indexColName);
        toCols.add(toCol2);
        this.toColInfos.add(new ToColumnInfo(toCol2, ToColumnKind.INDEX, null));
        String valueColName = ((OlapBuilderColsRowsDataView)this.view).getValueColumnName();
        OlapBuilderDataColumn toCol3 = new OlapBuilderDataColumn(valType, valTableType, valueColName);
        toCols.add(toCol3);
        this.toColInfos.add(new ToColumnInfo(toCol3, ToColumnKind.VALUE, null));
        return toCols;
    }

    private static OlapBuilderInputType idColumnType(List<String> ids, @Nullable OlapBuilderInputType definedColumnType) {
        if (definedColumnType != null) {
            return definedColumnType;
        }
        boolean numeric = true;
        for (String id : ids) {
            try {
                Integer.parseInt(id);
            }
            catch (NumberFormatException ex) {
                numeric = false;
                break;
            }
        }
        if (!numeric) {
            return OlapBuilderInputType.STRING;
        }
        return OlapBuilderInputType.INTEGER;
    }

    @Override
    public void onProcessingInit(OlapBuilderContext context) {
        super.onProcessingInit(context);
        this.rowNumber = 0;
        if (this.toColInfos.isEmpty()) {
            throw new RuntimeException("internal error: inconsistent column setup (tpi-1)");
        }
        if (this.fromIdxCols.isEmpty()) {
            throw new RuntimeException("internal error: inconsistent column setup (tpi-2)");
        }
        if (this.fromIdxColsIds.size() != this.fromIdxCols.size()) {
            throw new RuntimeException("internal error: inconsistent column setup (tpi-4)");
        }
    }

    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        for (int ii = 0; ii < this.fromIdxCols.size(); ++ii) {
            IOlapBuilderDataColumnDef fromIdxCol = this.fromIdxCols.get(ii);
            Object[] values = new Object[this.toColInfos.size()];
            block6: for (ToColumnInfo toColInfo : this.toColInfos) {
                switch (toColInfo.toColKind.ordinal()) {
                    case 0: {
                        if (toColInfo.fromCol == null) {
                            throw new RuntimeException("internal error: inconsistent column setup (nr-1)");
                        }
                        values[toColInfo.toCol.getIndex()] = data.getJavaNativeDataValue(toColInfo.fromCol);
                        continue block6;
                    }
                    case 1: {
                        values[toColInfo.toCol.getIndex()] = this.fromIdxColsIds.get(ii);
                        continue block6;
                    }
                    case 2: {
                        values[toColInfo.toCol.getIndex()] = data.getJavaNativeDataValue(fromIdxCol);
                        continue block6;
                    }
                }
                throw new RuntimeException("internal error: inconsistent column setup (nr-2)");
            }
            OlapBuilderTableRow row = new OlapBuilderTableRow(values);
            if (((OlapBuilderColsRowsDataView)this.view).fireTableNewRow(context, originalTable, partition, ++this.rowNumber, row)) continue;
            return false;
        }
        return true;
    }

    static class ToColumnInfo {
        final IOlapBuilderDataColumnDef toCol;
        final ToColumnKind toColKind;
        @Nullable
        final IOlapBuilderDataColumnDef fromCol;

        public ToColumnInfo(IOlapBuilderDataColumnDef toCol, ToColumnKind toColKind, @Nullable IOlapBuilderDataColumnDef fromCol) {
            this.toCol = toCol;
            this.toColKind = toColKind;
            if (toColKind == ToColumnKind.FORWARDED && fromCol == null) {
                throw new RuntimeException("internal error: inconsistent column setup (tci-1)");
            }
            if (toColKind != ToColumnKind.FORWARDED && fromCol != null) {
                throw new RuntimeException("internal error: inconsistent column setup (tci-2)");
            }
            this.fromCol = fromCol;
        }
    }

    static enum ToColumnKind {
        FORWARDED,
        INDEX,
        VALUE;

    }
}

