/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.table;

import crazydev.common.collection.CdAction;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderDataTableListeners {
    private final List<IOlapBuilderTableListener> listeners = new ArrayList<IOlapBuilderTableListener>();

    public List<IOlapBuilderTableListener> listeners() {
        return this.listeners;
    }

    public boolean isForFactBuilding() {
        for (IOlapBuilderTableListener listener : this.listeners) {
            if (listener.isForFactBuilding()) continue;
            return false;
        }
        return true;
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void addListener(IOlapBuilderTableListener listener) {
        if (listener == null) {
            throw new RuntimeException("internal error: inconsistent table listeners usage");
        }
        this.listeners.add(listener);
    }

    public void removeListener(IOlapBuilderTableListener listener) {
        this.listeners.remove(listener);
    }

    public void clearAllListeners() {
        this.listeners.clear();
    }

    public void forEachListener(CdAction<IOlapBuilderTableListener> action) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            action.apply((Object)listener);
        }
    }

    public void fireTableProcessingPreInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            listener.onTableProcessingPreInit(context, tabularData);
        }
        if (context.isIncrLoadLogRows()) {
            OlapLoggers.BUILDER_INCR_LOAD_ROWS.debug((Object)String.format("[incr-load-rows] processing-pre-init [%s:%s]", tabularData.isView(), tabularData.getName()));
        }
    }

    public void fireTableProcessingInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            listener.onTableProcessingInit(context, tabularData);
        }
        if (context.isIncrLoadLogRows()) {
            OlapLoggers.BUILDER_INCR_LOAD_ROWS.debug((Object)String.format("[incr-load-rows] processing-init [%s:%s]", tabularData.isView(), tabularData.getName()));
        }
    }

    public void fireTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            listener.onTableProcessingStarted(context, tabularData);
        }
        if (context.isIncrLoadLogRows()) {
            OlapLoggers.BUILDER_INCR_LOAD_ROWS.debug((Object)String.format("[incr-load-rows] processing-started [%s:%s]", tabularData.isView(), tabularData.getName()));
        }
    }

    public boolean fireTableNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData, IOlapBuilderTabularDataDef originalTable, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partitionKey, int rowNb, IOlapBuilderTableRow data) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            if (listener.onNewRow(context, originalTable, tabularData, columns, partitionKey, rowNb, data)) continue;
            return false;
        }
        if (context != null && context.isIncrLoadLogRows()) {
            OlapLoggers.BUILDER_INCR_LOAD_ROWS.debug((Object)String.format("[incr-load-rows] processing-row [%s:%s] [%s:%s] [%s] [%s]", tabularData.isView(), tabularData.getName(), originalTable.isView(), originalTable.getName(), partitionKey, rowNb));
        }
        return true;
    }

    public boolean fireTableNewRows(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData, IOlapBuilderTabularDataDef originalTable, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partitionKey, int batchRowOffset, List<IOlapBuilderTableRow> rows) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            if (listener.onNewRows(context, originalTable, tabularData, columns, partitionKey, batchRowOffset, rows)) continue;
            return false;
        }
        if (context.isIncrLoadLogRows()) {
            OlapLoggers.BUILDER_INCR_LOAD_ROWS.debug((Object)String.format("[incr-load-rows] processing-rows [%s:%s] [%s:%s] [%s] [%s] [%s]", tabularData.isView(), tabularData.getName(), originalTable.isView(), originalTable.getName(), partitionKey, batchRowOffset, rows.size()));
        }
        return true;
    }

    public void fireTableRowsProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData, IOlapBuilderTablePartitionKey tablePartitionKey) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            listener.onTableRowsProcessingCompleted(context, tabularData, tablePartitionKey);
        }
    }

    public void fireTableRowsProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            listener.onTableRowsProcessingCompleted(context, tabularData);
        }
    }

    public void fireTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            listener.onTableProcessingCompleted(context, tabularData);
        }
        if (context.isIncrLoadLogRows()) {
            OlapLoggers.BUILDER_INCR_LOAD_ROWS.debug((Object)String.format("[incr-load-rows] processing-completed [%s:%s]", tabularData.isView(), tabularData.getName()));
        }
    }

    public void fireTableProcessingFinally(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        for (IOlapBuilderTableListener listener : this.listeners) {
            listener.onTableProcessingFinally(context, tabularData);
        }
        if (context.isIncrLoadLogRows()) {
            OlapLoggers.BUILDER_INCR_LOAD_ROWS.debug((Object)String.format("[incr-load-rows] processing-finally [%s:%s]", tabularData.isView(), tabularData.getName()));
        }
    }
}

