/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.table;

import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableFilter;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderDataTableFilters;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderViewCycleDetector;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapBuilderBaseTabularDataTable
implements IOlapBuilderTabularDataDef,
Cloneable {
    @XmlTransient
    private final OlapBuilderDataTableFilters filters = new OlapBuilderDataTableFilters();
    @XmlAttribute(required=true)
    protected String id;
    @XmlAttribute(required=false)
    @Nullable
    protected String description;

    public <VIEW extends OlapBuilderBaseDataView> OlapBuilderBaseTabularDataTable() {
        this.id = UUID.randomUUID().toString();
    }

    public <VIEW extends OlapBuilderBaseDataView> OlapBuilderBaseTabularDataTable(OlapBuilderBaseDataView dataTable) {
        this.id = dataTable.id;
        this.description = dataTable.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String resetId() {
        this.id = UUID.randomUUID().toString();
        return this.id;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public IOlapBuilderDataColumnDef lookupSelectedColumn(@Nullable String columnName) {
        return OlapBuilderDataColumn.lookupColumn(this.getSelectedColumns(), columnName);
    }

    @Override
    public void solveReferences(OlapBuilderReferenceSolver referenceSolver, OlapBuilderViewCycleDetector cycleDetector) {
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getActualSelectedColumns() {
        List<IOlapBuilderDataColumnDef> selectedColumns = this.getSelectedColumns();
        if (selectedColumns == null || selectedColumns.isEmpty()) {
            return selectedColumns;
        }
        if (!this.canCleanupNotUsedColumns()) {
            return selectedColumns;
        }
        ArrayList<IOlapBuilderDataColumnDef> actualSelectedColumns = new ArrayList<IOlapBuilderDataColumnDef>();
        for (IOlapBuilderDataColumnDef selectedColumn : selectedColumns) {
            if (!selectedColumn.isForTableSelect()) continue;
            actualSelectedColumns.add(selectedColumn);
        }
        return actualSelectedColumns;
    }

    @Override
    public void clearAllRowFilters() {
        this.filters.clearAllFilters();
    }

    @Override
    public void addRowFilter(IOlapBuilderTableFilter filter) {
        this.filters.addFilter(filter);
    }

    public OlapBuilderDataTableFilters getRowFilters() {
        return this.filters;
    }
}

