/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.table;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRow;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OlapBuilderBaseDataTableRows {
    private final boolean sortedColumns;
    private final IOlapBuilderTabularDataDef table;
    private final List<OlapBuilderBaseDataTableRow> rows;

    public OlapBuilderBaseDataTableRows(IOlapBuilderTabularDataDef table, List<OlapBuilderBaseDataTableRow> rows) {
        this(false, table, rows);
    }

    public OlapBuilderBaseDataTableRows(boolean sortedColumns, IOlapBuilderTabularDataDef table, List<OlapBuilderBaseDataTableRow> rows) {
        this.sortedColumns = sortedColumns;
        this.table = table;
        this.rows = rows;
    }

    public List<IOlapBuilderDataColumnDef> getColumns() {
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        columns.add(new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "Integer", "Line/Row"));
        if (!this.sortedColumns) {
            columns.addAll(this.table.getSelectedColumns());
        } else {
            columns.addAll(this.table.getSortedSelectedColumns());
        }
        return columns;
    }

    public List<OlapBuilderBaseDataTableRow> getRows() {
        return this.rows;
    }

    public OlapBuilderBaseDataTableRows sort() {
        Map<String, Integer> sortedColumnsPos;
        List<IOlapBuilderDataColumnDef> columns = this.table.getSelectedColumns();
        List<IOlapBuilderDataColumnDef> sortedColumns = this.table.getSortedSelectedColumns();
        Map<String, Integer> columnsPos = IOlapBuilderDataTableDef.createAllColumnsPositions(columns);
        if (!OlapBuilderBaseDataTableRows.isConsistent(columnsPos, sortedColumnsPos = IOlapBuilderDataTableDef.createAllColumnsPositions(sortedColumns))) {
            return this;
        }
        int[] positions = new int[columns.size()];
        for (int ii = 0; ii < columns.size(); ++ii) {
            IOlapBuilderDataColumnDef column = columns.get(ii);
            positions[ii] = sortedColumnsPos.get(column.getName());
        }
        ArrayList<OlapBuilderBaseDataTableRow> sRows = new ArrayList<OlapBuilderBaseDataTableRow>();
        for (OlapBuilderBaseDataTableRow row : this.rows) {
            sRows.add(row.sort(positions));
        }
        return new OlapBuilderBaseDataTableRows(true, this.table, sRows);
    }

    private static boolean isConsistent(Map<String, Integer> columnsPos, Map<String, Integer> sortedColumnsPos) {
        Set<String> columnsPosKeys = columnsPos.keySet();
        Set<String> sortedColumnsPosKeys = sortedColumnsPos.keySet();
        return columnsPosKeys.containsAll(sortedColumnsPosKeys);
    }
}

