/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.table;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdSetList;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderCacheTableHelper;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.datasource.reader.OlapBuilderTableFilteringRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseTabularDataTable;
import crazydev.iccube.builder.model.impl.table.OlapBuilderDataTableFilters;
import crazydev.iccube.builder.model.impl.table.OlapBuilderDataTableListeners;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderViewCycleDetector;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.offline.read.OlapBuilderOfflineReadHelper;
import crazydev.iccube.builder.offline.write.OlapBuilderOfflineWriteHelper;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.goodies.incrload.IncrLoadDefaultMarker;
import crazydev.iccube.olap.goodies.incrload.IncrLoadMarker;
import crazydev.iccube.olap.goodies.incrload.IncrLoadTableSavePoint;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapBuilderBaseDataTable<CONNECTION extends IOlapBuilderConnection>
extends OlapBuilderBaseTabularDataTable
implements IOlapBuilderDataTableDef<CONNECTION> {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderBaseDataTable.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderBaseDataTable.class, "description");
    public static final CdProperty IS_NAME_READONLY = new CdReadProperty(OlapBuilderBaseDataTable.class, "nameReadOnly");
    public static final CdProperty ALL_PERSISTENT_COLUMNS = new CdReadWriteProperty(OlapBuilderBaseDataTable.class, "columns");
    public static final CdProperty INCREMENTAL_LOAD_STRATEGY = new CdReadWriteProperty(OlapBuilderBaseDataTable.class, "incrementalLoadStrategy"){

        public boolean isForIncrLoad() {
            return true;
        }
    };
    public static final CdProperty INCREMENTAL_LOAD_COLUMN_NAME = new CdReadWriteProperty(OlapBuilderBaseDataTable.class, "incrementalLoadColumnName"){

        public boolean isForIncrLoad() {
            return true;
        }
    };
    public static final CdProperty PARTITIONING_COLUMN_NAME = new CdReadWriteProperty(OlapBuilderBaseDataTable.class, "partitioningColumnName"){

        public boolean isForPartitioning() {
            return true;
        }
    };
    private static final String PARTITIONING_COLUMN_NAME_SEP = "& &";
    @XmlTransient
    private final OlapBuilderDataTableListeners listeners = new OlapBuilderDataTableListeners();
    @XmlAttribute(required=false)
    @Nullable
    protected String incrementalLoadColumnName;
    @XmlTransient
    protected boolean hasPreInit;
    @XmlTransient
    protected boolean hasInit;
    @XmlTransient
    @Nullable
    protected Integer depth;
    @XmlAttribute(required=false)
    @Nullable
    private String partitioningColumnName;
    @XmlAttribute(required=true)
    private String tableName;
    @XmlAttribute(required=false)
    @Nullable
    private OlapIncrementalLoadStrategy incrementalLoadStrategy;
    @XmlAttribute(required=false)
    private final int rowLimit = -1;
    @XmlElements(value={@XmlElement(name="column", type=OlapBuilderDataColumn.class)})
    private List<IOlapBuilderDataColumnDef> columns;
    @XmlTransient
    private OlapBuilderBaseDataSource<CONNECTION> dataSource;

    protected OlapBuilderBaseDataTable() {
        this((String)null);
    }

    protected OlapBuilderBaseDataTable(String tableName) {
        this(tableName, new ArrayList<IOlapBuilderDataColumnDef>());
    }

    protected OlapBuilderBaseDataTable(String tableName, String description) {
        this(tableName);
        this.description = description;
    }

    protected OlapBuilderBaseDataTable(String tableName, List<IOlapBuilderDataColumnDef> columns) {
        this.tableName = tableName;
        this.columns = columns;
    }

    public boolean isColumnPositionRelevant() {
        return false;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean canCleanupNotUsedColumns() {
        return false;
    }

    @Override
    public boolean canCleanupNotUsedColumn(IOlapBuilderDataColumnDef column) {
        return this.canCleanupNotUsedColumns() && !this.isIncrLoadColumn(column) && !this.isPartitioningColumn(column);
    }

    public boolean isIncrLoadColumn(IOlapBuilderDataColumnDef column) {
        String cName = column.getName();
        return this.incrementalLoadColumnName != null && this.incrementalLoadColumnName.equals(cName);
    }

    public boolean isPartitioningColumn(IOlapBuilderDataColumnDef column) {
        String columnName = column.getName();
        String pColumnName = this.getPartitioningColumnNameX();
        if (pColumnName == null) {
            return false;
        }
        return pColumnName.equals(columnName);
    }

    public boolean isNameReadOnly() {
        return true;
    }

    @Override
    @XmlTransient
    public OlapBuilderBaseDataSource<CONNECTION> getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setDataSource(IOlapBuilderDataSource dataSource) {
        this.dataSource = (OlapBuilderBaseDataSource)dataSource;
    }

    @Override
    public void solveReferences(OlapBuilderReferenceSolver referenceSolver, OlapBuilderViewCycleDetector cycleDetector) {
        super.solveReferences(referenceSolver, cycleDetector);
    }

    @Override
    public void solveDirectReferences(OlapBuilderReferenceSolver referenceSolver) {
    }

    @Override
    public List<IOlapBuilderTabularDataDef> getDirectUnderlyings() {
        ArrayList<IOlapBuilderTabularDataDef> tables = new ArrayList<IOlapBuilderTabularDataDef>();
        tables.add(this);
        return tables;
    }

    @Override
    public CdSetList<IOlapBuilderDataTableDef> getUnderlyingTables() {
        CdSetList tables = new CdSetList();
        tables.add((Object)this);
        return tables;
    }

    @Override
    public Set<IOlapBuilderDataViewDef> getAllViews() {
        return new HashSet<IOlapBuilderDataViewDef>();
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public void setName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isFileNameSorted() {
        return true;
    }

    protected List<IOlapBuilderTableListener> listeners() {
        return this.listeners.listeners();
    }

    @Override
    public void addListener(IOlapBuilderTableListener listener) {
        if (OlapLoggers.BUILDER_LISTENERS.isDebugEnabled()) {
            OlapLoggers.BUILDER_LISTENERS.debug((Object)("[table] [" + this.getName() + "] add-listener " + listener.debug()));
        }
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(IOlapBuilderTableListener listener) {
        if (OlapLoggers.BUILDER_LISTENERS.isDebugEnabled()) {
            OlapLoggers.BUILDER_LISTENERS.debug((Object)("[table] [" + this.getName() + "] remove-listener " + listener.debug()));
        }
        this.listeners.removeListener(listener);
    }

    @Override
    public void clearAllListeners() {
        if (OlapLoggers.BUILDER_LISTENERS.isDebugEnabled()) {
            OlapLoggers.BUILDER_LISTENERS.debug((Object)("[table] [" + this.getName() + "] clear-all-listeners"));
        }
        this.listeners.clearAllListeners();
        this.hasPreInit = false;
        this.hasInit = false;
    }

    @Override
    public void forEachListener(CdAction<IOlapBuilderTableListener> action) {
        this.listeners.forEachListener(action);
    }

    @Override
    public boolean hasListeners() {
        return this.listeners.hasListeners();
    }

    @Override
    public boolean hasPostOrderListener() {
        for (IOlapBuilderTableListener listener : this.listeners.listeners()) {
            if (!listener.hasPostOrderListener(new OlapBuilderViewCycleDetector())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void preInit(OlapBuilderContext context) {
        if (!this.hasPreInit) {
            this.hasPreInit = true;
            OlapLoggers.BUILDER.debug((Object)("[table] [" + this.getName() + "] fire pre-init"));
            this.firePreInit(context);
        }
    }

    protected void firePreInit(OlapBuilderContext context) {
        this.listeners.fireTableProcessingPreInit(context, this);
    }

    @Override
    public void init(OlapBuilderContext context) {
        if (!this.hasInit) {
            this.hasInit = true;
            this.fireInit(context);
        }
        this.setColumnsIndex();
    }

    protected void fireInit(OlapBuilderContext context) {
        this.listeners.fireTableProcessingInit(context, this);
    }

    public void setColumnsIndex() {
        for (int i = 0; i < this.columns.size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = this.columns.get(i);
            columnDef.setIndex(i);
        }
    }

    @Override
    public void onTableRowProcessingStarted(OlapBuilderContext context) {
        this.fireOnProcessingDataStarted(context);
    }

    protected void fireOnProcessingDataStarted(OlapBuilderContext context) {
        this.listeners.fireTableProcessingStarted(context, this);
    }

    @Override
    public void onNewRow(OlapBuilderContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey, int rowNb, IOlapBuilderTableRow data) {
        this.fireOnNewRow(context, partitionKey, rowNb, data);
    }

    @Override
    public void onNewRows(OlapBuilderContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey, List<IOlapBuilderTableRow> rows, int batchRowOffset) {
        this.fireOnNewRows(context, partitionKey, rows, batchRowOffset);
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return null;
    }

    private void fireOnNewRow(OlapBuilderContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey, int rowNb, IOlapBuilderTableRow data) {
        this.listeners.fireTableNewRow(context, this, this, this.columns, partitionKey, rowNb, data);
    }

    private void fireOnNewRows(OlapBuilderContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey, List<IOlapBuilderTableRow> rows, int batchRowOffset) {
        this.listeners.fireTableNewRows(context, this, this, this.columns, partitionKey, batchRowOffset, rows);
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context) {
        this.listeners.fireTableProcessingCompleted(context, this);
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, IOlapBuilderTablePartitionKey tablePartitionKey) {
        this.listeners.fireTableRowsProcessingCompleted(context, this, tablePartitionKey);
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context) {
        this.listeners.fireTableRowsProcessingCompleted(context, this);
    }

    @Override
    public void onTableProcessingFinally(OlapBuilderContext context) {
        this.listeners.fireTableProcessingFinally(context, this);
    }

    @Override
    public int getRowLimit() {
        return -1;
    }

    public final List<? extends IOlapBuilderDataColumnDef> discoverAllColumns(OlapRuntimeContext context, CONNECTION connection, OlapBuilderErrorManager errorManager) {
        try {
            return this.discoverAllColumnsEx(context, connection, errorManager);
        }
        catch (Exception ex) {
            if (ex instanceof OlapBuilderErrorException) {
                throw (OlapBuilderErrorException)((Object)ex);
            }
            OlapLoggers.BUILDER.error((Object)("DB table [" + this.getName() + "] discover columns error"), (Throwable)ex);
            errorManager.addError(OlapBuilderErrorCode.FAILED_TO_LOAD_COLUMNS_FOR_TABLE, new Serializable[]{this.getName(), ex.getLocalizedMessage()});
            return Collections.emptyList();
        }
    }

    public final List<? extends IOlapBuilderDataColumnDef> discoverAllColumnsEx(OlapRuntimeContext context, CONNECTION connection, OlapBuilderErrorManager errorManager) throws Exception {
        List<IOlapBuilderDataColumnDef> list = this.doDiscoverAllColumns(context, connection, errorManager);
        IOlapBuilderDataColumnDef firstDuplicate = (IOlapBuilderDataColumnDef)CdCollections.findFirstDuplicate(list);
        if (firstDuplicate != null) {
            errorManager.addError(OlapBuilderErrorCode.DATATABLE_WITH_DUPLICATED_COLUMNS, new Serializable[]{this.getName(), firstDuplicate.getName()});
            return Collections.emptyList();
        }
        return list;
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, CONNECTION openedConnection, OlapBuilderErrorManager errorManager) throws Exception {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<? extends IOlapBuilderDataColumnDef> discoverAllColumnsForRefresh(OlapRuntimeContext context, CONNECTION connection, OlapBuilderErrorManager errorManager) {
        try {
            errorManager.pushContext(this);
            OlapBuilderErrorManager localErrorManager = new OlapBuilderErrorManager(errorManager.getContext(), false);
            List<IOlapBuilderDataColumnDef> discoveredColumns = this.doDiscoverAllColumnsForRefresh(context, connection, localErrorManager);
            if (localErrorManager.hasErrors()) {
                errorManager.addError(localErrorManager);
                discoveredColumns = null;
            }
            List<IOlapBuilderDataColumnDef> list = discoveredColumns;
            return list;
        }
        finally {
            errorManager.popContext();
        }
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, CONNECTION connection, OlapBuilderErrorManager errorManager) {
        ArrayList<IOlapBuilderDataColumnDef> refreshed = new ArrayList<IOlapBuilderDataColumnDef>();
        List<IOlapBuilderDataColumnDef> allColumns = this.getAllColumns();
        if (allColumns != null) {
            for (IOlapBuilderDataColumnDef columnDef : allColumns) {
                refreshed.add(columnDef);
            }
        }
        return refreshed;
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getAllColumns() {
        return this.columns != null ? this.columns : new ArrayList<IOlapBuilderDataColumnDef>();
    }

    @Override
    public void setAllColumns(List<IOlapBuilderDataColumnDef> columns) {
        this.columns = columns;
    }

    @Nullable
    public IOlapBuilderDataColumnDef lookupColumn(IOlapBuilderDataColumnDef column) {
        if (this.columns == null) {
            return null;
        }
        for (IOlapBuilderDataColumnDef columnDef : this.columns) {
            if (!columnDef.equals(column)) continue;
            return columnDef;
        }
        return null;
    }

    @Nullable
    public Integer lookupColumnPosition(IOlapBuilderDataColumnDef column) {
        if (this.columns == null) {
            return null;
        }
        for (int ii = 0; ii < this.columns.size(); ++ii) {
            IOlapBuilderDataColumnDef columnDef = this.columns.get(ii);
            if (!columnDef.equals(column)) continue;
            return ii;
        }
        return null;
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getSelectedColumns() {
        ArrayList<IOlapBuilderDataColumnDef> selectedColumns = new ArrayList<IOlapBuilderDataColumnDef>();
        int size = this.columns.size();
        for (int ii = 0; ii < size; ++ii) {
            IOlapBuilderDataColumnDef column = this.columns.get(ii);
            if (!column.isSelected()) continue;
            selectedColumns.add(column);
        }
        return selectedColumns;
    }

    @Override
    public IOlapBuilderDataColumnDef getSelectedColumn(int pos) {
        List<IOlapBuilderDataColumnDef> columns = this.getSelectedColumns();
        if (pos >= 0 && pos < columns.size()) {
            return columns.get(pos);
        }
        throw new CdProgrammingException("Missing column [" + pos + "] from view [" + this.getName() + "]!");
    }

    @Override
    public IOlapBuilderDataColumnDef getSelectedColumn(String name) {
        IOlapBuilderDataColumnDef column = this.lookupSelectedColumn(name);
        if (column == null) {
            throw new CdProgrammingException("Missing column [" + name + "] from view [" + this.getName() + "]!");
        }
        return column;
    }

    public void addColumn(IOlapBuilderDataColumnDef columnDef) {
        this.columns.add(columnDef);
    }

    public void addColumns(List<? extends IOlapBuilderDataColumnDef> dataColumns) {
        this.columns.addAll(dataColumns);
    }

    public void resetColumns(List<? extends IOlapBuilderDataColumnDef> dataColumns) {
        this.clearColumns();
        this.addColumns(dataColumns);
        this.setColumnsIndex();
    }

    public void clearColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<IOlapBuilderDataColumnDef>();
        }
        this.columns.clear();
    }

    @Override
    public List<IOlapBuilderTableRowReader> createRowReaders(OlapBuilderContext context, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions, int maxRowCount) {
        List<IOlapBuilderTableRowReader> readers = this.doCreateRowReaders(context, processingSchedulingPolicy, connectionPool, requestedPartitions, maxRowCount);
        readers = this.decorateRowReadersForFilters(context, readers);
        return readers;
    }

    protected List<IOlapBuilderTableRowReader> decorateRowReadersForFilters(OlapBuilderContext context, List<IOlapBuilderTableRowReader> readers) {
        OlapBuilderDataTableFilters filters = this.getRowFilters();
        if (filters.isEmpty()) {
            return readers;
        }
        ArrayList<IOlapBuilderTableRowReader> filteredReaders = new ArrayList<IOlapBuilderTableRowReader>();
        for (IOlapBuilderTableRowReader reader : readers) {
            filteredReaders.add(new OlapBuilderTableFilteringRowReader(reader, filters));
        }
        return filteredReaders;
    }

    protected List<IOlapBuilderTableRowReader> doCreateRowReaders(OlapBuilderContext context, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions, int maxRowCount) {
        ArrayList<IOlapBuilderTableRowReader> readers = new ArrayList<IOlapBuilderTableRowReader>();
        boolean hasPartitioning = this.hasTablePartitioning();
        if (hasPartitioning && !context.isTablePartitioningLicensed()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_PARTITION_NOT_LICENSED, new Serializable[0]);
        }
        if (!hasPartitioning || maxRowCount != -1 || OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER == processingSchedulingPolicy) {
            this.createFullTableRowReader(readers, context, connectionPool, maxRowCount);
        } else {
            this.createPartitionTableRowReaders(readers, context, connectionPool, requestedPartitions);
        }
        return readers;
    }

    private void createFullTableRowReader(List<IOlapBuilderTableRowReader> readers, OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        IOlapBuilderTableRowReader reader = null;
        reader = this.createRowReaderForTableCacheRead(context);
        if (reader == null) {
            reader = this.createRowReaderForOfflineRead(context, null);
        }
        if (reader == null) {
            reader = this.createRowReaderForRestore(context, false);
        }
        if (reader == null) {
            reader = this.doCreateFullTableRowReader(context, connectionPool, maxRowCount);
        }
        reader = this.decorateRowReaderForTableCache(context, reader);
        reader = this.decorateRowReaderForOfflineWrite(context, reader);
        reader = this.decorateRowReaderForBackup(context, reader, false);
        readers.add(reader);
    }

    protected abstract IOlapBuilderTableRowReader<CONNECTION> doCreateFullTableRowReader(OlapBuilderContext var1, OlapBuilderConnectionPool var2, int var3);

    private void createPartitionTableRowReaders(List<IOlapBuilderTableRowReader> readers, OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        List<IOlapBuilderTablePartitionKey> partitionKeys = this.getPartitionKeys(context, connectionPool, requestedPartitions);
        if (partitionKeys.isEmpty()) {
            return;
        }
        for (IOlapBuilderTablePartitionKey partitionKey : partitionKeys) {
            IOlapBuilderTableRowReader reader = null;
            reader = this.createRowReaderForOfflineRead(context, partitionKey);
            if (reader == null) {
                reader = this.createRowReaderForRestore(context, true);
            }
            if (reader == null) {
                reader = this.doCreatePartitionTableRowReaders(context, connectionPool, partitionKey);
            }
            reader = this.decorateRowReaderForOfflineWrite(context, reader);
            reader = this.decorateRowReaderForBackup(context, reader, true);
            readers.add(reader);
        }
    }

    private List<IOlapBuilderTablePartitionKey> getPartitionKeys(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        OlapBuilderOfflineReadHelper readerHelper = context.getOfflineReadHelper();
        List<IOlapBuilderTablePartitionKey> partitionKeys = readerHelper != null ? readerHelper.getPartitionKeys(this) : (context.isRestoring() ? this.doGetPartitionKeys(context, connectionPool, requestedPartitions) : this.doGetPartitionKeys(context, connectionPool, requestedPartitions));
        OlapBuilderOfflineWriteHelper writeHelper = context.getOfflineWriteHelper();
        if (writeHelper != null) {
            writeHelper.setPartitionKeys(this, partitionKeys);
        }
        return partitionKeys;
    }

    protected List<IOlapBuilderTablePartitionKey> doGetPartitionKeys(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_PARTITION_NOT_SUPPORTED, new Serializable[]{this.getName()});
    }

    protected IOlapBuilderTableRowReader<CONNECTION> doCreatePartitionTableRowReaders(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderTablePartitionKey partitionKey) {
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_PARTITION_NOT_SUPPORTED, new Serializable[]{this.getName()});
    }

    protected IOlapBuilderTableRowReader decorateRowReaderForTableCache(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        return this.doDecorateRowReaderForTableCache(context, reader);
    }

    protected final IOlapBuilderTableRowReader doDecorateRowReaderForTableCache(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        if (context == null) {
            return reader;
        }
        OlapBuilderCacheTableHelper helper = context.getCacheTableHelper();
        IOlapBuilderTableRowReader reader_ = helper.createWritingRowReader(reader);
        return reader_;
    }

    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForTableCacheRead(OlapBuilderContext context) {
        return this.doCreateRowReaderForTableCacheRead(context);
    }

    @Nullable
    protected final IOlapBuilderTableRowReader doCreateRowReaderForTableCacheRead(OlapBuilderContext context) {
        if (context == null) {
            return null;
        }
        OlapBuilderCacheTableHelper helper = context.getCacheTableHelper();
        IOlapBuilderTableRowReader reader_ = helper.createReadingRowReader(this);
        return reader_;
    }

    protected IOlapBuilderTableRowReader decorateRowReaderForBackup(OlapBuilderContext context, IOlapBuilderTableRowReader reader, boolean tablePartition) {
        if (context == null) {
            return reader;
        }
        reader = context.decorateRowReaderForBackup(reader, tablePartition);
        return reader;
    }

    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForRestore(OlapBuilderContext context, boolean tablePartition) {
        if (context == null) {
            return null;
        }
        IOlapBuilderTableRowReader reader = context.createRowReaderForRestore(this, tablePartition);
        return reader;
    }

    protected IOlapBuilderTableRowReader decorateRowReaderForOfflineWrite(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        if (context == null) {
            return reader;
        }
        OlapBuilderOfflineWriteHelper writeHelper = context.getOfflineWriteHelper();
        if (writeHelper == null) {
            return reader;
        }
        reader = writeHelper.decorateRowReader(reader);
        return reader;
    }

    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForOfflineRead(OlapBuilderContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey) {
        if (context == null) {
            return null;
        }
        OlapBuilderOfflineReadHelper helper = context.getOfflineReadHelper();
        if (helper == null) {
            return null;
        }
        IOlapBuilderTableRowReader reader = helper.createRowReader(this, partitionKey);
        return reader;
    }

    @Override
    public String getContextVisualId() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getFileName() {
        return this.getName();
    }

    @Override
    public boolean isDiscoveredInDataSource() {
        return true;
    }

    public OlapBuilderValidator<IOlapBuilderDataSource<CONNECTION>, IOlapBuilderDataTableDef<CONNECTION>> getValidator() {
        return new OlapBuilderNonEmptyDataTableValidator();
    }

    @Override
    @Nullable
    public String getIncrementalLoadColumnName() {
        return this.incrementalLoadColumnName;
    }

    public void setIncrementalLoadColumnName(@Nullable String incrementalLoadColumnName) {
        this.incrementalLoadColumnName = incrementalLoadColumnName;
    }

    @Override
    @Nullable
    public OlapIncrementalLoadStrategy getIncrementalLoadStrategy() {
        return this.incrementalLoadStrategy;
    }

    public void setIncrementalLoadStrategy(@Nullable OlapIncrementalLoadStrategy incrementalLoadStrategy) {
        this.incrementalLoadStrategy = incrementalLoadStrategy;
    }

    public boolean notCacheInIncrementalLoad() {
        return false;
    }

    @Override
    public boolean hasTablePartitioning() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.partitioningColumnName);
    }

    @Override
    @Nullable
    public String getPartitioningColumnName() {
        return this.partitioningColumnName;
    }

    public void setPartitioningColumnName(@Nullable String partitioningColumnName) {
        this.partitioningColumnName = partitioningColumnName;
    }

    @Override
    @Nullable
    public String getPartitioningColumnNameX() {
        if (this.partitioningColumnName == null) {
            return null;
        }
        int sep = this.partitioningColumnName.indexOf(PARTITIONING_COLUMN_NAME_SEP);
        if (sep == -1) {
            return this.partitioningColumnName;
        }
        String name = this.partitioningColumnName.substring(sep + 3);
        return name;
    }

    @Override
    @Nullable
    public String getPartitioningColumnNameTableX() {
        if (this.partitioningColumnName == null) {
            return null;
        }
        int sep = this.partitioningColumnName.indexOf(PARTITIONING_COLUMN_NAME_SEP);
        if (sep == -1) {
            return null;
        }
        String name = this.partitioningColumnName.substring(0, sep);
        return name;
    }

    @Override
    public void onReferenceStarted() {
        this.depth = null;
    }

    @Override
    @Nullable
    public Integer getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    @Override
    public IncrLoadMarker createIncrLoadMarker(IncrLoadTableSavePoint savePoint) {
        return new IncrLoadDefaultMarker(savePoint);
    }

    @Nullable
    public static List<IOlapBuilderDataColumnDef> fixColumns(IOlapBuilderDataTableDef table, @Nullable List<IOlapBuilderDataColumnDef> uiSortedColumns) {
        if (uiSortedColumns == null) {
            return new ArrayList<IOlapBuilderDataColumnDef>();
        }
        Map<String, Integer> columnPositions = table.createAllColumnsPositions();
        IOlapBuilderDataColumnDef[] uiFixedColumns = new IOlapBuilderDataColumnDef[uiSortedColumns.size()];
        for (IOlapBuilderDataColumnDef uiSortedColumn : uiSortedColumns) {
            Integer pos = columnPositions.get(uiSortedColumn.getName());
            if (pos == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_COLUMNS_MISMATCH, new Serializable[0]);
            }
            uiFixedColumns[pos.intValue()] = uiSortedColumn;
        }
        return new ArrayList<IOlapBuilderDataColumnDef>(Arrays.asList(uiFixedColumns));
    }
}

