/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.hierarchy;

import crazydev.common.collection.CdCollections;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderParentChildHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapParentChildHierarchyDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.OlapBuilderNamedDefinitionHelper;
import crazydev.iccube.builder.model.impl.OlapBuilderProperty;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderCommonExHierarchy;
import crazydev.iccube.builder.model.validation.OlapBuilderParentChildHierarchyValidator;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XmlRootElement(name="parentChildHierarchy")
public class OlapBuilderParentChildHierarchy
extends OlapBuilderCommonExHierarchy
implements IOlapParentChildHierarchyDef {
    public static final CdProperty ADD_ALL_MEMBER = new CdReadWriteProperty(OlapBuilderParentChildHierarchy.class, "addAllMemberName");
    public static final CdProperty FIRST_LEVEL_ALL = new CdReadWriteProperty(OlapBuilderParentChildHierarchy.class, "firstLevelAll", false);
    public static final CdProperty MEMBER_KEY = new CdReadWriteProperty(OlapBuilderParentChildHierarchy.class, "cmemberKeyRef");
    public static final CdProperty MEMBER_NAME = new CdReadWriteProperty(OlapBuilderParentChildHierarchy.class, "cmemberNameRef");
    public static final CdProperty NODE_ID = new CdReadWriteProperty(OlapBuilderParentChildHierarchy.class, "nodeIdRef");
    public static final CdProperty PARENT_NODE_ID = new CdReadWriteProperty(OlapBuilderParentChildHierarchy.class, "parentNodeIdRef");
    public static final CdProperty MEMBER_PROPS = new CdReadWriteProperty(OlapBuilderParentChildHierarchy.class, "properties");
    @XmlElement(required=true)
    private OlapBuilderDataColumnRef cmemberNameRef;
    @XmlElement(required=true)
    private OlapBuilderDataColumnRef cmemberKeyRef;
    @XmlElement(required=true)
    private OlapBuilderDataColumnRef nodeIdRef;
    @XmlElement(required=true)
    private OlapBuilderDataColumnRef parentNodeIdRef;
    @XmlElement
    private Boolean firstLevelAll;
    @XmlElement
    private String addAllMemberName;
    @XmlElementRefs(value={@XmlElementRef(type=OlapBuilderProperty.class)})
    private List<IOlapBuilderPropertyDef> properties;
    @XmlTransient
    private IOlapBuilderDataColumnDef cmemberName;
    @XmlTransient
    private IOlapBuilderDataColumnDef cmemberKey;
    @XmlTransient
    private IOlapBuilderDataColumnDef nodeId;
    @XmlTransient
    private IOlapBuilderDataColumnDef parentNodeId;

    public OlapBuilderParentChildHierarchy() {
    }

    public OlapBuilderParentChildHierarchy(String name, boolean isDefault, IOlapBuilderDataColumnDef cId, IOlapBuilderDataColumnDef cParentId, IOlapBuilderDataColumnDef cmemberKey, IOlapBuilderDataColumnDef cmemberName, IOlapBuilderHierarchyLevelDef ... levels) {
        super(name, isDefault, levels);
        this.nodeId = cId;
        this.parentNodeId = cParentId;
        this.cmemberKey = cmemberKey;
        this.cmemberName = cmemberName;
        this.nodeIdRef = OlapBuilderDataColumnRef.asRef(cId);
        this.parentNodeIdRef = OlapBuilderDataColumnRef.asRef(cParentId);
        this.cmemberKeyRef = OlapBuilderDataColumnRef.asRef(cmemberKey);
        this.cmemberNameRef = OlapBuilderDataColumnRef.asRef(cmemberName);
    }

    public void setMemberNameColumn(OlapBuilderDataColumnRef col) {
        this.cmemberNameRef = col;
    }

    public void setNodeIdColumn(OlapBuilderDataColumnRef col) {
        this.nodeIdRef = col;
    }

    public void setParentNodeIdColumn(OlapBuilderDataColumnRef col) {
        this.parentNodeIdRef = col;
    }

    @Override
    public boolean isParentChild() {
        return true;
    }

    @Override
    public IOlapBuilderDataColumnDef getId() {
        return this.nodeId;
    }

    @Override
    public IOlapBuilderDataColumnDef getParentId() {
        return this.parentNodeId;
    }

    @Override
    public IOlapBuilderDataColumnDef getMemberName() {
        return this.cmemberName;
    }

    @Override
    public OlapBuilderDataColumnRef getMemberKeyColumnRef() {
        return this.cmemberKeyRef == null ? this.nodeIdRef : this.cmemberKeyRef;
    }

    @Override
    public IOlapBuilderDataColumnDef getMemberKey() {
        return this.cmemberKey == null ? this.getId() : this.cmemberKey;
    }

    @Override
    public boolean hasAll() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.addAllMemberName) || this.isFirstLevelAll();
    }

    @Override
    public boolean isFirstLevelAll() {
        return this.firstLevelAll == null ? false : this.firstLevelAll;
    }

    public void setFirstLevelIsAll() {
        this.firstLevelAll = true;
    }

    @Override
    public String addAllMemberName() {
        return this.addAllMemberName;
    }

    public void setAddAllMemberName(String addAllMemberName) {
        this.addAllMemberName = addAllMemberName;
    }

    @Override
    public void setAllMemberNameForDynHier(String allMemberName) {
        super.setAllMemberNameForDynHier(allMemberName);
        if (!this.isFirstLevelAll()) {
            this.addAllMemberName = allMemberName;
        }
    }

    @Override
    public OlapBuilderParentChildHierarchyValidator getValidator() {
        return new OlapBuilderParentChildHierarchyValidator();
    }

    @Override
    public IOlapBuilderDimensionListener createBuilder(OlapBuilderContext context, OlapDimension dimension) {
        return new OlapBuilderParentChildHierarchyBuilder(context, dimension, this);
    }

    @Override
    public List<OlapBuilderDataColumnRef> getAllFactIndexingColumns() {
        ArrayList<OlapBuilderDataColumnRef> columns = new ArrayList<OlapBuilderDataColumnRef>();
        CdCollections.addIfNotNull(columns, (Object)this.cmemberKeyRef);
        return columns;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef dataView) {
        super.solveReference(referenceSolver, dataView);
        this.nodeId = referenceSolver.getColumn(dataView, this.nodeIdRef);
        this.parentNodeId = referenceSolver.getColumn(dataView, this.parentNodeIdRef);
        this.cmemberKey = referenceSolver.getColumn(dataView, this.cmemberKeyRef);
        this.cmemberName = referenceSolver.getColumn(dataView, this.cmemberNameRef);
        if (this.properties != null) {
            for (IOlapBuilderPropertyDef property : this.properties) {
                referenceSolver.solveReference(property, dataView);
            }
        }
    }

    @Override
    public boolean orderLevels(List<String> orderedNames) {
        return false;
    }

    @Override
    public List<IOlapBuilderPropertyDef> getProperties() {
        return this.properties == null ? Collections.emptyList() : this.properties;
    }

    @Override
    public boolean orderProperties(List<String> orderedNames) {
        return OlapBuilderNamedDefinitionHelper.order(this.properties, orderedNames);
    }

    public void addProperty(IOlapBuilderPropertyDef prop) {
        if (this.properties == null) {
            this.properties = new ArrayList<IOlapBuilderPropertyDef>();
        }
        this.properties.add(prop);
    }

    public boolean removeProperty(IOlapBuilderPropertyDef property) {
        return this.properties != null && this.properties.remove(property);
    }

    @Override
    public final List<IOlapBuilderPropertyDef> getPropertiesForBuilder(String levelName) {
        List<IOlapBuilderPropertyDef> properties = this.getProperties();
        properties = properties == null ? Collections.emptyList() : properties;
        IOlapBuilderDataColumnDef orderMembersColumn = this.getOrderMembersColumn();
        if (orderMembersColumn != null) {
            properties = new ArrayList<IOlapBuilderPropertyDef>(properties);
            properties.add(new OlapBuilderProperty("IcMemberRanking", orderMembersColumn));
        }
        return Collections.unmodifiableList(properties);
    }
}

