/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.hierarchy;

import crazydev.common.collection.CdSingleItemList;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAttribute;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.OlapBuilderNamedDefinitionHelper;
import crazydev.iccube.builder.model.impl.OlapBuilderProperty;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchyLevel;
import crazydev.iccube.builder.model.validation.OlapBuilderHierarchyLevelValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.enums.OlapMemberNotKeyOrder;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.enums.OlapMemberOrderKind;
import crazydev.iccube.olap.entity.level.OlapLevel;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="level")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OlapBuilderHierarchyLevel
implements IOlapBuilderHierarchyLevelDef,
IOlapBuilderJaxbListener {
    public static final CdProperty UUID = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "uuid");
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "description");
    public static final CdProperty KEY_COLS = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "keyColsRef");
    public static final CdProperty NAME_COL = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "nameColRef");
    public static final CdProperty ORDER_MEMBERS_COLUMN = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "orderMembersColumnRef");
    public static final CdProperty ORDER_MEMBERSBY_TYPE = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "orderMembersByType");
    public static final CdProperty ORDER_KIND = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "orderKind");
    public static final CdProperty ORDER_NOKEY = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "orderNoKey");
    public static final CdProperty LEVEL_TYPE = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "levelType");
    public static final CdProperty NAME_UNIQUE_IN_LEVEL = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "nameUniqueInLevel");
    public static final CdProperty NAME_UNIQUE_IN_PARENT = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "nameUniqueInParent");
    public static final CdProperty KEY_UNIQUE_IN_LEVEL = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "keyUniqueInLevel");
    public static final CdProperty IGNORE_NAME_COLLISION = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "ignoreNameCollision");
    public static final CdProperty MEMBER_PROPS = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "properties");
    public static final CdProperty MEMBER_ATTRIBUTES = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "attributes");
    public static final CdProperty ATTRIBUTE_NAME_IF_NULL = new CdReadWriteProperty(OlapBuilderHierarchyLevel.class, "attributeNameIfNull");
    @XmlAttribute(name="uuid", required=true)
    private String uuid = java.util.UUID.randomUUID().toString();
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=false)
    @Nullable
    private String description;
    @XmlElementRefs(value={@XmlElementRef(type=OlapBuilderProperty.class)})
    private List<IOlapBuilderPropertyDef> properties;
    @XmlAttribute(name="ignoreNameCollision", required=true)
    private boolean ignoreNameCollision = false;
    @XmlElementRefs(value={@XmlElementRef})
    private List<OlapBuilderDataColumnRef> keyColsRef;
    @XmlElement(name="nameCol")
    private OlapBuilderDataColumnRef nameColRef;
    @XmlElement(name="orderType", required=true)
    private OlapMemberOrderByType orderMembersByType = OlapMemberOrderByType.NONE;
    @XmlElement(name="orderKind")
    private OlapMemberOrderKind orderKind;
    @XmlElement(name="orderNoKey")
    private OlapMemberNotKeyOrder orderNoKey;
    @XmlElement(name="orderColumn")
    @Nullable
    private OlapBuilderDataColumnRef orderMembersColumnRef;
    @XmlAttribute
    @Nullable
    private OlapLevelType levelType;
    @XmlAttribute(name="nameUnique", required=true)
    private boolean nameUniqueInLevel = true;
    @XmlAttribute(name="nameUniqueInParent", required=true)
    private boolean nameUniqueInParent = false;
    @XmlAttribute(name="keyUnique", required=true)
    private boolean keyUniqueInLevel = true;
    @XmlAttribute(name="attributeNameIfNull")
    private String attributeNameIfNull;
    @XmlElementRefs(value={@XmlElementRef(type=OlapBuilderAttribute.class)})
    private List<IOlapBuilderAttributeDef> attributes;
    @XmlTransient
    private IOlapBuilderDataColumnDef nameCol;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> keyCols;
    @XmlTransient
    @Nullable
    private IOlapBuilderDataColumnDef orderMembersColumn;
    @XmlTransient
    @Nullable
    private OlapBuilderProperty orderByProperty;
    @XmlTransient
    private boolean factIndexing;
    @XmlTransient
    private boolean doNotValidateEmptyLevel;

    public OlapBuilderHierarchyLevel() {
        this.properties = new ArrayList<IOlapBuilderPropertyDef>();
        this.attributes = new ArrayList<IOlapBuilderAttributeDef>();
        this.keyColsRef = new ArrayList<OlapBuilderDataColumnRef>();
    }

    private OlapBuilderHierarchyLevel(String name, @Nullable String description, @Nullable OlapLevelType levelType, boolean keyUnique, boolean nameUnique, List<IOlapBuilderDataColumnDef> keyCols, IOlapBuilderDataColumnDef nameCol, List<IOlapBuilderPropertyDef> properties, List<IOlapBuilderAttributeDef> attributes) {
        this.name = name;
        this.description = description;
        this.levelType = levelType;
        this.keyUniqueInLevel = keyUnique;
        this.nameUniqueInLevel = nameUnique;
        this.properties = properties;
        this.attributes = attributes;
        this.keyCols = keyCols;
        this.nameCol = nameCol;
        this.keyColsRef = OlapBuilderDataColumnRef.asRef(keyCols);
        this.nameColRef = OlapBuilderDataColumnRef.asRef(nameCol);
    }

    public OlapBuilderHierarchyLevel(String name, @Nullable String description, IOlapBuilderDataColumnDef nameCol, @Nullable IOlapBuilderDataColumnDef keyCol, IOlapBuilderPropertyDef ... properties) {
        this(name, description, null, false, false, keyCol == null ? Collections.emptyList() : CdSingleItemList.asList((Object)keyCol), nameCol, new ArrayList<IOlapBuilderPropertyDef>(Arrays.asList(properties)), new ArrayList<IOlapBuilderAttributeDef>());
    }

    public OlapBuilderHierarchyLevel(String name, @Nullable String description, IOlapBuilderDataColumnDef nameCol) {
        this(name, description, null, false, false, Collections.emptyList(), nameCol, new ArrayList<IOlapBuilderPropertyDef>(), new ArrayList<IOlapBuilderAttributeDef>());
    }

    public OlapBuilderHierarchyLevel(String name, @Nullable String description, OlapLevelType levelType, IOlapBuilderDataColumnDef nameCol) {
        this(name, description, levelType, false, false, Collections.emptyList(), nameCol, new ArrayList<IOlapBuilderPropertyDef>(), new ArrayList<IOlapBuilderAttributeDef>());
    }

    public OlapBuilderHierarchyLevel(String name, @Nullable String description, OlapLevelType levelType, boolean keyUnique, boolean nameUnique, List<IOlapBuilderDataColumnDef> keyCols, IOlapBuilderDataColumnDef nameCol, List<IOlapBuilderPropertyDef> properties) {
        this(name, description, levelType, keyUnique, nameUnique, keyCols, nameCol, properties, new ArrayList<IOlapBuilderAttributeDef>());
    }

    public OlapBuilderHierarchyLevel(OlapBuilderTimeWizardHierarchyLevel levelDef, IOlapBuilderDataColumnDef keyColumn, IOlapBuilderDataColumnDef nameColumn, OlapMemberOrderKind orderKind, boolean isFactIndexing, boolean keyUniqueInLevel1) {
        this.name = levelDef.getName();
        this.description = levelDef.getDescription();
        this.levelType = levelDef.getType();
        this.keyUniqueInLevel = keyUniqueInLevel1;
        this.nameUniqueInParent = false;
        this.nameUniqueInLevel = false;
        this.factIndexing = isFactIndexing;
        this.keyCols = CdSingleItemList.asList((Object)keyColumn);
        this.nameCol = nameColumn;
        this.orderMembersByType = OlapMemberOrderByType.BY_KEY;
        this.orderKind = orderKind;
    }

    public static OlapBuilderHierarchyLevel createWithAttributes(String name, IOlapBuilderDataColumnDef nameCol, IOlapBuilderAttributeDef ... attributes) {
        return new OlapBuilderHierarchyLevel(name, null, null, false, false, Collections.emptyList(), nameCol, new ArrayList<IOlapBuilderPropertyDef>(), new ArrayList<IOlapBuilderAttributeDef>(Arrays.asList(attributes)));
    }

    @Override
    public List<IOlapBuilderAttributeDef> getAttributes() {
        return this.attributes != null ? this.attributes : Collections.emptyList();
    }

    @Override
    public String getMissingAttributeMemberName() {
        return this.attributeNameIfNull;
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
        if (this.uuid == null) {
            this.uuid = java.util.UUID.randomUUID().toString();
        }
    }

    @Override
    public void resetUUID() {
        this.uuid = java.util.UUID.randomUUID().toString();
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<OlapBuilderDataColumnRef> getKeyColumnsRef() {
        return this.keyColsRef;
    }

    @Override
    public OlapBuilderDataColumnRef getNameColumnRef() {
        return this.nameColRef;
    }

    public void setKeyColsRef(List<OlapBuilderDataColumnRef> keyColsRef) {
        this.keyColsRef = keyColsRef;
    }

    public void setNameColRef(OlapBuilderDataColumnRef nameColRef) {
        this.nameColRef = nameColRef;
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getKeyColumns() {
        if (this.keyCols == null || this.keyCols.isEmpty()) {
            this.setupKeysFromNameColumn();
        }
        return this.keyCols;
    }

    private synchronized void setupKeysFromNameColumn() {
        if ((this.keyCols == null || this.keyCols.isEmpty()) && this.nameCol != null) {
            this.keyCols = new CdSingleItemList((Object)this.nameCol);
        }
    }

    @Override
    public IOlapBuilderDataColumnDef getNameColumn() {
        return this.nameCol;
    }

    public void setNameCol(IOlapBuilderDataColumnDef nameCol) {
        this.nameCol = nameCol;
    }

    @Override
    public boolean isKeyUniqueInLevel() {
        return this.keyUniqueInLevel;
    }

    public void setKeyUniqueInLevel(boolean keyUniqueInLevel) {
        this.keyUniqueInLevel = keyUniqueInLevel;
    }

    @Override
    public boolean isNameUniqueInLevel() {
        return this.nameUniqueInLevel;
    }

    @Override
    public boolean isNameUniqueInParent() {
        return this.nameUniqueInParent;
    }

    public void setNameUniqueInParent(boolean nameUniqueInParent) {
        this.nameUniqueInParent = nameUniqueInParent;
    }

    @Override
    public boolean ignoreNameCollision() {
        return this.ignoreNameCollision;
    }

    @Override
    @Nullable
    public OlapLevelType getLevelType() {
        return this.levelType;
    }

    public void setLevelType(@Nullable OlapLevelType levelType) {
        this.levelType = levelType;
    }

    @Override
    public List<IOlapBuilderPropertyDef> getProperties() {
        return this.properties == null ? Collections.emptyList() : this.properties;
    }

    @Override
    public List<IOlapBuilderPropertyDef> getPropertiesAndAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return this.getProperties();
        }
        ArrayList<IOlapBuilderPropertyDef> newProps = new ArrayList<IOlapBuilderPropertyDef>(this.properties);
        this.attributes.forEach(attr -> newProps.add(new OlapBuilderProperty((IOlapBuilderAttributeDef)attr)));
        return newProps;
    }

    @Override
    public OlapMemberOrderByType getOrderMembersByType() {
        return this.orderMembersByType;
    }

    public void setOrderMembersByType(OlapMemberOrderByType orderMembersByType) {
        this.orderMembersByType = orderMembersByType;
    }

    @Override
    public OlapMemberOrderKind getOrderKind() {
        return this.orderKind;
    }

    @Override
    public OlapMemberNotKeyOrder getOrderNoKey() {
        return this.orderNoKey;
    }

    public void setOrderKind(OlapMemberOrderKind orderKind) {
        this.orderKind = orderKind;
    }

    @Override
    @Nullable
    public IOlapBuilderDataColumnDef getOrderMembersColumn() {
        return this.orderMembersColumn;
    }

    public void setOrderMembersColumn(@Nullable IOlapBuilderDataColumnDef orderMembersColumn) {
        this.orderMembersColumn = orderMembersColumn;
        this.orderMembersColumnRef = OlapBuilderDataColumnRef.asRef(orderMembersColumn);
        this.orderByProperty = orderMembersColumn == null ? null : new OlapBuilderProperty("IcMemberRanking", orderMembersColumn);
    }

    public void setOrderMembersColumnRef(OlapBuilderDataColumnRef orderMembersColumnRef) {
        this.orderMembersColumnRef = orderMembersColumnRef;
    }

    public void addProperty(IOlapBuilderPropertyDef property) {
        this.properties.add(property);
    }

    public OlapBuilderValidator<IOlapBuilderHierarchyDef, IOlapBuilderHierarchyLevelDef> getValidator() {
        return new OlapBuilderHierarchyLevelValidator();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    @Override
    @Nullable
    public OlapBuilderProperty getOrderByProperty() {
        return this.orderByProperty;
    }

    public void clearUniques() {
        this.keyUniqueInLevel = false;
        this.nameUniqueInLevel = false;
    }

    @Override
    public void setKeyUniqueInLevel() {
        this.keyUniqueInLevel = true;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef dataView) {
        this.keyCols = referenceSolver.getColumns(dataView, this.keyColsRef);
        this.nameCol = referenceSolver.getColumn(dataView, this.nameColRef);
        this.orderMembersColumn = referenceSolver.getColumn(dataView, this.orderMembersColumnRef);
        if (this.properties != null) {
            for (IOlapBuilderPropertyDef property : this.properties) {
                referenceSolver.solveReference(property, dataView);
            }
        }
        if (this.attributes != null) {
            for (IOlapBuilderAttributeDef attribute : this.attributes) {
                referenceSolver.solveReference(attribute, dataView);
            }
        }
        if (this.orderMembersByType == OlapMemberOrderByType.BY_COLUMN && this.orderMembersColumn != null) {
            this.orderByProperty = new OlapBuilderProperty("IcMemberRanking", this.orderMembersColumn);
        }
    }

    @Override
    public boolean orderProperties(List<String> orderedNames) {
        return OlapBuilderNamedDefinitionHelper.order(this.properties, orderedNames);
    }

    @Override
    public boolean checkKeyUnique() {
        return this.isKeyUniqueInLevel();
    }

    @Override
    public void setIsFactIndexing(boolean isFactIndexing) {
        this.factIndexing = isFactIndexing;
    }

    @Override
    public boolean isFactIndexing() {
        return this.factIndexing;
    }

    @Override
    public void setNameUniqueInParent() {
        this.nameUniqueInParent = true;
    }

    @Override
    public void setNameUniqueInLevel() {
        this.nameUniqueInLevel = true;
    }

    @Override
    public boolean isDoNotValidateEmptyLevel() {
        return this.doNotValidateEmptyLevel;
    }

    public void setDoNotValidateEmptyLevel(boolean doNotValidateEmptyLevel) {
        this.doNotValidateEmptyLevel = doNotValidateEmptyLevel;
    }

    @Override
    public boolean isNameSameAsKey() {
        return this.keyCols.size() == 1 && this.nameCol == this.keyCols.get(0) || this.keyCols.isEmpty();
    }

    @Override
    public List<OlapBuilderInputType> getKeyTypes() {
        if (this.keyCols.isEmpty()) {
            return this.nameCol == null ? Collections.emptyList() : new CdSingleItemList((Object)this.nameCol.getType());
        }
        return this.keyCols.stream().map(IOlapBuilderDataColumnDef::getType).collect(Collectors.toList());
    }

    @Override
    public String getTooltipForLevel() {
        String tooltip = this.name;
        Object extra = "";
        if (this.nameColRef != null) {
            extra = (String)extra + "name: '" + this.nameColRef.getName() + "'";
            if (this.orderMembersByType == OlapMemberOrderByType.BY_NAME) {
                extra = (String)extra + " " + this.getExistingOrderKind().name();
            }
        }
        if (this.keyColsRef != null && !this.keyColsRef.isEmpty()) {
            extra = (String)extra + this.keyColsRef.stream().map(OlapBuilderDataColumnRef::getName).collect(Collectors.joining(", ", " - key: '", "'"));
            if (this.orderMembersByType == OlapMemberOrderByType.BY_KEY) {
                extra = (String)extra + " " + this.getExistingOrderKind().name();
            }
        }
        return tooltip + (String)(((String)extra).isEmpty() ? "" : " (" + (String)extra + ")");
    }

    private OlapMemberOrderKind getExistingOrderKind() {
        return this.orderKind == null ? OlapLevel.getDefaultOrderKind() : this.orderKind;
    }

    public void setAttributeNameIfNull(String nameIfNull) {
        this.attributeNameIfNull = nameIfNull;
    }

    public void setOrderNoKey(OlapMemberNotKeyOrder orderNoKey) {
        this.orderNoKey = orderNoKey;
    }
}

