/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.hierarchy;

import crazydev.common.collection.CdSingleItemList;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderFlatHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.validation.OlapBuilderHierarchyValidator;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.enums.OlapMemberOrderKind;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="flatHierarchy")
public class OlapBuilderFlatHierarchy
extends OlapBuilderBaseHierarchy {
    @XmlAttribute(name="levelName")
    private String levelName;
    @XmlElement(name="column")
    private OlapBuilderDataColumnRef nameColumn;
    @XmlTransient
    private IOlapBuilderDataColumnDef nameColumnDef;
    private OlapMemberOrderByType orderType;
    @XmlAttribute(required=false)
    private OlapMemberOrderKind kind;

    private OlapBuilderFlatHierarchy() {
        this(null, null, null, false);
    }

    public OlapBuilderFlatHierarchy(String folderName, String hierarchyName, String defaultMemberName, boolean isDefault) {
        super(folderName, hierarchyName, isDefault, defaultMemberName);
    }

    @Override
    public List<IOlapBuilderHierarchyLevelDef> getLevels() {
        OlapBuilderHierarchyLevel level = new OlapBuilderHierarchyLevel(this.levelName, null, (IOlapBuilderDataColumnDef)null, this.nameColumnDef, new IOlapBuilderPropertyDef[0]);
        level.setKeyUniqueInLevel(true);
        level.setIsFactIndexing(true);
        if (this.kind != null) {
            level.setOrderKind(this.kind);
            level.setOrderMembersByType(OlapMemberOrderByType.BY_NAME);
        }
        return new CdSingleItemList((Object)level);
    }

    @Override
    public IOlapBuilderDimensionListener createBuilder(OlapBuilderContext context, OlapDimension dimension) {
        return new OlapBuilderFlatHierarchyBuilder(context, dimension, this.getDefaultMemberName(), this);
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef dataView) {
        super.solveReference(referenceSolver, dataView);
        this.nameColumnDef = referenceSolver.getColumn(dataView, this.nameColumn);
    }

    public IOlapBuilderDataColumnDef getNameColumnDef() {
        return this.nameColumnDef;
    }

    @Override
    public OlapBuilderHierarchyValidator getValidator() {
        return OlapBuilderHierarchyValidator.NOP2;
    }

    @Override
    public boolean hasAll() {
        return false;
    }

    @Override
    @Nullable
    public String getAllLevelName() {
        return null;
    }

    @Override
    @Nullable
    public String getAllMemberName() {
        return null;
    }

    @Override
    public List<OlapBuilderDataColumnRef> getAllFactIndexingColumns() {
        return Collections.emptyList();
    }

    @Override
    public boolean mightBeIndexingByOneLevel() {
        return true;
    }

    @Override
    public boolean orderLevels(List<String> orderedNames) {
        return false;
    }

    @Override
    public boolean aggrFactOnAncestor() {
        return true;
    }

    @Override
    public void moveLevelUp(IOlapBuilderBaseHierarchyLevelDef level) {
    }

    @Override
    public void moveLevelDown(IOlapBuilderBaseHierarchyLevelDef level) {
    }
}

