/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.hierarchy;

import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAllLevelParsedDefinition;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseWithAllHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderCommonHierarchy
extends OlapBuilderBaseWithAllHierarchy {
    @XmlElementRefs(value={@XmlElementRef(name="level", type=OlapBuilderHierarchyLevel.class)})
    protected List<IOlapBuilderHierarchyLevelDef> levels = new ArrayList<IOlapBuilderHierarchyLevelDef>();

    protected OlapBuilderCommonHierarchy() {
    }

    protected OlapBuilderCommonHierarchy(String name, boolean isDefault, OlapBuilderAllLevelParsedDefinition allLevelDef) {
        super(name, isDefault, allLevelDef);
    }

    protected OlapBuilderCommonHierarchy(String name, boolean isDefault, IOlapBuilderHierarchyLevelDef ... levels) {
        this(name, isDefault, OlapBuilderAllLevelParsedDefinition.UNDEFINED, levels);
    }

    protected OlapBuilderCommonHierarchy(String name, boolean isDefault, OlapBuilderAllLevelParsedDefinition allLevelDef, List<IOlapBuilderHierarchyLevelDef> levels) {
        this(name, isDefault, allLevelDef);
        this.levels.addAll(levels);
    }

    protected OlapBuilderCommonHierarchy(String name, boolean isDefault, OlapBuilderAllLevelParsedDefinition allLevelDef, IOlapBuilderHierarchyLevelDef ... levels) {
        this(name, isDefault, allLevelDef, Arrays.asList(levels));
    }

    @Override
    protected void resetLevelUUIDs() {
        if (this.levels != null) {
            for (IOlapBuilderHierarchyLevelDef level : this.levels) {
                level.resetUUID();
            }
        }
    }

    public void addLevel(IOlapBuilderHierarchyLevelDef level) {
        this.levels.add(level);
    }

    @Override
    public boolean removeLevel(IOlapBuilderHierarchyLevelDef level) {
        return this.levels.remove(level);
    }

    @Override
    public List<IOlapBuilderHierarchyLevelDef> getLevels() {
        return this.levels;
    }

    @Override
    public List<? extends IOlapBuilderBaseHierarchyLevelDef> getLevelsForUX() {
        return this.levels;
    }

    @Override
    @Nullable
    public IOlapBuilderBaseHierarchyLevelDef getLevelByUUIDForUX(String uuid) {
        for (IOlapBuilderHierarchyLevelDef level : this.levels) {
            if (!level.getUUID().equals(uuid)) continue;
            return level;
        }
        return null;
    }

    @Override
    @Nullable
    public IOlapBuilderBaseHierarchyLevelDef getLevelForUX(String name) {
        for (IOlapBuilderHierarchyLevelDef level : this.levels) {
            if (!level.getName().equals(name)) continue;
            return level;
        }
        return null;
    }

    @Override
    public void addLevelForUX(IOlapBuilderBaseHierarchyLevelDef level) {
        this.levels.add((IOlapBuilderHierarchyLevelDef)level);
    }

    @Override
    public void removeLevelForUX(IOlapBuilderBaseHierarchyLevelDef level) {
        this.levels.remove((IOlapBuilderHierarchyLevelDef)level);
    }

    @Override
    public void moveLevelUp(IOlapBuilderBaseHierarchyLevelDef level) {
        int pos = this.getLevelPos(level);
        if (pos > 0) {
            this.levels.remove(pos);
            this.levels.add(pos - 1, (IOlapBuilderHierarchyLevelDef)level);
        }
    }

    @Override
    public void moveLevelDown(IOlapBuilderBaseHierarchyLevelDef level) {
        int pos = this.getLevelPos(level);
        if (pos < this.levels.size() - 1) {
            this.levels.remove(pos);
            this.levels.add(pos + 1, (IOlapBuilderHierarchyLevelDef)level);
        }
    }

    private int getLevelPos(IOlapBuilderBaseHierarchyLevelDef level) {
        int pos = -1;
        for (int ii = 0; ii < this.levels.size(); ++ii) {
            IOlapBuilderHierarchyLevelDef tLevel = this.levels.get(ii);
            if (!tLevel.getName().equals(level.getName())) continue;
            pos = ii;
            break;
        }
        return pos;
    }
}

