/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.dimension;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifier;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseExDimension;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderTabularDataBasedDimension<T extends IOlapBuilderHierarchyDef>
extends OlapBuilderBaseExDimension<T> {
    public static final CdProperty DATA_VIEW = new CdReadWriteProperty(OlapBuilderTabularDataBasedDimension.class, "dataTableId"){

        public Class<?> getType() {
            return OlapBuilderTabularDataXmlIdentifier.class;
        }
    };
    public static final CdProperty TIME_DIMENSION = new CdReadWriteProperty(OlapBuilderTabularDataBasedDimension.class, "timeDimension");
    public static final CdProperty DEFAULT_TIME_DIMENSION = new CdReadWriteProperty(OlapBuilderTabularDataBasedDimension.class, "defaultTimeDimension");
    public static final CdProperty IS_INDEXING_BY_RANGE = new CdReadWriteProperty(OlapBuilderTabularDataBasedDimension.class, "isIndexingByRange");
    @XmlAttribute(name="dataTableId")
    private String dataTableId;
    @XmlAttribute(name="isTimeDimension")
    private boolean timeDimension;
    @XmlAttribute(name="isDefaultTimeDimension")
    private boolean defaultTimeDimension;
    @XmlAttribute(name="isIndexingByRange")
    private boolean isIndexingByRange;
    @XmlTransient
    private IOlapBuilderTabularDataDef dataTable;

    protected OlapBuilderTabularDataBasedDimension() {
    }

    protected OlapBuilderTabularDataBasedDimension(IOlapBuilderTabularDataDef dataTable, String name, String id, List<T> hierarchies, boolean timeDimension, boolean defaultTimeDimension) {
        super(name, id, hierarchies);
        this.timeDimension = timeDimension;
        this.defaultTimeDimension = defaultTimeDimension;
        this.setDataView(dataTable);
    }

    @Override
    public boolean isTimeDimension() {
        return this.timeDimension || this.isDefaultTimeDimension();
    }

    @Override
    public boolean isDefaultTimeDimension() {
        return this.defaultTimeDimension;
    }

    @Override
    public boolean isFactIndexing() {
        return true;
    }

    @Override
    public boolean isIndexingByRange() {
        return this.isIndexingByRange;
    }

    public void setIndexingByRange(boolean indexingByRange) {
        this.isIndexingByRange = indexingByRange;
    }

    @Override
    public String getDataTableId() {
        return this.dataTableId;
    }

    public void setDataTableId(String dataTableId) {
        this.dataTableId = dataTableId;
    }

    @Override
    public IOlapBuilderTabularDataDef getDataView() {
        return this.dataTable;
    }

    public void setDataView(IOlapBuilderTabularDataDef dataView) {
        this.dataTable = dataView;
        this.dataTableId = dataView == null ? null : dataView.getId();
    }

    @Override
    @Nullable
    public IOlapBuilderTabularDataDef getDataView(Map<String, IOlapBuilderDataTableDef> tables) {
        if (this.dataTableId == null) {
            return null;
        }
        return tables.get(this.dataTableId);
    }

    @Override
    public List<Class<? extends IOlapBuilderHierarchyDef>> getPotentialHierarchies() {
        return null;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, @Nullable IOlapBuilderTabularDataDef dataView) {
        super.solveReference(referenceSolver, dataView);
        this.dataTable = referenceSolver.getTabularData(this.dataTableId);
        if (this.dataTable == null) {
            return;
        }
        List<IOlapBuilderDataColumnDef> selectedColumns = this.dataTable.getSelectedColumns();
        if (selectedColumns != null && !selectedColumns.isEmpty() && this.hierarchies != null) {
            int size = this.hierarchies.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapBuilderHierarchyDef hierarchy = (IOlapBuilderHierarchyDef)this.hierarchies.get(ii);
                referenceSolver.solveReference(hierarchy, this.dataTable);
            }
        }
    }
}

