/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.dimension;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.empty.OlapBuilderEmptyConnection;
import crazydev.iccube.builder.datasource.empty.OlapBuilderEmptyDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderStatsHierarchy;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.MembersBehavior;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="statisticalDimension")
public class OlapBuilderStatisticalDimension
extends OlapBuilderBaseDimension<OlapBuilderStatsHierarchy> {
    public static final CdProperty DEFAULT_MEMBER_NAME = new CdReadWriteProperty(OlapBuilderStatisticalDimension.class, "statsDefaultMemberName");
    public static final CdProperty HIERARCHY_NAMES = new CdReadWriteProperty(OlapBuilderStatisticalDimension.class, "hierarchyNames");
    public static final CdProperty FOLDER_NAME = new CdReadWriteProperty(OlapBuilderStatisticalDimension.class, "folderName");
    public static final CdProperty MEMBERS_BEHAVIOR = new CdReadWriteProperty(OlapBuilderStatisticalDimension.class, "membersBehavior");
    @XmlTransient
    protected final List<OlapBuilderStatsHierarchy> hierarchies = new ArrayList<OlapBuilderStatsHierarchy>();
    @XmlAttribute(name="defaultMemberName", required=true)
    private String statsDefaultMemberName;
    @XmlElement(required=true)
    private List<String> hierarchyNames;
    @XmlAttribute(required=false)
    private String folderName;
    @XmlAttribute(required=false)
    @Nullable
    private MembersBehavior membersBehavior;
    @XmlTransient
    private OlapBuilderBaseDataTable<OlapBuilderEmptyConnection> datable;

    public OlapBuilderStatisticalDimension() {
    }

    public OlapBuilderStatisticalDimension(String name, String defaultMemberName, String ... hierarchyNames) {
        super(name, name);
        this.statsDefaultMemberName = defaultMemberName;
        this.hierarchyNames = new ArrayList<String>();
        if (hierarchyNames != null) {
            for (String value : hierarchyNames) {
                this.hierarchyNames.add(value);
            }
        }
    }

    public void setDefaultMemberName(String defaultMemberName) {
        this.statsDefaultMemberName = defaultMemberName;
    }

    @Override
    @Nullable
    public String getUnknownMemberName() {
        return null;
    }

    @Override
    public boolean isFactIndexing() {
        return false;
    }

    @Override
    public boolean isIndexingByRange() {
        return false;
    }

    @Override
    public boolean isTimeDimension() {
        return false;
    }

    @Override
    public boolean isDefaultTimeDimension() {
        return false;
    }

    @Override
    public boolean withCreateHierarchy() {
        return false;
    }

    @Override
    public List<OlapBuilderStatsHierarchy> getHierarchies() {
        return this.hierarchies;
    }

    @Override
    public List<String> getHierarchyNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.hierarchyNames != null) {
            for (String hierarchyName : this.hierarchyNames) {
                if (!CdStringUtils.isNotNullAndNotBlank((String)hierarchyName)) continue;
                names.add(hierarchyName);
            }
        }
        return names;
    }

    public void setHierarchyNames(List<String> hierarchyNames) {
        this.hierarchyNames = hierarchyNames;
    }

    @Override
    @Nullable
    public IOlapBuilderHierarchyDef getHierarchy(String name) {
        return null;
    }

    @Override
    @Nullable
    public String getDataTableId() {
        return this.datable != null ? this.datable.getId() : null;
    }

    @Override
    public IOlapBuilderTabularDataDef getDataView() {
        return this.datable;
    }

    @Override
    public IOlapBuilderTabularDataDef getDataView(Map<String, IOlapBuilderDataTableDef> tables) {
        return this.datable;
    }

    @Override
    public List<Class<? extends IOlapBuilderHierarchyDef>> getPotentialHierarchies() {
        return Collections.emptyList();
    }

    @Override
    public boolean changesOnIncrementalLoad() {
        return false;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, @Nullable IOlapBuilderTabularDataDef dataView) {
        super.solveReference(referenceSolver, dataView);
        this.hierarchies.clear();
        if (this.hierarchyNames == null) {
            return;
        }
        this.datable = OlapBuilderEmptyDataTable.buildEmpty(this.getName());
        boolean isDefault = true;
        int size = this.hierarchyNames.size();
        for (int ii = 0; ii < size; ++ii) {
            String hierarchyName = this.hierarchyNames.get(ii);
            this.hierarchies.add(new OlapBuilderStatsHierarchy(this.folderName, hierarchyName, this.statsDefaultMemberName, isDefault));
            isDefault = false;
        }
    }

    @Override
    public boolean orderHierarchies(List<String> orderedNames) {
        return false;
    }

    @Override
    @Nullable
    public MembersBehavior getMembersBehavior() {
        return this.membersBehavior;
    }
}

