/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.dimension;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.dimension.BaseDimensionBuilder;
import crazydev.iccube.builder.model.builders.dimension.OlapBuilderDimensionBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseParentChildHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderAdvancedDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderStatisticalDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchy;
import crazydev.iccube.builder.model.validation.OlapBuilderDimensionValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.MembersBehavior;
import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
public abstract class OlapBuilderBaseDimension<T extends IOlapBuilderHierarchyDef>
implements IOlapBuilderDimensionDef<T> {
    public static final CdProperty UUID = new CdReadWriteProperty(OlapBuilderBaseDimension.class, "id");
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderBaseDimension.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderBaseDimension.class, "description");
    public static final CdProperty ALWAYS_VISIBLE_REPORTING = new CdReadWriteProperty(OlapBuilderBaseDimension.class, "alwaysVisibleReporting");
    public static final CdProperty MEMBERS_UPPER_LOWER_CASE_STRATEGY = new CdReadWriteProperty(OlapBuilderBaseDimension.class, "membersUpperLowerCaseStrategy");
    @XmlAttribute(required=true)
    private String id;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=false)
    @Nullable
    private String description;
    @XmlAttribute(required=false)
    @Nullable
    private Boolean alwaysVisibleReporting;
    @XmlAttribute(required=false)
    @Nullable
    private MembersUpperLowerStrategyType membersUpperLowerCaseStrategy;

    protected OlapBuilderBaseDimension() {
        this.resetId();
    }

    protected OlapBuilderBaseDimension(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> createMultiLevelDimension(IOlapBuilderTabularDataDef tabularData, String name, String id, IOlapBuilderHierarchyDef ... hierarchies) {
        return OlapBuilderBaseDimension.createMultiLevelDimension(tabularData, name, id, Arrays.asList(hierarchies));
    }

    public static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> createMultiLevelDimension(IOlapBuilderTabularDataDef tabularData, String name, String id, List<IOlapBuilderHierarchyDef> hierarchies) {
        return new OlapBuilderAdvancedDimension<IOlapBuilderHierarchyDef>(tabularData, name, id, false, false, hierarchies);
    }

    public static IOlapBuilderDimensionDef<IOlapBuilderBaseParentChildHierarchyDef> createParentChildDimension(IOlapBuilderTabularDataDef tabularData, String name, String id, IOlapBuilderBaseParentChildHierarchyDef ... hierarchies) {
        return new OlapBuilderAdvancedDimension<IOlapBuilderBaseParentChildHierarchyDef>(tabularData, name, id, false, false, Arrays.asList(hierarchies));
    }

    public static OlapBuilderTimeWizardDimension createTimeWizardDimension(String name, String id, boolean isDefaultTimeDimension, OlapBuilderTimeWizardHierarchy ... timeWizHierarchies) {
        return new OlapBuilderTimeWizardDimension(name, id, isDefaultTimeDimension, Arrays.asList(timeWizHierarchies));
    }

    public static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> createMultiLevelTimeDimension(IOlapBuilderTabularDataDef tabularData, String name, String id, List<IOlapBuilderHierarchyDef> hierarchies) {
        return new OlapBuilderAdvancedDimension<IOlapBuilderHierarchyDef>(tabularData, name, id, true, true, hierarchies);
    }

    public static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> createMultiLevelNonDefaultTimeDimension(IOlapBuilderTabularDataDef tabularData, String name, String id, List<IOlapBuilderHierarchyDef> hierarchies) {
        return new OlapBuilderAdvancedDimension<IOlapBuilderHierarchyDef>(tabularData, name, id, true, false, hierarchies);
    }

    public static IOlapBuilderDimensionDef createNoFactDimension(String name, String defaultMemberName, String ... hierarchyNames) {
        OlapBuilderStatisticalDimension dimension = new OlapBuilderStatisticalDimension(name, defaultMemberName, hierarchyNames);
        return dimension;
    }

    @Override
    public String getUUID() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String resetId() {
        this.id = java.util.UUID.randomUUID().toString();
        this.resetHierarchyUUIDs();
        return this.id;
    }

    protected void resetHierarchyUUIDs() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public OlapBuilderValidator<IOlapBuilderCubeDef, IOlapBuilderDimensionDef<T>> getValidator() {
        return new OlapBuilderDimensionValidator();
    }

    @Override
    public BaseDimensionBuilder createBuilder(OlapBuilderContext context, OlapDimension olapDimension) {
        return new OlapBuilderDimensionBuilder<T>(context, olapDimension, this.getHierarchies(), this.getValidatedDefaultHierarchy());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    @Override
    @Nullable
    public IOlapBuilderDataTableDef getInternalCreatedDataTable() {
        return null;
    }

    @Override
    public boolean withCreateHierarchy() {
        return true;
    }

    @Override
    public IOlapBuilderHierarchyDef createEmptyHierarchy() {
        throw new RuntimeException("internal error: inconsistent usage of createEmptyHierarchy()");
    }

    @Override
    public void addHierarchyForUX(IOlapBuilderHierarchyDef hierarchy) {
        List hierarchies = this.getHierarchies();
        if (hierarchies == null || hierarchies.size() == 0) {
            hierarchy.setAsDefault();
        }
        this.addHierarchy(hierarchy);
    }

    public void addHierarchy(T hierarchy) {
        throw new CdDoNotCallMeProgrammingException();
    }

    public boolean removeHierarchy(T hierarchy) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    @Nullable
    public T getDefaultHierarchy() {
        List hierarchies = this.getHierarchies();
        if (hierarchies != null) {
            int size = hierarchies.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapBuilderHierarchyDef hierarchy = (IOlapBuilderHierarchyDef)hierarchies.get(ii);
                if (!hierarchy.isDefault()) continue;
                return (T)hierarchy;
            }
        }
        return null;
    }

    @Override
    public T getValidatedDefaultHierarchy() {
        T hierarchy = this.getDefaultHierarchy();
        if (hierarchy == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DIMENSION_WITH_NO_DEFAULT_HIERARCHY, new Serializable[]{this.getName()});
        }
        return hierarchy;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, @Nullable IOlapBuilderTabularDataDef dataView) {
    }

    @Override
    public List<OlapBuilderDataColumnRef> getAllFactIndexingColumns() {
        if (!this.isFactIndexing()) {
            return Collections.emptyList();
        }
        T hierarchy = this.getDefaultHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        return hierarchy.getAllFactIndexingColumns();
    }

    @Override
    public boolean getAlwaysVisibleReporting() {
        return this.alwaysVisibleReporting != null && this.alwaysVisibleReporting != false;
    }

    @Override
    @Nullable
    public MembersUpperLowerStrategyType getMembersUpperLowerCaseStrategy() {
        return this.membersUpperLowerCaseStrategy;
    }

    @Override
    @Nullable
    public MembersBehavior getMembersBehavior() {
        return null;
    }

    @Override
    public List<IOlapBuilderAttributeDef> getAttributes() {
        List<IOlapBuilderHierarchyLevelDef> levels;
        T defaultHierarchy = this.getDefaultHierarchy();
        if (defaultHierarchy != null && (levels = defaultHierarchy.getLevels()) != null) {
            ArrayList<IOlapBuilderAttributeDef> attributeDefs = new ArrayList<IOlapBuilderAttributeDef>();
            levels.forEach(level -> attributeDefs.addAll(level.getAttributes()));
            return attributeDefs;
        }
        return Collections.emptyList();
    }
}

