/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.dimension;

import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTabularDataBasedDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseWithAllHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderParentChildHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderPathHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderStatsHierarchy;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.hierarchy.wizard.UxBuilderAdvancedHierarchyTypeSelectorForm;
import crazydev.iccube.builder.ux.meta.hierarchy.wizard.UxBuilderCreateHierarchyWizard;
import crazydev.iccube.builder.ux.meta.hierarchy.wizard.UxBuilderCreateHierarchyWizardSteps;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="dimension")
public class OlapBuilderAdvancedDimension<T extends IOlapBuilderHierarchyDef>
extends OlapBuilderTabularDataBasedDimension<T> {
    public OlapBuilderAdvancedDimension() {
    }

    protected OlapBuilderAdvancedDimension(IOlapBuilderTabularDataDef tabularData, String name, String id, boolean timeDimension, boolean defaultTimeDimension, List<T> hierarchies) {
        super(tabularData, name, id, hierarchies, timeDimension, defaultTimeDimension);
    }

    @Override
    public List<Class<? extends IOlapBuilderHierarchyDef>> getPotentialHierarchies() {
        return Arrays.asList(OlapBuilderStatsHierarchy.class, OlapBuilderMultiLevelHierarchy.class, OlapBuilderParentChildHierarchy.class, OlapBuilderPathHierarchy.class);
    }

    @Override
    public UxBuilderCreateHierarchyWizard setupCreateHierarchyWizard() {
        List<UxBuilderWizardStep> steps = Arrays.asList(UxBuilderCreateHierarchyWizardSteps.advancedHierarchyTypes(), UxBuilderCreateHierarchyWizardSteps.more());
        return new UxBuilderCreateHierarchyWizard(this, this.getUUID(), this.getName(), steps){
            {
                Objects.requireNonNull(this$0);
                super(dimensionUUID, dimensionName, steps);
            }

            @Override
            public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
                if (activeStep == 0) {
                    UxBuilderAdvancedHierarchyTypeSelectorForm form = (UxBuilderAdvancedHierarchyTypeSelectorForm)((UxBuilderWizardStep)this.steps.getFirst()).getModel();
                    String type = form.getType();
                    try {
                        Class<?> clazz = Class.forName(type);
                        IOlapBuilderHierarchyDef hierarchy = (IOlapBuilderHierarchyDef)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (hierarchy instanceof OlapBuilderBaseWithAllHierarchy) {
                            ((OlapBuilderBaseWithAllHierarchy)hierarchy).setHasAllLevel(true);
                        }
                        ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
                        newSteps.add(UxBuilderCreateHierarchyWizardSteps.hierarchy(hierarchy));
                        return new UxBuilderWizardValidation(activeStep, newSteps);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] could not create the hierarchy : " + type), (Throwable)ex);
                        throw new RuntimeException("unexpected hierarchy type : " + type, ex);
                    }
                }
                throw new RuntimeException("unexpected validation step : " + activeStep);
            }

            @Override
            public IOlapBuilderHierarchyDef getHierarchyFromUI() {
                return (IOlapBuilderHierarchyDef)((UxBuilderWizardStep)this.steps.get(1)).getModel();
            }
        };
    }
}

