/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.colors;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifier;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.validation.OlapBuilderColorsValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="colors")
public class OlapBuilderColors
implements IOlapBuilderColorsDef {
    public static final String COLUMN_COLOR = "color";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_LEVEL = "level";
    public static final String COLUMN_HIERARCHY = "hierarchy";
    public static final String COLUMN_DIMENSION = "dimension";
    public static final String COLUMN_UNAME = "uniqueName";
    public static final CdProperty ENABLED = new CdReadWriteProperty(OlapBuilderColors.class, "enabled");
    public static final CdProperty DATA_VIEW = new CdReadWriteProperty(OlapBuilderColors.class, "dataTableId"){

        public Class<?> getType() {
            return OlapBuilderTabularDataXmlIdentifier.class;
        }
    };
    @XmlAttribute(name="enabled", required=false)
    private boolean enabled;
    @XmlAttribute(name="dataTableId")
    private String dataTableId;
    @XmlTransient
    private IOlapBuilderTabularDataDef dataTable;

    public OlapBuilderColors() {
    }

    public OlapBuilderColors(boolean enabled) {
        this.enabled = enabled;
    }

    public OlapBuilderColors(boolean enabled, String dataTableId) {
        this.enabled = enabled;
        this.dataTableId = dataTableId;
    }

    @Override
    public boolean isActivated() {
        if (!this.enabled) {
            return false;
        }
        if (CdStringUtils.isNullOrBlank((String)this.dataTableId)) {
            return false;
        }
        IOlapBuilderTabularDataDef view = this.getDataView();
        return view != null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public String getDataTableId() {
        return this.dataTableId;
    }

    @Override
    public IOlapBuilderTabularDataDef getDataView() {
        return this.dataTable;
    }

    @Override
    public String getContextVisualId() {
        return this.getName();
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, @Nullable IOlapBuilderTabularDataDef dataView) {
        if (this.isEnabled()) {
            this.dataTable = referenceSolver.getTabularData(this.dataTableId);
        }
    }

    public OlapBuilderColorsValidator getValidator() {
        return new OlapBuilderColorsValidator();
    }
}

