/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.browsing;

import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.browsing.IOlapBuilderBrowsingDataTableInfo;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OlapBuilderBrowsingDataTableInfo
implements IOlapBuilderBrowsingDataTableInfo {
    private final IOlapBuilderTabularDataDef tabularData;
    private final int pageSize;
    private final int pageNumber;
    private final int maxRowCount;
    private final List<OlapBuilderBaseDataTableRow> rows = new ArrayList<OlapBuilderBaseDataTableRow>();
    private final int firstCollectedRowNumber;
    private int collectedRowNumber;

    public OlapBuilderBrowsingDataTableInfo(IOlapBuilderTabularDataDef tabularData, int pageSize, int pageNumber) {
        this.tabularData = tabularData;
        this.pageSize = Math.min(pageSize, 10000);
        this.pageNumber = pageNumber;
        this.maxRowCount = this.pageSize * this.pageNumber;
        this.firstCollectedRowNumber = this.maxRowCount - this.pageSize;
        this.collectedRowNumber = 0;
    }

    @Override
    public boolean isAttachedTo(IOlapBuilderTabularDataDef tabularData) {
        return this.tabularData == tabularData;
    }

    @Override
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRowBrowsed(OlapBuilderBaseDataTableRow row) {
        List<OlapBuilderBaseDataTableRow> list = this.rows;
        synchronized (list) {
            if (!this.isDone() && this.collectedRowNumber >= this.firstCollectedRowNumber) {
                this.rows.add(row);
            }
            ++this.collectedRowNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapBuilderBaseDataTableRow> getRows() {
        List<OlapBuilderBaseDataTableRow> list = this.rows;
        synchronized (list) {
            return Collections.unmodifiableList(this.rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        List<OlapBuilderBaseDataTableRow> list = this.rows;
        synchronized (list) {
            return this.rows.size() >= this.maxRowCount;
        }
    }
}

