/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.validation.OlapBuilderPropertyValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="property")
public class OlapBuilderProperty
implements IOlapBuilderPropertyDef {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderProperty.class, "name");
    public static final CdProperty COLUMN = new CdReadWriteProperty(OlapBuilderProperty.class, "propertyColumnRef");
    @XmlAttribute(required=true, name="name")
    private String name;
    @XmlElement(name="column", required=true)
    private OlapBuilderDataColumnRef propertyColumnRef;
    @XmlTransient
    private IOlapBuilderDataColumnDef propertyColumn;
    @XmlTransient
    private OlapBuilderInputType type;

    public OlapBuilderProperty() {
    }

    public OlapBuilderProperty(String name, IOlapBuilderDataColumnDef propertyColumn) {
        this.name = name;
        this.propertyColumn = propertyColumn;
        this.propertyColumnRef = OlapBuilderDataColumnRef.asRef(propertyColumn);
    }

    public OlapBuilderProperty(IOlapBuilderAttributeDef attributeDef) {
        this.name = attributeDef.getName();
        this.type = attributeDef.getType();
    }

    @Override
    public OlapBuilderInputType getPropertyType() {
        return this.type != null ? this.type : this.propertyColumn.getType();
    }

    @Override
    public boolean isAttribute() {
        return this.type != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAutoExportedToReportingMF() {
        return this.name.startsWith("ic3auto_");
    }

    @Override
    public IOlapBuilderDataColumnDef getPropertyColumn() {
        return this.propertyColumn;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    public static IOlapBuilderPropertyDef createProperty(String name, IOlapBuilderDataColumnDef column) {
        return new OlapBuilderProperty(name, column);
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef dataView) {
        this.propertyColumn = referenceSolver.getColumn(dataView, this.propertyColumnRef);
    }

    public OlapBuilderValidator getValidator() {
        return new OlapBuilderPropertyValidator();
    }
}

