/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.common.OlapBuilderCubeXmlIdentifier;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderCube;
import crazydev.iccube.builder.model.validation.OlapBuilderPerspectivesValidator;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="perspectives")
public class OlapBuilderPerspective
implements IOlapBuilderPerspectiveDef {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderPerspective.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderPerspective.class, "description");
    public static final CdProperty DEFINITION = new CdReadWriteProperty(OlapBuilderPerspective.class, "definition");
    public static final CdProperty IS_DEFAULT = new CdReadWriteProperty(OlapBuilderPerspective.class, "isDefault");
    public static final CdProperty CUBE = new CdReadWriteProperty(OlapBuilderPerspective.class, "cubeId"){

        public Class<?> getType() {
            return OlapBuilderCubeXmlIdentifier.class;
        }
    };
    @XmlAttribute(required=false, name="cubeId")
    private String cubeId;
    @XmlAttribute(required=true, name="name")
    private String name;
    @XmlAttribute(required=false, name="description")
    @Nullable
    private String description;
    @XmlAttribute(required=true, name="isDefault")
    private boolean isDefault;
    @XmlElement(required=true, name="definition")
    private String definition;
    @XmlTransient
    @Nullable
    private IOlapBuilderCubeDef cube;

    public OlapBuilderPerspective() {
    }

    public OlapBuilderPerspective(String name, String definition, boolean isDefault) {
        this(name, definition, isDefault, null);
    }

    public OlapBuilderPerspective(String name, String definition, boolean isDefault, @Nullable OlapBuilderCube cube) {
        this.name = name;
        this.definition = definition;
        this.isDefault = isDefault;
        this.cube = cube;
        this.cubeId = cube != null ? cube.getId() : null;
    }

    public OlapBuilderPerspective setupForEmptyModel() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    @Nullable
    public String getCubeId() {
        return CdStringUtils.isNullOrBlank((String)this.cubeId) ? null : this.cubeId;
    }

    @Override
    @Nullable
    public IOlapBuilderCubeDef getCube() {
        return this.cube;
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    @Nullable
    public OlapRegularCube getOlapCube(OlapNameContext nameContext, OlapSchema schema) {
        return this.cube == null ? null : schema.lookupCubeByName(nameContext, this.cube.getName());
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    @Override
    public OlapValidator getValidator() {
        return new OlapBuilderPerspectivesValidator();
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, @Nullable IOlapBuilderTabularDataDef dataView) {
        this.cube = referenceSolver.getCube(this.getCubeId());
    }
}

