/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.validation.OlapBuilderMeasureValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapAggregationType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="measure")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OlapBuilderMeasure
implements IOlapBuilderMeasureDef,
IOlapBuilderJaxbListener {
    public static final CdProperty UUID = new CdReadWriteProperty(OlapBuilderMeasure.class, "uuid");
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderMeasure.class, "name");
    public static final CdProperty ROLLUP_HIERARCHY = new CdReadWriteProperty(OlapBuilderMeasure.class, "rollupHierarchy");
    public static final CdProperty COLUMN = new CdReadWriteProperty(OlapBuilderMeasure.class, "columnRef");
    public static final CdProperty AGGREGATION_TYPE = new CdReadWriteProperty(OlapBuilderMeasure.class, "aggregationType");
    public static final CdProperty EMPTY_IS_ZERO = new CdReadWriteProperty(OlapBuilderMeasure.class, "emptyIsZero");
    public static final CdProperty CELL_PROPERTIES = new CdReadWriteProperty(OlapBuilderMeasure.class, "cellProperties");
    public static final CdProperty SELECTED = new CdReadWriteProperty(OlapBuilderMeasure.class, "selected");
    @XmlAttribute(name="uuid", required=true)
    private String uuid = java.util.UUID.randomUUID().toString();
    @XmlAttribute(required=true)
    private String name;
    @XmlElement(name="rollupHierarchy", required=false)
    @Nullable
    private String rollupHierarchy;
    @XmlElement(name="dataColumn", required=true)
    private OlapBuilderDataColumnRef columnRef;
    @XmlAttribute(required=true)
    private OlapAggregationType aggregationType = OlapAggregationType.SUM;
    @XmlAttribute(required=false)
    @Nullable
    private OlapBuilderInputType factDataType;
    @XmlAttribute(name="cellProperties", required=false)
    @Nullable
    private String _cellProperties;
    @XmlElement(name="cellProperties", required=false)
    @Nullable
    private String cellProperties;
    @XmlElement(name="emptyIsZero")
    @Nullable
    private Boolean emptyIsZero;
    @XmlTransient
    private IOlapBuilderDataColumnDef column;
    @XmlTransient
    private boolean isManyToManyMember;
    @XmlTransient
    private Boolean selected;

    public OlapBuilderMeasure() {
    }

    public OlapBuilderMeasure(String name, OlapAggregationType aggregationType, OlapBuilderInputType factDataType, boolean isManyToMany) {
        this(name, aggregationType, new OlapBuilderDataColumn(factDataType, factDataType.getName(), name));
        this.factDataType = factDataType;
        this.isManyToManyMember = isManyToMany;
    }

    public OlapBuilderMeasure(String name, OlapAggregationType aggregationType) {
        this(name, aggregationType, OlapBuilderDataColumn.createDoubleColumn(name));
    }

    public OlapBuilderMeasure(String name, OlapAggregationType aggregationType, IOlapBuilderDataColumnDef column) {
        this(name, aggregationType, column, null);
    }

    public OlapBuilderMeasure(String name, OlapAggregationType aggregationType, IOlapBuilderDataColumnDef column, @Nullable String cellProperties) {
        this(name, aggregationType, null, column, cellProperties);
    }

    public OlapBuilderMeasure(String name, OlapAggregationType aggregationType, @Nullable String rollupHierarchy, IOlapBuilderDataColumnDef column, @Nullable String cellProperties) {
        this.name = name;
        this.aggregationType = aggregationType;
        this.rollupHierarchy = rollupHierarchy;
        this.cellProperties = cellProperties;
        this.column = column;
        this.columnRef = OlapBuilderDataColumnRef.asRef(column);
    }

    public boolean isSelected() {
        return this.selected != null && this.selected != false;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public static IOlapBuilderMeasureDef proto() {
        OlapBuilderMeasure proto = new OlapBuilderMeasure();
        proto.uuid = null;
        proto.selected = true;
        return proto;
    }

    public IOlapBuilderMeasureDef setupForEmptyModel() {
        return this;
    }

    @Override
    public void beforeMarshal() {
        this._cellProperties = null;
        if (this.uuid == null) {
            this.uuid = java.util.UUID.randomUUID().toString();
        }
    }

    @Override
    public void afterUnmarshal() {
        if (this.cellProperties == null) {
            this.cellProperties = this._cellProperties;
        }
        if (this.uuid == null) {
            this.uuid = java.util.UUID.randomUUID().toString();
        }
    }

    @Override
    public String getKey() {
        return this.getColumn().getName();
    }

    @Override
    public OlapBuilderInputType getFactDataType() {
        return this.factDataType == null ? this.getInputValueType() : this.factDataType;
    }

    @Override
    @Nullable
    public OlapBuilderColumnDecorationType getFactDataTypeDecoration() {
        return this.column.getDecorationType();
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getRollupHierarchy() {
        return this.rollupHierarchy;
    }

    public void setRollupHierarchy(@Nullable String rollupHierarchy) {
        this.rollupHierarchy = rollupHierarchy;
    }

    @Override
    public OlapBuilderInputType getInputValueType() {
        return this.getColumn().getType();
    }

    @Override
    public OlapAggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(OlapAggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    @Override
    public boolean emptyIsZero() {
        return this.emptyIsZero == null ? false : this.emptyIsZero;
    }

    public void setColumnRef(OlapBuilderDataColumnRef columnRef) {
        this.columnRef = columnRef;
    }

    @Override
    public IOlapBuilderDataColumnDef getColumn() {
        return this.column;
    }

    @Override
    @Nullable
    public String getCellProperties() {
        return this.cellProperties;
    }

    public void setCellProperties(@Nullable String cellProperties) {
        this.cellProperties = cellProperties;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef dataTable) {
        this.column = referenceSolver.getColumn(dataTable, this.columnRef);
    }

    @Override
    public boolean isManyToManyMember() {
        return this.isManyToManyMember;
    }

    public OlapBuilderValidator<IOlapBuilderBaseFactsDef, IOlapBuilderMeasureDef> getValidator() {
        return new OlapBuilderMeasureValidator();
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

