/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.collection.CdCollections;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.builders.bridge.OlapBridgeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderBridgeRef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.IMMUTABLE)
@XmlRootElement(name="viewLinks")
public class OlapBuilderDataViewLinks
implements IOlapBuilderDataViewLinksDef,
IOlapBuilderJaxbListener {
    @XmlAttribute(required=false)
    @Nullable
    private OlapBuilderDataViewLinksType type;
    @XmlElements(value={@XmlElement(name="fromLevelNames")})
    private List<String> fromLevelNames = new ArrayList<String>();
    @XmlAttribute(name="bridgeDataTableId")
    @Nullable
    private String bridgeDataTableId;
    @XmlElements(value={@XmlElement(name="fromColumns")})
    private List<OlapBuilderDataColumnRef> fromColumnsRef = new ArrayList<OlapBuilderDataColumnRef>();
    @XmlElements(value={@XmlElement(name="toColumns")})
    private List<OlapBuilderDataColumnRef> toColumnsRef = new ArrayList<OlapBuilderDataColumnRef>();
    @XmlElements(value={@XmlElement(name="bridgeJoinColumns")})
    private List<OlapBuilderDataColumnRef> bridgeJoinColumnsRef = new ArrayList<OlapBuilderDataColumnRef>();
    @XmlElement(name="bridges")
    @Nullable
    private OlapBuilderBridges bridges;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> fromColumns;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> toColumns;
    @XmlTransient
    @Nullable
    private IOlapBuilderTabularDataDef bridgeTable;

    private OlapBuilderDataViewLinks() {
    }

    public OlapBuilderDataViewLinks(OlapBuilderDataViewLinksType type) {
        this.type = type;
    }

    public OlapBuilderDataViewLinks(OlapBuilderDataViewLinksType type, List<OlapBuilderDataColumnRef> fromColumns, List<OlapBuilderDataColumnRef> toColumns, boolean ignore) {
        this.type = type;
        this.fromLevelNames = null;
        this.fromColumnsRef = fromColumns;
        this.toColumnsRef = toColumns;
    }

    public OlapBuilderDataViewLinks(IOlapBuilderDataColumnDef fromColumns, IOlapBuilderDataColumnDef toColumns) {
        this(Collections.singletonList(fromColumns), Collections.singletonList(toColumns));
    }

    public OlapBuilderDataViewLinks(OlapBuilderDataViewLinksType type, IOlapBuilderDataColumnDef fromColumns, IOlapBuilderDataColumnDef toColumns) {
        this(Collections.singletonList(fromColumns), Collections.singletonList(toColumns));
        this.type = type;
    }

    private OlapBuilderDataViewLinks(IOlapBuilderDataColumnDef[] fromColumns, IOlapBuilderDataColumnDef[] toColumns) {
        this(Arrays.asList(fromColumns), Arrays.asList(toColumns));
    }

    private OlapBuilderDataViewLinks(List<IOlapBuilderDataColumnDef> fromColumns, List<IOlapBuilderDataColumnDef> toColumns) {
        this.fromColumns = fromColumns;
        this.toColumns = toColumns;
        this.fromColumnsRef = OlapBuilderDataColumnRef.asRef(fromColumns);
        this.toColumnsRef = OlapBuilderDataColumnRef.asRef(toColumns);
    }

    public static OlapBuilderDataViewLinks createSymmetricalLink(IOlapBuilderDataColumnDef ... fromToColumns) {
        return new OlapBuilderDataViewLinks(fromToColumns, fromToColumns);
    }

    public static OlapBuilderDataViewLinks createLink(IOlapBuilderDataColumnDef fromColumn, IOlapBuilderDataColumnDef toColumn) {
        return new OlapBuilderDataViewLinks(fromColumn, toColumn);
    }

    public static OlapBuilderDataViewLinks createLink(OlapBuilderDataViewLinksType type, IOlapBuilderDataColumnDef fromColumn, IOlapBuilderDataColumnDef toColumn) {
        return new OlapBuilderDataViewLinks(type, fromColumn, toColumn);
    }

    public static OlapBuilderDataViewLinks createFromBridge(OlapBuilderDataViewLinksType type, List<OlapBuilderBridgeRef> refs) {
        return OlapBuilderDataViewLinks.createFromBridge(type, null, refs);
    }

    public static OlapBuilderDataViewLinks createFromBridge(OlapBuilderDataViewLinksType type, List<String> fromLevelNames, List<OlapBuilderBridgeRef> refs) {
        OlapBuilderDataViewLinks links = new OlapBuilderDataViewLinks();
        links.type = type;
        links.fromLevelNames = fromLevelNames;
        links.bridges = new OlapBuilderBridges();
        for (OlapBuilderBridgeRef ref : refs) {
            links.bridges.add(ref);
        }
        return links;
    }

    public static OlapBuilderDataViewLinks createFromColumnsRef(OlapBuilderDataViewLinksType type, List<OlapBuilderDataColumnRef> fromColumns, List<OlapBuilderDataColumnRef> toColumns) {
        OlapBuilderDataViewLinks links = new OlapBuilderDataViewLinks();
        links.type = type;
        links.fromLevelNames = null;
        links.fromColumnsRef = fromColumns;
        links.toColumnsRef = toColumns;
        return links;
    }

    public static OlapBuilderDataViewLinks createFromLevelNames(OlapBuilderDataViewLinksType type, List<String> fromLevelNames, List<OlapBuilderDataColumnRef> toColumns) {
        OlapBuilderDataViewLinks links = new OlapBuilderDataViewLinks();
        links.type = type;
        links.fromLevelNames = fromLevelNames;
        links.fromColumnsRef = null;
        links.toColumnsRef = toColumns;
        return links;
    }

    @Override
    public boolean isEmpty() {
        return !(this.type == OlapBuilderDataViewLinksType.NOT_MAPPED || this.fromColumnsRef != null && !this.fromColumnsRef.isEmpty() || this.toColumnsRef != null && !this.toColumnsRef.isEmpty());
    }

    @Override
    public OlapBuilderDataViewLinksType getType() {
        if (this.type == null) {
            if (this.isEmpty()) {
                return OlapBuilderDataViewLinksType.NOT_MAPPED;
            }
            return OlapBuilderDataViewLinksType.OLD_GENERATION;
        }
        return this.type;
    }

    @Override
    public List<String> getFromLevelNames() {
        return this.fromLevelNames;
    }

    @Override
    public List<OlapBuilderDataColumnRef> getFromColumnsRef() {
        return this.fromColumnsRef;
    }

    @Override
    public List<OlapBuilderDataColumnRef> getToColumnsRef() {
        return this.toColumnsRef;
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getFromColumns() {
        if (this.isBridge()) {
            return ((OlapBuilderBridgeRef)CdCollections.last(this.bridges.bridges)).getBridgeKeyDef();
        }
        return this.fromColumns;
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getToColumns() {
        if (this.isBridge()) {
            return this.bridges.get(0).getFactJoinDef();
        }
        return this.toColumns;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef fromDataTable, IOlapBuilderTabularDataDef toDataTable) {
        this.bridgeTable = referenceSolver.getTabularData(this.bridgeDataTableId);
        this.toColumns = referenceSolver.getColumns(toDataTable, this.toColumnsRef);
        this.fromColumns = referenceSolver.getColumns(fromDataTable, this.fromColumnsRef);
        if (this.bridges != null) {
            IOlapBuilderTabularDataDef leftBridgetable = toDataTable;
            for (OlapBuilderBridgeRef bridgeRef : this.bridges.bridges) {
                leftBridgetable = bridgeRef.solveReference(referenceSolver, leftBridgetable);
            }
        }
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getDimensionBindingColumn() {
        return !this.isBridge() ? this.getToColumns() : this.getFromColumns();
    }

    @Override
    public boolean isOldType() {
        return this.type == null || this.type == OlapBuilderDataViewLinksType.OLD_GENERATION;
    }

    @Override
    public boolean isBridge() {
        return this.bridges != null && !this.bridges.isEmpty();
    }

    @Nullable
    public OlapBuilderBridges getBridgeDefs() {
        return this.bridges;
    }

    @Override
    @Nullable
    public OlapBridgeDef buildBridge() {
        if (!this.isBridge()) {
            return null;
        }
        return new OlapBridgeDef(this.bridges.bridges);
    }

    @Override
    public List<OlapBuilderBridgeRef> getBridgesRef() {
        return this.bridges.bridges;
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.bridgeDataTableId)) {
            this.bridges = new OlapBuilderBridges();
            this.bridges.add(new OlapBuilderBridgeRef(this.bridgeDataTableId, this.toColumnsRef, this.bridgeJoinColumnsRef, this.fromColumnsRef, false));
            this.bridgeDataTableId = null;
            this.toColumnsRef = null;
            this.bridgeJoinColumnsRef = null;
            this.fromColumnsRef = null;
        }
    }

    @CdThreadSupport(value=CdThreadSupportLevel.IMMUTABLE)
    @XmlRootElement(name="bridges")
    public static class OlapBuilderBridges {
        @XmlElement(name="bridge")
        List<OlapBuilderBridgeRef> bridges = new ArrayList<OlapBuilderBridgeRef>();

        OlapBuilderBridges() {
        }

        public List<OlapBuilderBridgeRef> getBridges() {
            return this.bridges;
        }

        public void add(OlapBuilderBridgeRef bridgeRef) {
            this.bridges.add(bridgeRef);
        }

        public OlapBuilderBridgeRef get(int i) {
            return this.bridges.get(0);
        }

        public boolean isEmpty() {
            return this.bridges.isEmpty();
        }
    }
}

