/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.status.OlapBuilderDataColumnRefreshStatus;
import crazydev.iccube.builder.model.status.OlapBuilderRefreshStatusKind;
import crazydev.iccube.builder.model.validation.OlapBuilderDataColumnValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="column")
public class OlapBuilderDataColumn
implements IOlapBuilderDataColumnDef,
IOlapBuilderJaxbListener {
    public static final IOlapBuilderDataColumnDef EMPTY = new OlapBuilderDataColumn();
    public static final String TABLE_TYPE_4_VIEW = "VIEW";
    public static final String STRING = "STRING";
    public static final String DOUBLE = "DOUBLE";
    public static final String INTEGER = "INTEGER";
    public static final String DATE = "DATE";
    public static final String DATETIME = "DATETIME";
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderDataColumn.class, "name");
    public static final CdProperty TABLE_TYPE = new CdReadWriteProperty(OlapBuilderDataColumn.class, "tableType");
    public static final CdProperty OUTPUT_TYPE = new CdReadWriteProperty(OlapBuilderDataColumn.class, "type");
    public static final CdProperty TYPE_DECORATION = new CdReadWriteProperty(OlapBuilderDataColumn.class, "decorationType", false);
    public static final CdProperty SELECTED = new CdReadWriteProperty(OlapBuilderDataColumn.class, "selected");
    public static final CdProperty NULL_OBJECT_AS_STRING = new CdReadWriteProperty(OlapBuilderDataColumn.class, "nullObjectAsString");
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute
    @Nullable
    private String tableType;
    @XmlAttribute
    private OlapBuilderInputType type;
    @XmlAttribute(required=false)
    @Nullable
    private OlapBuilderColumnDecorationType decorationType;
    @XmlAttribute
    private Boolean selected;
    @XmlAttribute
    @Nullable
    private String nullObjectAsString;
    @XmlTransient
    private boolean cleanUpBySolver;
    @XmlTransient
    @Nullable
    private Comparable nullObject;
    @XmlTransient
    private int index = -1;
    @XmlTransient
    private int jdbcIndex = -1;

    public OlapBuilderDataColumn() {
    }

    public OlapBuilderDataColumn(OlapBuilderInputType type, String tableType, String name, boolean isArray) {
        this(type, tableType, name, true, isArray);
    }

    public OlapBuilderDataColumn(OlapBuilderInputType type, String tableType, String name) {
        this(type, tableType, name, true, false);
    }

    public OlapBuilderDataColumn(OlapBuilderInputType type, String tableType, String name, String nullObjectAsString) {
        this(type, tableType, name, true, false);
        this.nullObjectAsString = nullObjectAsString;
    }

    public OlapBuilderDataColumn(OlapBuilderInputType type, @Nullable String tableType, String name, @Nullable OlapBuilderColumnDecorationType decorationType) {
        this.type = type;
        this.tableType = tableType;
        this.name = name;
        this.decorationType = decorationType;
    }

    public OlapBuilderDataColumn(OlapBuilderInputType type, @Nullable String tableType, String name, boolean selected, boolean isArray) {
        this.type = type;
        this.tableType = tableType;
        this.name = name;
        this.selected = selected;
        this.decorationType = isArray ? OlapBuilderColumnDecorationType.ARRAY : null;
    }

    public IOlapBuilderDataColumnDef setupForEmptyModel() {
        return this;
    }

    @Override
    public IOlapBuilderDataColumnDef duplicateForView(@Nullable String newName) {
        OlapBuilderDataColumn clone = new OlapBuilderDataColumn();
        clone.name = newName == null ? this.name : newName;
        clone.tableType = TABLE_TYPE_4_VIEW;
        clone.type = this.type;
        clone.decorationType = this.decorationType;
        clone.selected = this.selected;
        clone.nullObjectAsString = this.nullObjectAsString;
        return clone;
    }

    @Override
    @Nullable
    public String getNullObjectAsString() {
        return this.nullObjectAsString;
    }

    public void setNullObjectAsString(@Nullable String nullObjectAsString) {
        this.nullObjectAsString = nullObjectAsString;
    }

    @Override
    @Nullable
    public Comparable getNullObject() {
        if (this.nullObject == null) {
            if (this.nullObjectAsString == null || this.nullObjectAsString.isEmpty()) {
                return null;
            }
            this.nullObject = this.getType().toJavaNativeValue(this.name, this.nullObjectAsString);
        }
        return this.nullObject;
    }

    public OlapBuilderDataColumn duplicate() {
        return new OlapBuilderDataColumn(this.type, this.tableType, this.name, this.selected, false);
    }

    public static IOlapBuilderDataColumnDef createDoubleColumn(String name) {
        return new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, DOUBLE, name);
    }

    public static IOlapBuilderDataColumnDef createStringColumn(String name) {
        return new OlapBuilderDataColumn(OlapBuilderInputType.STRING, STRING, name);
    }

    public static IOlapBuilderDataColumnDef createVARCHARColumn(String name, int len) {
        return new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "VARCHAR(" + len + ")", name);
    }

    public static IOlapBuilderDataColumnDef createIntegerColumn(String name) {
        return new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, INTEGER, name);
    }

    public static IOlapBuilderDataColumnDef createDateColumn(String name) {
        return new OlapBuilderDataColumn(OlapBuilderInputType.DATE, DATE, name);
    }

    public static IOlapBuilderDataColumnDef createDateTimeColumn(String name) {
        return new OlapBuilderDataColumn(OlapBuilderInputType.DATETIME, DATETIME, name);
    }

    public static List<IOlapBuilderDataColumnDef> createStringColumns(String ... names) {
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>(names.length);
        for (String name : names) {
            columns.add(OlapBuilderDataColumn.createStringColumn(StringUtils.trim((String)name)));
        }
        return columns;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public OlapBuilderInputType getType() {
        return this.type;
    }

    public void setType(OlapBuilderInputType type) {
        this.type = type;
    }

    @Override
    @Nullable
    public OlapBuilderColumnDecorationType getDecorationType() {
        return this.decorationType;
    }

    public void setDecorationType(OlapBuilderColumnDecorationType decorationType) {
        this.decorationType = decorationType;
    }

    @Override
    @Nullable
    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(@Nullable String tableType) {
        this.tableType = tableType;
    }

    @Override
    public boolean isSelected() {
        return this.selected == null || this.selected != false;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isForTableSelect() {
        return this.selected != false && !this.cleanUpBySolver;
    }

    @Override
    public void setCleanUpBySolver(boolean cleanUpBySolver) {
        this.cleanUpBySolver = cleanUpBySolver;
    }

    @Override
    public void updateFrom(IOlapBuilderDataColumnDef other, OlapBuilderDataColumnRefreshStatus refreshStatus) {
        if (this == other) {
            return;
        }
        String thisTableType = this.tableType;
        String otherTableType = other.getTableType();
        if (thisTableType == null) {
            if (otherTableType != null) {
                refreshStatus.setStatus(OlapBuilderRefreshStatusKind.UPDATED);
                refreshStatus.setTypeFrom(otherTableType);
                refreshStatus.setTypeTo(thisTableType);
            }
        } else if (!thisTableType.equals(otherTableType)) {
            refreshStatus.setStatus(OlapBuilderRefreshStatusKind.UPDATED);
            refreshStatus.setTypeFrom(otherTableType);
            refreshStatus.setTypeTo(thisTableType);
        }
        this.selected = other.isSelected();
        this.type = other.getType();
        this.nullObjectAsString = other.getNullObjectAsString();
        this.decorationType = other.getDecorationType();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setIsArray() {
        this.decorationType = OlapBuilderColumnDecorationType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return this.decorationType == OlapBuilderColumnDecorationType.ARRAY;
    }

    @Override
    public boolean isLinkedTo(IOlapBuilderDataColumnDef columnDef) {
        return columnDef.getName().startsWith(this.name) && this.type.equals((Object)columnDef.getType());
    }

    public OlapBuilderValidator<IOlapBuilderDataTableDef<?>, IOlapBuilderDataColumnDef> getValidator() {
        return new OlapBuilderDataColumnValidator();
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapBuilderDataColumn that = (OlapBuilderDataColumn)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
        this.selected = this.selected == null || this.selected != false;
        this.tableType = this.tableType == null ? STRING : this.tableType;
        this.type = this.type == null ? OlapBuilderInputType.STRING : this.type;
    }

    @Nullable
    public static IOlapBuilderDataColumnDef lookupColumn(List<IOlapBuilderDataColumnDef> columns, @Nullable String columnName) {
        if (CdStringUtils.isNullOrBlank((String)columnName)) {
            return null;
        }
        for (IOlapBuilderDataColumnDef column : columns) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    @Override
    public int getJdbcIndex() {
        return this.jdbcIndex;
    }

    @Override
    public void setJdbcIndex(int idx) {
        this.jdbcIndex = idx;
    }
}

