/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.def;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdIComparableList;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.lang.reflect.Array;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderAbstractTableRow
implements IOlapBuilderTableRow {
    @Override
    @Nullable
    public final Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
        Object value = this.getDataImpl(columnDef);
        if (columnDef.getDecorationType() != OlapBuilderColumnDecorationType.ARRAY) {
            return this.asJavaValue(columnDef, value);
        }
        CdComparableArray ret = this.toArray(columnDef, value);
        Comparable nullObject = columnDef.getNullObject();
        if (ret == null && nullObject != null) {
            return new CdComparableArray(new Comparable[]{nullObject});
        }
        return ret;
    }

    @Nullable
    private CdComparableArray toArray(IOlapBuilderDataColumnDef columnDef, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CdIComparableList) {
            return ((CdIComparableList)value).toComparableArray();
        }
        if (value instanceof String) {
            value = ((String)value).split(" ");
        }
        OlapBuilderInputType columnType = columnDef.getType();
        String columnName = columnDef.getName();
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return null;
            }
            Comparable[] converterValue = new Comparable[length];
            for (int i = 0; i < length; ++i) {
                Object inputValue = Array.get(value, i);
                converterValue[i] = this.asJavaValue(columnDef, inputValue);
            }
            return new CdComparableArray(converterValue);
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return null;
            }
            Comparable[] converterValue = new Comparable[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object inputValue = list.get(i);
                converterValue[i] = this.asJavaValue(columnDef, inputValue);
            }
            return new CdComparableArray(converterValue);
        }
        Comparable converterValue = columnType.toJavaNativeValue(columnName, value);
        return new CdComparableArray(new Comparable[]{converterValue});
    }

    @Nullable
    private Comparable asJavaValue(IOlapBuilderDataColumnDef columnDef, @Nullable Object inputValue) {
        if (inputValue == null || inputValue instanceof String && CdStringUtils.isNullOrBlank((String)((String)inputValue))) {
            return columnDef.getNullObject();
        }
        return columnDef.getType().toJavaNativeValue(columnDef.getName(), inputValue);
    }

    @Nullable
    protected abstract Object getDataImpl(IOlapBuilderDataColumnDef var1);
}

