/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.lookuptable;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.builders.lookuptable.OlapLookupTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.cluster.node.facts.sparse.N_IntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapLookupTable {
    private final String tableName;
    private final String tableId;
    private final IOlapBuilderDataColumnDef from;
    private final List<IOlapBuilderDataColumnDef> toColumns;
    private final Map<IOlapBuilderDataColumnDef, Integer> toColumnsPos = new HashMap<IOlapBuilderDataColumnDef, Integer>();
    private final N_IntObjectHashMap<int[]> relations = new N_IntObjectHashMap();

    public OlapLookupTable(String tableName, String tableId, IOlapBuilderDataColumnDef from) {
        this.tableName = tableName;
        this.tableId = tableId;
        this.from = from;
        this.toColumns = new ArrayList<IOlapBuilderDataColumnDef>();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableId() {
        return this.tableId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTo(IOlapBuilderDataColumnDef to) {
        List<IOlapBuilderDataColumnDef> list = this.toColumns;
        synchronized (list) {
            int size = this.toColumns.size();
            if (!this.toColumnsPos.containsKey(to)) {
                this.toColumnsPos.put(to, size);
                this.toColumns.add(to);
            }
        }
    }

    public IOlapBuilderTableListener createListener() {
        return new OlapLookupTableListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(OlapBuilderContext context, IOlapBuilderTabularDataDef table, IOlapBuilderTableRow row) {
        N_IntObjectHashMap<int[]> n_IntObjectHashMap = this.relations;
        synchronized (n_IntObjectHashMap) {
            Comparable key = row.getJavaNativeDataValue(this.from);
            if (!(key instanceof Integer)) {
                if (key == null) {
                    throw new RuntimeException("[lookup-table] [" + table.getName() + "] unexpected missing key");
                }
                throw new RuntimeException("[lookup-table] [" + table.getName() + "] unexpected key type [" + key.getClass().getSimpleName() + "]");
            }
            int keyI = (Integer)key;
            if (this.relations.get(keyI) != null) {
                throw new RuntimeException("[lookup-table] [" + table.getName() + "] unexpected duplicated values for key [" + keyI + "]");
            }
            int[] values = new int[this.toColumns.size()];
            for (int vv = 0; vv < values.length; ++vv) {
                IOlapBuilderDataColumnDef toColumn = this.toColumns.get(vv);
                Comparable value = row.getJavaNativeDataValue(toColumn);
                if (!(value instanceof Integer)) {
                    if (value == null) {
                        throw new RuntimeException("[lookup-table] [" + table.getName() + "] [key:" + keyI + "] unexpected missing value for column [" + toColumn.getName() + "]");
                    }
                    throw new RuntimeException("[lookup-table] [" + table.getName() + "] [key:" + keyI + "] unexpected value type [" + value.getClass().getSimpleName() + "] for column [" + toColumn.getName() + "]");
                }
                values[vv] = (Integer)value;
            }
            this.relations.put(keyI, values);
        }
    }

    @Nullable
    public int[] getRelations(int key) {
        return (int[])this.relations.get(key);
    }

    public int getToColumnPos(IOlapBuilderDataColumnDef to) {
        Integer pos = this.toColumnsPos.get(to);
        if (pos == null) {
            throw new RuntimeException("missing position for column [" + to.getName() + "] in lookup table [" + this.tableName + "]");
        }
        return pos;
    }

    public long sizeOf() {
        long size = this.relations.sizeOf(true);
        return size;
    }
}

