/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.lookuptable;

import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTable;
import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTableRowDecorator;
import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTableRowST;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import java.util.List;

public class OlapFactsLookupTableRowDecoratorST
extends OlapFactsLookupTableRowDecorator {
    private final int dimensionCount;
    private final OlapFactsLookupTable factsLookupTable;
    private final int[][] dimensionsIndex;
    private final OlapDimension[] dimensionNames;
    private final int[] relationsPos;

    public OlapFactsLookupTableRowDecoratorST(int dimensionCount, List<OlapFactsLookupTable> factsLookupTables) {
        this.dimensionCount = dimensionCount;
        this.factsLookupTable = factsLookupTables.get(0);
        this.dimensionsIndex = new int[factsLookupTables.size()][];
        this.dimensionNames = new OlapDimension[dimensionCount];
        this.relationsPos = new int[dimensionCount];
        for (int ii = 0; ii < dimensionCount; ++ii) {
            this.relationsPos[ii] = -1;
        }
        for (OlapFactsLookupTable factsLookupTable : factsLookupTables) {
            int tableIndex = factsLookupTable.getResolvedIndex();
            List<Integer> dims = factsLookupTable.getResolvedDimensionsIndex();
            int[] dims_ = OlapFactsLookupTableRowDecoratorST.toIntArray(dims);
            this.dimensionsIndex[tableIndex] = dims_;
            List<Integer> positions = factsLookupTable.getToColPos();
            List<OlapDimension> dimensions = factsLookupTable.getResolvedDimensions();
            for (int dd = 0; dd < dims_.length; ++dd) {
                int pos;
                int dimIndex = dims_[dd];
                this.relationsPos[dimIndex] = pos = positions.get(dd).intValue();
                this.dimensionNames[dimIndex] = dimensions.get(dd);
            }
        }
    }

    @Override
    public IOlapBuilderTableRow decorateRow(IOlapBuilderTableRow row) {
        Integer lookupKey = this.getLookupKey(this.factsLookupTable, row);
        int[] relations = null;
        if (lookupKey != null) {
            relations = this.factsLookupTable.getRelations(lookupKey);
        }
        return new OlapFactsLookupTableRowST(this.dimensionNames, this.relationsPos, relations, row);
    }
}

