/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.lookuptable;

import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTable;
import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTableRowDecorator;
import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTableRowMT;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import java.util.List;

public class OlapFactsLookupTableRowDecoratorMT
extends OlapFactsLookupTableRowDecorator {
    private final int dimensionCount;
    private final List<OlapFactsLookupTable> factsLookupTables;
    private final int[][] dimensionsIndex;
    private final OlapDimension[] dimensionNames;
    private final int[] lookupTablesPos;
    private final int[] relationsPos;

    public OlapFactsLookupTableRowDecoratorMT(int dimensionCount, List<OlapFactsLookupTable> factsLookupTables) {
        this.dimensionCount = dimensionCount;
        this.factsLookupTables = factsLookupTables;
        this.dimensionsIndex = new int[factsLookupTables.size()][];
        this.dimensionNames = new OlapDimension[dimensionCount];
        this.lookupTablesPos = new int[dimensionCount];
        this.relationsPos = new int[dimensionCount];
        for (int ii = 0; ii < dimensionCount; ++ii) {
            this.lookupTablesPos[ii] = -1;
            this.relationsPos[ii] = -1;
        }
        for (OlapFactsLookupTable factsLookupTable : factsLookupTables) {
            int tableIndex = factsLookupTable.getResolvedIndex();
            List<Integer> dims = factsLookupTable.getResolvedDimensionsIndex();
            int[] dims_ = OlapFactsLookupTableRowDecoratorMT.toIntArray(dims);
            this.dimensionsIndex[tableIndex] = dims_;
            List<Integer> positions = factsLookupTable.getToColPos();
            List<OlapDimension> dimensions = factsLookupTable.getResolvedDimensions();
            for (int dd = 0; dd < dims_.length; ++dd) {
                int dimIndex = dims_[dd];
                int pos = positions.get(dd);
                this.lookupTablesPos[dimIndex] = tableIndex;
                this.relationsPos[dimIndex] = pos;
                this.dimensionNames[dimIndex] = dimensions.get(dd);
            }
        }
    }

    @Override
    public IOlapBuilderTableRow decorateRow(IOlapBuilderTableRow row) {
        int[][] relations = new int[this.factsLookupTables.size()][];
        for (OlapFactsLookupTable factsLookupTable : this.factsLookupTables) {
            Integer lookupKey = this.getLookupKey(factsLookupTable, row);
            if (lookupKey == null) continue;
            int tableIndex = factsLookupTable.getResolvedIndex();
            relations[tableIndex] = factsLookupTable.getRelations(lookupKey);
        }
        return new OlapFactsLookupTableRowMT(this.dimensionNames, this.lookupTablesPos, this.relationsPos, relations, row);
    }
}

