/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.lookuptable;

import crazydev.iccube.builder.model.builders.lookuptable.OlapLookupTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapFactsLookupTable {
    private final String measureGroupName;
    private final OlapLookupTable lookupTable;
    private final IOlapBuilderDataColumnDef factsJoinCol;
    private final List<OlapDimension> resolvedDimensions = new ArrayList<OlapDimension>();
    private final List<Integer> resolvedDimensionsIndex = new ArrayList<Integer>();
    private final List<Integer> toColPos = new ArrayList<Integer>();
    private int resolvedIndex = -1;

    public OlapFactsLookupTable(String measureGroupName, OlapLookupTable lookupTable, IOlapBuilderDataColumnDef factsJoinCol) {
        this.measureGroupName = measureGroupName;
        this.lookupTable = lookupTable;
        this.factsJoinCol = factsJoinCol;
    }

    public void addDimension(OlapDimension dimension, int dimensionIndex, IOlapBuilderDataColumnDef toCol) {
        this.resolvedDimensions.add(dimension);
        this.resolvedDimensionsIndex.add(dimensionIndex);
        this.toColPos.add(this.lookupTable.getToColumnPos(toCol));
    }

    public int getResolvedIndex() {
        if (this.resolvedIndex == -1) {
            throw new RuntimeException("unexpected missing index for table [" + this.lookupTable.getTableName() + "] in measure group [" + this.measureGroupName + "]");
        }
        return this.resolvedIndex;
    }

    public void setResolvedIndex(int index) {
        this.resolvedIndex = index;
    }

    public IOlapBuilderDataColumnDef getFactsJoinCol() {
        return this.factsJoinCol;
    }

    @Nullable
    public int[] getRelations(int key) {
        return this.lookupTable.getRelations(key);
    }

    public List<OlapDimension> getResolvedDimensions() {
        return this.resolvedDimensions;
    }

    public List<Integer> getResolvedDimensionsIndex() {
        return this.resolvedDimensionsIndex;
    }

    public List<Integer> getToColPos() {
        return this.toColPos;
    }
}

