/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.hierarchy;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.goodies.headerdef.OlapBuilderPathHierarchyKeyNameStringUnmarshaller;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderBaseParentChildHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderPathHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderPathHierarchyBuilder
extends OlapBuilderBaseParentChildHierarchyBuilder<IOlapBuilderPathHierarchyDef> {
    public OlapBuilderPathHierarchyBuilder(OlapBuilderContext context, OlapDimension olapDimension, IOlapBuilderPathHierarchyDef hierarchyDef) {
        super(context, olapDimension, hierarchyDef);
        if (!hierarchyDef.isDefault()) {
            throw new RuntimeException("internal error: non default path hierarchy [" + hierarchyDef.getName() + "] not supported");
        }
    }

    @Override
    public boolean hasColumnDefWithArray() {
        return OlapBuilderPathHierarchyBuilder.hasArray(((IOlapBuilderPathHierarchyDef)this.hierarchyDef).getPathColumn());
    }

    @Override
    public OlapMember addToHierarchy(IOlapBuilderTableRow data) {
        String line = (String)((Object)data.getJavaNativeDataValue(((IOlapBuilderPathHierarchyDef)this.hierarchyDef).getPathColumn()));
        return this.addMemberAsLine(data, line, ((IOlapBuilderPathHierarchyDef)this.hierarchyDef).getMemberSeparator(), ((IOlapBuilderPathHierarchyDef)this.hierarchyDef).getKeyNameUnmarshaller());
    }

    public OlapMember addMemberAsLine(IOlapBuilderTableRow data, String line, String memberSeparator, OlapBuilderPathHierarchyKeyNameStringUnmarshaller unmarshaller) {
        String[] members = OlapBuilderPathHierarchyBuilder.splitLine(line, memberSeparator);
        return this.addMemberAtLevel(memberSeparator, data, members, 0, null, unmarshaller);
    }

    private static String[] splitLine(String line, String memberSeparator) {
        String pattern = Pattern.quote(memberSeparator);
        String[] members = line.split(pattern);
        return members;
    }

    private OlapMember addMemberAtLevel(String memberSeparator, IOlapBuilderTableRow data, String[] members, int pos, OlapMember parentMember, OlapBuilderPathHierarchyKeyNameStringUnmarshaller unmarshaller) {
        int levelPosition;
        IOlapHierarchyPermission permissions = this.getFullControlPermissions(this.olapHierarchy);
        OlapLevel olapLevel = this.olapHierarchy.lookupLevel(permissions, levelPosition = pos + this.getLevelZero());
        if (olapLevel == null) {
            olapLevel = new OlapLevel((OlapHierarchy)this.olapHierarchy, this.getLevelNameForDepth(levelPosition), null, levelPosition, ((IOlapBuilderPathHierarchyDef)this.hierarchyDef).getOrderMembersByType(), ((IOlapBuilderPathHierarchyDef)this.hierarchyDef).getOrderKind(), true, false, false);
            this.registerLevel(this.olapHierarchy, olapLevel);
        }
        OlapMember memberParent = parentMember == null ? this.getAllMember() : parentMember;
        String memberName = unmarshaller.getName(memberSeparator, members, pos);
        OlapMember member = parentMember;
        if (!CdStringUtils.isNullOrBlank((String)memberName)) {
            Object memberKey = unmarshaller.getKey(memberSeparator, members, pos);
            memberKey = memberKey == null ? memberName : memberKey;
            OlapBuilderInputType memberKeyType = unmarshaller.getKeyType(memberSeparator, members, pos);
            OlapMemberKey key = OlapMemberKey.create(memberKeyType = memberKeyType == null ? OlapBuilderInputType.STRING : memberKeyType, (Comparable)memberKey);
            member = this.context.lookupMember(olapLevel, key);
            if (member == null || !OlapMember.equal(member.getParent(), memberParent)) {
                OlapMemberPropertiesValues propertiesValues = this.addPropertiesValues(this.hierarchyDef, olapLevel, data);
                member = OlapMemberFactory.createRegularMember(this.context, olapLevel, memberParent, memberName, key, propertiesValues);
                this.registerMember(olapLevel, member);
            } else {
                this.assertMemberProperties(data, member);
            }
        }
        if (pos + 1 < members.length) {
            return this.addMemberAtLevel(memberSeparator, data, members, pos + 1, member, unmarshaller);
        }
        return member;
    }

    public int getLevelZero() {
        return ((IOlapBuilderPathHierarchyDef)this.hierarchyDef).hasAll() ? 1 : 0;
    }

    @Nullable
    public OlapMember getAllMember() {
        return this.olapHierarchy.getAllMember();
    }
}

