/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.hierarchy;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRow;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderBaseParentChildHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapParentChildHierarchyDef;
import crazydev.iccube.builder.model.impl.view.parentchildsort.sort.OlapBuilderParentChildSortDataViewLogic;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderParentChildHierarchyBuilder
extends OlapBuilderBaseParentChildHierarchyBuilder<IOlapParentChildHierarchyDef> {
    protected final OlapNameContext nameContext;
    private final boolean idIsKey;
    private final boolean addAllRoot;
    private ParentChildSorter parentChildSolver;

    public OlapBuilderParentChildHierarchyBuilder(OlapBuilderContext context, OlapDimension olapDimension, IOlapParentChildHierarchyDef hierarchyDef) {
        super(context, olapDimension, hierarchyDef);
        this.nameContext = context.getNameContext();
        this.addAllRoot = CdStringUtils.isNotNullAndNotBlank((String)hierarchyDef.addAllMemberName());
        this.idIsKey = hierarchyDef.getId().equals(hierarchyDef.getMemberKey());
    }

    @Override
    public IOlapBuilderDimensionListener.ILineSorter getLineSorter() {
        return this.parentChildSolver;
    }

    @Override
    public void init(IOlapBuilderHierarchyDef defaultHierarchy) {
        this.parentChildSolver = new ParentChildSorter(this);
        super.init(defaultHierarchy);
    }

    @Override
    public boolean hasColumnDefWithArray() {
        if (OlapBuilderParentChildHierarchyBuilder.hasArray(((IOlapParentChildHierarchyDef)this.hierarchyDef).getMemberKey()) || OlapBuilderParentChildHierarchyBuilder.hasArray(((IOlapParentChildHierarchyDef)this.hierarchyDef).getMemberKey()) || OlapBuilderParentChildHierarchyBuilder.hasArray(((IOlapParentChildHierarchyDef)this.hierarchyDef).getId()) || OlapBuilderParentChildHierarchyBuilder.hasArray(((IOlapParentChildHierarchyDef)this.hierarchyDef).getParentId())) {
            return true;
        }
        if (((IOlapParentChildHierarchyDef)this.hierarchyDef).getOrderMembersByType() == OlapMemberOrderByType.BY_COLUMN && OlapBuilderParentChildHierarchyBuilder.hasArray(((IOlapParentChildHierarchyDef)this.hierarchyDef).getOrderMembersColumn())) {
            return true;
        }
        for (IOlapBuilderPropertyDef propertyDef : ((IOlapParentChildHierarchyDef)this.hierarchyDef).getProperties()) {
            if (!OlapBuilderParentChildHierarchyBuilder.hasArray(propertyDef.getPropertyColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected String getAllMemberName(IOlapParentChildHierarchyDef hierarchyDef) {
        return this.addAllRoot ? hierarchyDef.addAllMemberName() : null;
    }

    @Override
    @Nullable
    protected String getAllLevelName(IOlapParentChildHierarchyDef hierarchyDef) {
        return this.addAllRoot ? this.getLevelNameForDepth(0) : null;
    }

    @Override
    protected boolean getHasAllLevel(IOlapParentChildHierarchyDef hierarchyDef) {
        return this.addAllRoot;
    }

    @Override
    public OlapMember addToHierarchy(IOlapBuilderTableRow data) {
        OlapMember member;
        OlapMember existingMember;
        OlapMember parentMember;
        OlapLevel olapLevel;
        OlapBuilderInputType memberType = ((IOlapParentChildHierarchyDef)this.hierarchyDef).getMemberKey().getType();
        Comparable memberKey = data.getJavaNativeDataValue(((IOlapParentChildHierarchyDef)this.hierarchyDef).getMemberKey());
        Comparable id = this.idIsKey ? memberKey : data.getJavaNativeDataValue(((IOlapParentChildHierarchyDef)this.hierarchyDef).getId());
        Comparable parentId = data.getJavaNativeDataValue(((IOlapParentChildHierarchyDef)this.hierarchyDef).getParentId());
        String memberName = OlapBuilderParentChildHierarchyBuilder.toMemberName(data.getJavaNativeDataValue(((IOlapParentChildHierarchyDef)this.hierarchyDef).getMemberName()));
        if (id != null && id.equals(parentId)) {
            parentId = null;
        }
        if (CdStringUtils.isNullOrBlank((String)memberName)) {
            String memberKeyAsString = memberKey == null ? null : memberKey.toString();
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_WITHOUT_NAME_PARENT_CHILD, new Serializable[]{memberKeyAsString, ((IOlapParentChildHierarchyDef)this.hierarchyDef).getMemberName().getName(), this.olapHierarchy.getUniqueName(this.nameContext)});
        }
        if (memberKey == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_WITHOUT_KEY, new Serializable[]{memberName, ((IOlapParentChildHierarchyDef)this.hierarchyDef).getMemberKey().getName(), "Parent/Child"});
        }
        if (parentId == null) {
            olapLevel = this.getOrCreateLevel(this.addAllRoot ? 1 : 0);
            parentMember = this.addAllRoot ? this.olapHierarchy.getAllMember() : null;
        } else {
            parentMember = this.parentChildSolver.computeIfAbsent(parentId);
            if (parentMember == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.PARENT_CHILD_SORTED, new Serializable[]{((IOlapParentChildHierarchyDef)this.hierarchyDef).getName(), String.valueOf(id), String.valueOf(parentId)});
            }
            OlapLevel parentLevel = parentMember.getLevel();
            OlapLevel olapLevel2 = olapLevel = parentLevel.getNextLevel() == null ? this.getOrCreateLevel(parentLevel.getDepth() + 1) : parentLevel.getNextLevel();
        }
        if (olapLevel != null && (existingMember = olapLevel.lookupMemberByKeyValue(memberKey)) != null && memberName.equals(existingMember.getName(this.nameContext))) {
            this.assertMemberProperties(data, existingMember);
            return existingMember;
        }
        if (olapLevel != null && olapLevel.isAll()) {
            if (olapLevel.getMemberCount() != 0) {
                String allName = this.olapHierarchy.getAllMember().getName(this.nameContext);
                String name = this.olapHierarchy.getUniqueName(this.nameContext);
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.PARENT_CHILD_ROOT_UNIQUE, new Serializable[]{name, String.valueOf(id), memberName, allName});
            }
            OlapMemberPropertiesValues propertiesValues = this.addPropertiesValues(this.hierarchyDef, olapLevel, data);
            member = OlapMemberFactory.createOlapAllMember(this.context, olapLevel, memberName, OlapMemberKey.create(memberType, memberKey), propertiesValues);
        } else {
            OlapMemberPropertiesValues propertiesValues = this.addPropertiesValues(this.hierarchyDef, olapLevel, data);
            member = OlapMemberFactory.createRegularMember(this.context, olapLevel, parentMember, memberName, OlapMemberKey.create(memberType, memberKey), propertiesValues);
        }
        this.registerMember(olapLevel, member);
        if (!this.idIsKey) {
            this.parentChildSolver.cache.put(id, member);
        }
        return member;
    }

    private OlapLevel getOrCreateLevel(int levelDepth) {
        OlapLevel olapLevel = this.olapHierarchy.getLevelForDistance(levelDepth);
        if (olapLevel == null) {
            for (int i = this.olapHierarchy.getLevels().size(); i < levelDepth + 1; ++i) {
                String levelName = this.getLevelNameForDepth(levelDepth);
                if (i == 0 && !this.addAllRoot && ((IOlapParentChildHierarchyDef)this.hierarchyDef).isFirstLevelAll()) {
                    olapLevel = new OlapLevel((OlapHierarchy)this.olapHierarchy, levelName, null, 0, null, true, true, true, true);
                } else {
                    OlapBuilderContextMode buildingMode = this.context.getMode();
                    olapLevel = new OlapLevel(buildingMode, this.olapHierarchy, levelName, null, i, ((IOlapParentChildHierarchyDef)this.hierarchyDef).getOrderMembersByType(), ((IOlapParentChildHierarchyDef)this.hierarchyDef).getOrderKind(), true, false, false);
                }
                this.registerLevel(this.olapHierarchy, olapLevel);
            }
        }
        if (olapLevel == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        return olapLevel;
    }

    private class ParentChildSorter
    implements IOlapBuilderDimensionListener.ILineSorter {
        final Map<Comparable, OlapMember> cache;
        final /* synthetic */ OlapBuilderParentChildHierarchyBuilder this$0;

        ParentChildSorter(OlapBuilderParentChildHierarchyBuilder olapBuilderParentChildHierarchyBuilder) {
            OlapBuilderParentChildHierarchyBuilder olapBuilderParentChildHierarchyBuilder2 = olapBuilderParentChildHierarchyBuilder;
            Objects.requireNonNull(olapBuilderParentChildHierarchyBuilder2);
            this.this$0 = olapBuilderParentChildHierarchyBuilder2;
            this.cache = new HashMap<Comparable, OlapMember>();
        }

        @Override
        public boolean mightLoadLine(IOlapBuilderTableRow data) {
            Comparable parentId = data.getJavaNativeDataValue(((IOlapParentChildHierarchyDef)this.this$0.hierarchyDef).getParentId());
            if (parentId == null || this.cache.containsKey(parentId)) {
                return true;
            }
            Comparable id = data.getJavaNativeDataValue(((IOlapParentChildHierarchyDef)this.this$0.hierarchyDef).getId());
            if (parentId.equals(id)) {
                return true;
            }
            OlapMember parent = this.computeIfAbsent(parentId);
            return parent != null;
        }

        @Override
        public void onEndProcessing(List<OlapBuilderBufferDataTableRow> bufferTableRows, Consumer<IOlapBuilderTableRow> visit) {
            if (bufferTableRows.isEmpty()) {
                return;
            }
            OlapBuilderParentChildSortDataViewLogic sorter = new OlapBuilderParentChildSortDataViewLogic(this.this$0.olapHierarchy.getName(this.this$0.nameContext), ((IOlapParentChildHierarchyDef)this.this$0.hierarchyDef).getId(), ((IOlapParentChildHierarchyDef)this.this$0.hierarchyDef).getParentId(), null, true);
            List<OlapBuilderBufferDataTableRow> sorted = sorter.sortAsParenChild(bufferTableRows, id -> this.computeIfAbsent((Comparable)id) != null);
            sorted.forEach(visit);
            this.cache.clear();
        }

        @Override
        public boolean checkIsCompatible(IOlapBuilderDimensionListener.ILineSorter lineSolver) {
            if (lineSolver == null) {
                return true;
            }
            if (lineSolver instanceof ParentChildSorter) {
                ParentChildSorter solver = (ParentChildSorter)lineSolver;
                return solver.isNotCompatible(this.this$0.idIsKey, ((IOlapParentChildHierarchyDef)this.this$0.hierarchyDef).getId(), ((IOlapParentChildHierarchyDef)this.this$0.hierarchyDef).getParentId());
            }
            return false;
        }

        private boolean isNotCompatible(boolean idIsKey, IOlapBuilderDataColumnDef id, IOlapBuilderDataColumnDef parentId) {
            return this.this$0.idIsKey == idIsKey && ((IOlapParentChildHierarchyDef)this.this$0.hierarchyDef).getId() == id && ((IOlapParentChildHierarchyDef)this.this$0.hierarchyDef).getParentId() == parentId;
        }

        OlapMember computeIfAbsent(Comparable parentId) {
            return this.this$0.idIsKey ? this.cache.computeIfAbsent(parentId, id -> this.this$0.olapHierarchy.lookupMemberByKey((Comparable)id)) : this.cache.get(parentId);
        }
    }
}

