/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.hierarchy;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderBaseMultilevelHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderNoDefaultMultiLevelHierarchyBuilder
extends OlapBuilderBaseMultilevelHierarchyBuilder<IOlapBuilderHierarchyDef> {
    private final List<IOlapBuilderHierarchyLevelDef> levelsInDefaultHierarchy = new ArrayList<IOlapBuilderHierarchyLevelDef>();
    private boolean addOnlyLeavesOfDefaultHierarchy;

    public OlapBuilderNoDefaultMultiLevelHierarchyBuilder(OlapBuilderContext context, OlapDimension olapDimension, OlapBuilderMultiLevelHierarchy hierarchyDef) {
        super(context, olapDimension, hierarchyDef);
        if (hierarchyDef.isDefault()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    @Override
    public void init(IOlapBuilderHierarchyDef defaultHierarchy) {
        super.init(defaultHierarchy);
        this.findCloneLevels(defaultHierarchy);
        this.levelsInDefaultHierarchy.clear();
        this.addOnlyLeavesOfDefaultHierarchy = false;
        List<IOlapBuilderHierarchyLevelDef> defaultLevels = defaultHierarchy.getLevels();
        List<IOlapBuilderHierarchyLevelDef> levels = this.hierarchyDef.getLevels();
        for (IOlapBuilderHierarchyLevelDef levelDef : levels) {
            if (defaultLevels.contains(levelDef)) {
                this.levelsInDefaultHierarchy.add(levelDef);
                continue;
            }
            boolean found = this.handleLevelAsPropertyInDefaultHierarchy(defaultHierarchy, levelDef);
            if (found) continue;
            this.addOnlyLeavesOfDefaultHierarchy = true;
            this.levelsInDefaultHierarchy.clear();
            break;
        }
    }

    private void findCloneLevels(IOlapBuilderHierarchyDef defaultHierarchy) {
        if (defaultHierarchy instanceof OlapBuilderMultiLevelHierarchy) {
            int start = this.hierarchyDef.aggrFactOnAncestor() ? 0 : this.hierarchyDef.getLevels().size() - 1;
            int startDefault = defaultHierarchy.aggrFactOnAncestor() ? 0 : defaultHierarchy.getLevels().size() - 1;
            for (int i = start; i < this.hierarchyDef.getLevels().size(); ++i) {
                IOlapBuilderHierarchyLevelDef levelDef = this.hierarchyDef.getLevels().get(i);
                int size = defaultHierarchy.getLevels().size();
                for (int j = startDefault; j < size; ++j) {
                    IOlapBuilderHierarchyLevelDef baseLevelDef = defaultHierarchy.getLevels().get(j);
                    if (!this.isCloneLevel(baseLevelDef, levelDef, j == size - 1)) continue;
                    this.markLevelAsClone(levelDef, baseLevelDef);
                }
            }
            this.olapHierarchy.checkAndSetHollow();
        }
    }

    private void markLevelAsClone(IOlapBuilderHierarchyLevelDef levelDef, IOlapBuilderHierarchyLevelDef baseLevelDef) {
        OlapLevel level = this.lookupLevel(this.olapHierarchy, levelDef);
        OlapLevel baseLevel = this.lookupLevel(this.olapDimension.getBaseHierarchy(), baseLevelDef);
        level.setHollowLevel(baseLevel);
    }

    private OlapLevel lookupLevel(OlapHierarchy olapHierarchy, IOlapBuilderHierarchyLevelDef levelDef) {
        for (int i = 0; i < olapHierarchy.getLevels().size(); ++i) {
            OlapLevel olapLevel = olapHierarchy.getLevels().get(i);
            if (!olapLevel.getName(this.nameContext).equals(levelDef.getName())) continue;
            return olapLevel;
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    private boolean isCloneLevel(IOlapBuilderHierarchyLevelDef baseLevelDef, IOlapBuilderHierarchyLevelDef levelDef, boolean lastLevel) {
        if (!lastLevel && !baseLevelDef.isKeyUniqueInLevel()) {
            return false;
        }
        boolean sameName = baseLevelDef.getNameColumn() == levelDef.getNameColumn();
        boolean sameKey = this.same(baseLevelDef.getKeyColumns(), levelDef.getKeyColumns());
        if (sameName && sameKey) {
            return true;
        }
        if (sameKey && baseLevelDef.isKeyUniqueInLevel() && levelDef.isKeyUniqueInLevel()) {
            return true;
        }
        return sameName && baseLevelDef.isNameUniqueInLevel() && levelDef.isNameUniqueInLevel() && !baseLevelDef.ignoreNameCollision() && !levelDef.ignoreNameCollision();
    }

    private boolean same(List<IOlapBuilderDataColumnDef> keyColumns, List<IOlapBuilderDataColumnDef> keyColumns2) {
        if (keyColumns.size() == keyColumns2.size()) {
            for (int i = 0; i < keyColumns.size(); ++i) {
                IOlapBuilderDataColumnDef columnDef2;
                IOlapBuilderDataColumnDef columnDef1 = keyColumns.get(i);
                if (columnDef1 == (columnDef2 = keyColumns2.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean handleLevelAsPropertyInDefaultHierarchy(IOlapBuilderHierarchyDef defaultHierarchy, IOlapBuilderHierarchyLevelDef levelDef) {
        boolean found = false;
        List<IOlapBuilderHierarchyLevelDef> defaultLevels = defaultHierarchy.getLevels();
        block0: for (IOlapBuilderHierarchyLevelDef defaultHierarchyLevel : defaultLevels) {
            List<IOlapBuilderPropertyDef> properties = defaultHierarchy.getPropertiesForBuilder(defaultHierarchyLevel.getName());
            for (IOlapBuilderPropertyDef propertyDef : properties) {
                if (propertyDef.isAttribute() || !this.isLinked(levelDef, propertyDef.getPropertyColumn())) continue;
                this.levelsInDefaultHierarchy.add(defaultHierarchyLevel);
                found = true;
                continue block0;
            }
        }
        return found;
    }

    private boolean isLinked(IOlapBuilderHierarchyLevelDef levelDef, IOlapBuilderDataColumnDef propColDef) {
        List<IOlapBuilderDataColumnDef> columnKeyDefs = levelDef.getKeyColumns();
        for (int idx = 0; idx < columnKeyDefs.size(); ++idx) {
            if (!propColDef.equals(columnKeyDefs.get(idx))) continue;
            return true;
        }
        return propColDef.equals(levelDef.getNameColumn());
    }

    @Override
    public void addNoBaseBaseLink(OlapMember noBaseMember, OlapMember baseMember) {
        OlapMember internalChild;
        OlapMember olapMember = internalChild = this.addOnlyLeavesOfDefaultHierarchy || baseMember == null ? baseMember : this.getLeafMember(baseMember);
        if (internalChild != null && noBaseMember != null) {
            this.context.addNoBaseBaseLink(noBaseMember, internalChild);
        }
    }

    @Nullable
    private OlapMember getLeafMember(OlapMember leafOfDefaultHierarchy) {
        OlapMember local;
        OlapMember returnMember = local = leafOfDefaultHierarchy;
        boolean ragged = false;
        while (local != null) {
            String localLevelName = local.getLevel().getName(this.nameContext);
            for (IOlapBuilderHierarchyLevelDef level : this.levelsInDefaultHierarchy) {
                if (!OlapCaseInsensitiveName.equals(level.getName(), localLevelName)) continue;
                return returnMember;
            }
            ragged = ragged || this.isMemberRagged(this.levelsInDefaultHierarchy, local);
            local = local.getParent();
            returnMember = ragged ? returnMember : local;
        }
        return null;
    }

    private boolean isMemberRagged(List<IOlapBuilderHierarchyLevelDef> levels, OlapMember local) {
        int parentDepth;
        OlapMember parent = local.getParent();
        if (parent == null) {
            return false;
        }
        int localDepth = local.getLevel().getDepth();
        if (localDepth == (parentDepth = parent.getLevel().getDepth()) + 1) {
            return false;
        }
        for (int i = parentDepth + 1; i < localDepth; ++i) {
            OlapLevel olapLevel = local.getHierarchy().getLevels().get(i);
            for (IOlapBuilderHierarchyLevelDef level : levels) {
                if (!OlapCaseInsensitiveName.equals(level.getName(), olapLevel.getName(this.nameContext))) continue;
                return true;
            }
        }
        return false;
    }
}

