/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.hierarchy;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderFlatHierarchy;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapMultiLevelHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.memory.OlapKeyOnlyMemoryLevelMember;

public class OlapBuilderFlatHierarchyBuilder
extends OlapBuilderHierarchyBuilder<OlapBuilderFlatHierarchy> {
    private final String defaultMemberName;
    private OlapLevel dataLevel;

    public OlapBuilderFlatHierarchyBuilder(OlapBuilderContext context, OlapDimension olapDimension, String defaultMemberName, OlapBuilderFlatHierarchy hierarchyDef) {
        super(context, olapDimension, hierarchyDef);
        this.defaultMemberName = defaultMemberName;
    }

    @Override
    public boolean hasColumnDefWithArray() {
        return false;
    }

    @Override
    public void init(IOlapBuilderHierarchyDef defaultHierarchy) {
        super.init(defaultHierarchy);
        IOlapBuilderHierarchyLevelDef level = (IOlapBuilderHierarchyLevelDef)CdCollections.last(((OlapBuilderFlatHierarchy)this.hierarchyDef).getLevels());
        this.dataLevel = this.context.getLevelByName(this.olapHierarchy, level.getName());
    }

    @Override
    protected OlapMultiLevelHierarchy createHierarchy(boolean hasAllLevel, String allLevelName) {
        OlapMultiLevelHierarchy hierarchy = super.createHierarchy(hasAllLevel, allLevelName);
        hierarchy.setAcceptsCategoryMembers();
        return hierarchy;
    }

    @Override
    public OlapMember addToHierarchy(IOlapBuilderTableRow data) {
        OlapMember allMember = this.olapHierarchy.getAllMember();
        IOlapBuilderHierarchyLevelDef levelDef = ((OlapBuilderFlatHierarchy)this.hierarchyDef).getLevels().get(0);
        IOlapBuilderDataColumnDef levelColumnName = levelDef.getNameColumn();
        Comparable memberValue = data.getJavaNativeDataValue(levelColumnName);
        OlapKeyOnlyMemoryLevelMember dataHandler = (OlapKeyOnlyMemoryLevelMember)this.dataLevel.getDataHandler();
        OlapMember member = dataHandler.lookupMemberByKeyValue((Object)memberValue);
        if (member == null) {
            OlapMemberKey key = OlapMemberKey.create(((OlapBuilderFlatHierarchy)this.hierarchyDef).getNameColumnDef().getType(), memberValue);
            member = OlapMemberFactory.createOlapTerminalMember(this.context, this.dataLevel, allMember, null, key, null);
            this.registerMember(this.dataLevel, member);
        }
        return member;
    }
}

