/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.hierarchy;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseParentChildHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseHierarchy;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.level.OlapLevel;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseParentChildHierarchyBuilder<T extends IOlapBuilderBaseParentChildHierarchyDef>
extends OlapBuilderHierarchyBuilder<T> {
    private static final String LEVEL_NUMBER_TAG = "$L";
    private static final String LEVEL_NAME_SEPARATOR = ",";
    private String[] levelNames;

    public OlapBuilderBaseParentChildHierarchyBuilder(OlapBuilderContext context, OlapDimension olapDimension, T hierarchyDef) {
        super(context, olapDimension, hierarchyDef);
    }

    @Override
    public void init(IOlapBuilderHierarchyDef defaultHierarchy) {
        String levelName = ((IOlapBuilderBaseParentChildHierarchyDef)this.hierarchyDef).getLevelNamePattern();
        this.levelNames = OlapBuilderBaseParentChildHierarchyBuilder.buildLevelNames(levelName);
        super.init(defaultHierarchy);
    }

    protected String getLevelNameForDepth(int levelPosition) {
        String levelName = OlapBuilderBaseParentChildHierarchyBuilder.getLevelName(this.levelNames, ((IOlapBuilderBaseParentChildHierarchyDef)this.hierarchyDef).getLevelNamePattern(), levelPosition);
        if (this.olapHierarchy != null) {
            for (OlapLevel olapLevel : this.olapHierarchy.getLevels()) {
                if (!olapLevel.getName(this.nameContext).equals(levelName)) continue;
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.LEVEL_PATTERN_DUPLICATED_LEVEL, new Serializable[]{((IOlapBuilderBaseParentChildHierarchyDef)this.hierarchyDef).getLevelNamePattern(), levelName, this.olapHierarchy.getName(this.nameContext)});
            }
        }
        return levelName;
    }

    @Nullable
    public static String[] buildLevelNames(String levelName) {
        if (CdStringUtils.isNullOrBlank((String)levelName) || levelName == null || !levelName.contains(LEVEL_NAME_SEPARATOR)) {
            return null;
        }
        return levelName.split(LEVEL_NAME_SEPARATOR);
    }

    public static String getLevelName(String[] levelNames, String levelNamePattern, int levelPosition) {
        String actualName;
        boolean addPosition2Name = true;
        if (levelNames != null) {
            actualName = levelNames[Math.min(levelPosition, levelNames.length - 1)];
            addPosition2Name = levelPosition >= levelNames.length;
        } else {
            actualName = levelNamePattern;
        }
        if (CdStringUtils.isNullOrBlank((String)actualName)) {
            return OlapBuilderBaseHierarchy.VERY_DEFAULT_LEVEL_PATTERN_NAME + levelPosition;
        }
        if (actualName.contains(LEVEL_NUMBER_TAG)) {
            return actualName.replace(LEVEL_NUMBER_TAG, Integer.toString(levelPosition));
        }
        return actualName + String.valueOf(addPosition2Name ? Integer.valueOf(levelPosition) : "");
    }
}

