/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.hierarchy;

import crazydev.common.cache.CdLRUCacheHelper;
import crazydev.common.cache.CdLRUCacheI;
import crazydev.common.collection.CdComparableArray;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseMultilevelHierarchyBuilder<T extends IOlapBuilderHierarchyDef>
extends OlapBuilderHierarchyBuilder<T> {
    public static final int MAX_SIZE = 256;
    private final boolean isAttributeHierarchy;
    List<LevelCache> cache = new ArrayList<LevelCache>();
    private List<OlapLevel> matchingLevels;

    public OlapBuilderBaseMultilevelHierarchyBuilder(OlapBuilderContext context, OlapDimension olapDimension, T hierarchyDef) {
        super(context, olapDimension, hierarchyDef);
        this.isAttributeHierarchy = hierarchyDef.isAttributeHierarchy();
    }

    @Override
    public boolean hasColumnDefWithArray() {
        for (IOlapBuilderHierarchyLevelDef levelDef : this.hierarchyDef.getLevels()) {
            boolean hasArray = OlapBuilderBaseMultilevelHierarchyBuilder.hasArray(levelDef.getKeyColumns()) || OlapBuilderBaseMultilevelHierarchyBuilder.hasArray(levelDef.getNameColumn());
            for (IOlapBuilderPropertyDef propertyDef : levelDef.getProperties()) {
                hasArray |= OlapBuilderBaseMultilevelHierarchyBuilder.hasArray(propertyDef.getPropertyColumn());
            }
            if (!hasArray) continue;
            return true;
        }
        return false;
    }

    @Override
    public void init(IOlapBuilderHierarchyDef defaultHierarchy) {
        super.init(defaultHierarchy);
        this.cache = new ArrayList<LevelCache>();
        List<IOlapBuilderHierarchyLevelDef> levels = this.hierarchyDef.getLevels();
        this.olapHierarchy.getLevels().forEach(olapLevel -> this.cache.add(new LRUCacheSimple()));
        this.matchingLevels = levels.stream().map(levelDef -> this.context.getLevelByName(this.olapHierarchy, levelDef.getName())).collect(Collectors.toList());
    }

    @Override
    public void onProcessingDataCompleted(OlapBuilderContext context) {
        super.onProcessingDataCompleted(context);
        this.cache.clear();
    }

    @Override
    @Nullable
    public OlapMember addToHierarchy(IOlapBuilderTableRow data) {
        OlapMember allMember;
        OlapMember parentMember = allMember = this.olapHierarchy.getAllMember();
        List<IOlapBuilderHierarchyLevelDef> levels = this.hierarchyDef.getLevels();
        int size = levels.size();
        for (int ii = 0; ii < size; ++ii) {
            boolean nameIsNull;
            IOlapBuilderHierarchyLevelDef levelDef = levels.get(ii);
            LevelCache levelCache = this.cache.get(ii);
            IOlapBuilderDataColumnDef levelColumnName = levelDef.getNameColumn();
            Comparable javaNativeDataValue = data.getJavaNativeDataValue(levelColumnName);
            String memberName = OlapBuilderBaseMultilevelHierarchyBuilder.toMemberName(javaNativeDataValue);
            Comparable memberKeyValue = OlapBuilderBaseMultilevelHierarchyBuilder.getMemberKeyValues(data, levelDef, memberName);
            boolean acceptSpaceAsMemberName = this.context.getSchema().getDefinitionFactory().isAcceptSpaceAsMemberName();
            boolean bl = nameIsNull = acceptSpaceAsMemberName ? CdStringUtils.isStrictlyEmptyOrNull((String)memberName) : CdStringUtils.isNullOrBlank((String)memberName);
            if (nameIsNull) {
                if (memberKeyValue == null) {
                    if (parentMember != null) continue;
                    break;
                }
                boolean validIfAcceptSpace = !CdStringUtils.isStrictlyEmptyOrNull((String)memberName);
                return this.throwOnNameEmpty(levelDef, levelColumnName, memberKeyValue, validIfAcceptSpace);
            }
            if (memberKeyValue == null) {
                return this.throwOnMemberKeyNull(levelDef, memberName);
            }
            CacheKey levalCacheKey = levelCache.build(parentMember, memberKeyValue, memberName);
            OlapMember member = levelCache.get(levalCacheKey);
            if (member != null) {
                this.assertMemberProperties(data, member);
                parentMember = member;
                continue;
            }
            OlapLevel memberLevel = this.matchingLevels.get(ii);
            IOlapMemoryLevelMember dataHandler = memberLevel.getDataHandler();
            member = dataHandler.lookupMemberAndCheck(parentMember, memberKeyValue, memberName, this.checkLevelKeyUnique(memberLevel, levelDef), levelDef.isNameUniqueInLevel(), levelDef.isNameUniqueInParent(), levelDef.ignoreNameCollision());
            if (member == null) {
                OlapMemberKey memberKey = this.asMemberKey(levelDef, memberKeyValue);
                OlapMemberPropertiesValues propertiesValues = this.addPropertiesValues(this.hierarchyDef, memberLevel, data);
                member = OlapMemberFactory.createMember(this.context, this.hierarchyDef.isDefault(), memberLevel, parentMember, memberName, memberKey, propertiesValues);
                this.registerMember(memberLevel, member);
            } else {
                this.assertMemberProperties(data, member);
            }
            levelCache.add(levalCacheKey, member);
            parentMember = member;
        }
        return OlapMember.equal(parentMember, allMember) ? null : parentMember;
    }

    @Nullable
    public OlapMember throwOnNameEmpty(IOlapBuilderHierarchyLevelDef levelDef, IOlapBuilderDataColumnDef levelColumnName, Object memberKeyValue, boolean validIfAcceptSpaceMemberIsOn) {
        String uniqueLevelName = this.olapHierarchy.getUniqueName(this.nameContext) + ".[" + levelDef.getName() + "]";
        String nameColumn = levelColumnName == null ? "null" : levelColumnName.getName();
        String memberKeyAsString = this.asMemberKey(levelDef, memberKeyValue).toString();
        if (validIfAcceptSpaceMemberIsOn) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_WITH_SPACE_NAME, new Serializable[]{memberKeyAsString, nameColumn, uniqueLevelName});
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_WITHOUT_NAME, new Serializable[]{memberKeyAsString, nameColumn, uniqueLevelName});
    }

    @Nullable
    public OlapMember throwOnMemberKeyNull(IOlapBuilderHierarchyLevelDef levelDef, String memberName) {
        String uniqueLevelName = this.olapHierarchy.getUniqueName(this.nameContext) + ".[" + levelDef.getName() + "]";
        String keyColumns = this.getMemberKeyColumnNames(levelDef);
        String memberNameAsString = memberName == null ? "null" : memberName;
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_WITHOUT_KEY, new Serializable[]{memberNameAsString, keyColumns, uniqueLevelName});
    }

    private boolean checkLevelKeyUnique(OlapLevel olapLevel, IOlapBuilderHierarchyLevelDef levelDef) {
        return olapLevel.isKeysUnique();
    }

    @Nullable
    private static Comparable getMemberKeyValues(IOlapBuilderTableRow data, IOlapBuilderHierarchyLevelDef level, String memberName) {
        List<IOlapBuilderDataColumnDef> columnKeys = level.getKeyColumns();
        if (columnKeys.size() == 1) {
            return data.getJavaNativeDataValue(columnKeys.get(0));
        }
        boolean allNull = true;
        boolean oneNull = false;
        Object[] columnKeyValues = new Comparable[columnKeys.size()];
        for (int idx = 0; idx < columnKeys.size(); ++idx) {
            Comparable value = data.getJavaNativeDataValue(columnKeys.get(idx));
            allNull &= value == null;
            oneNull |= value == null;
            columnKeyValues[idx] = value;
        }
        if (oneNull && !allNull) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MULTIPLE_KEY_WITH_NULL_NOT_SUPPORTED, new Serializable[]{memberName, level.getName(), Arrays.toString(columnKeyValues)});
        }
        return allNull ? null : new CdComparableArray((Comparable[])columnKeyValues);
    }

    private OlapMemberKey asMemberKey(IOlapBuilderHierarchyLevelDef level, Object keyValues) {
        OlapMemberKey memberKey;
        List<IOlapBuilderDataColumnDef> columnKeys = level.getKeyColumns();
        if (columnKeys.size() == 1) {
            memberKey = OlapMemberKey.create(columnKeys.getFirst().getType(), (Comparable)keyValues);
        } else {
            OlapBuilderInputType[] columnKeyTypes = new OlapBuilderInputType[columnKeys.size()];
            for (int idx = 0; idx < columnKeys.size(); ++idx) {
                columnKeyTypes[idx] = columnKeys.get(idx).getType();
            }
            memberKey = OlapMemberKey.create(columnKeyTypes, ((CdComparableArray)keyValues).getArray());
        }
        return memberKey;
    }

    private String getMemberKeyColumnNames(IOlapBuilderHierarchyLevelDef level) {
        StringBuilder sb = new StringBuilder();
        List<IOlapBuilderDataColumnDef> columns = level.getKeyColumns();
        for (int idx = 0; idx < columns.size(); ++idx) {
            IOlapBuilderDataColumnDef column = columns.get(idx);
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(column.getName());
        }
        return sb.toString();
    }

    @Override
    protected boolean isLevelStructureFixed() {
        return true;
    }

    private static interface LevelCache {
        public CacheKey build(@Nullable OlapMember var1, Object var2, String var3);

        public OlapMember get(CacheKey var1);

        public void add(CacheKey var1, OlapMember var2);
    }

    private static interface CacheKey {
    }

    private static class LRUCacheSimple
    implements LevelCache {
        final CdLRUCacheI<CacheKey, OlapMember> cache = CdLRUCacheHelper.create((int)256);
        int called;
        int miss;

        @Override
        public CacheKey build(OlapMember parentMember, Object key, String name) {
            return new Key(parentMember, key, name);
        }

        @Override
        public OlapMember get(CacheKey key) {
            OlapMember olapMember = (OlapMember)this.cache.get((Object)key);
            ++this.called;
            this.miss += olapMember == null ? 1 : 0;
            return olapMember;
        }

        @Override
        public void add(CacheKey key, OlapMember member) {
            this.cache.put((Object)key, (Object)member);
        }

        private static class Key
        implements CacheKey {
            final Object key;
            final String name;
            @Nullable
            private final OlapMember parent;

            public Key(OlapMember parent, Object key, String name) {
                this.parent = parent;
                this.key = key;
                this.name = name;
            }

            public int hashCode() {
                return Objects.hash(this.name, this.key, this.parent);
            }

            public boolean equals(Object obj) {
                Key myKey = (Key)obj;
                return this.key.equals(myKey.key) && this.name.equals(myKey.name) && OlapMember.equal(this.parent, myKey.parent);
            }
        }
    }
}

