/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts.tasks;

import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageTaskI;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import java.util.Deque;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class N_FactPageTaskQueue {
    private final int hierarchyIdx;
    private final Deque<N_FactPageTaskI> queue = new LinkedList<N_FactPageTaskI>();
    private final int maxSize;

    public N_FactPageTaskQueue(OlapEngineComponentConfiguration configuration, int hierarchyIdx) {
        this.hierarchyIdx = hierarchyIdx;
        int threadCount = configuration.getProperties().getLoadProcessingThreadCount();
        this.maxSize = Math.max(2, threadCount);
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isFull() {
        return this.size() >= this.maxSize;
    }

    public void offerLast(N_FactPageTaskI task) {
        if (task.getHierarchyIdx() != this.hierarchyIdx) {
            throw new RuntimeException("internal error: unexpected task hierarchy [queue:" + this.hierarchyIdx + "] [task:" + task.getHierarchyIdx() + "]");
        }
        this.queue.offerLast(task);
    }

    @Nullable
    public N_FactPageTaskI pollFirst() {
        return this.queue.pollFirst();
    }

    public String toString() {
        return this.hierarchyIdx + "(" + this.queue.size() + ")";
    }
}

