/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts.tasks;

import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchHierarchiesInfo;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchHierarchyInfo;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageTaskI;
import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsContainer;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class N_FactPageTask
implements N_FactPageTaskI {
    protected final N_FactPage page;
    protected final boolean index;
    protected final int hierarchyIdx;
    protected final boolean hasData;
    private final N_FactPageBatchHierarchiesInfo batch;

    public N_FactPageTask(N_FactPage page, N_FactPageBatchHierarchiesInfo batch, boolean index, int hierarchyIdx, boolean hasData) {
        this.page = page;
        this.batch = batch;
        this.index = index;
        this.hierarchyIdx = hierarchyIdx;
        this.hasData = hasData;
    }

    @Override
    public int getHierarchyIdx() {
        return this.hierarchyIdx;
    }

    @Override
    public int process(N_CancellingContext context, int rowOffset) {
        if (context.isCancelling()) {
            return this.batch.getBatchRowCount();
        }
        if (this.index) {
            if (this.hasData) {
                this.processHierarchy(context, rowOffset);
            }
        } else {
            this.processFactsColumns(context, rowOffset);
        }
        return this.batch.getBatchRowCount();
    }

    private void processHierarchy(N_CancellingContext context, int rowOffset) {
        N_FactPageBatchHierarchyInfo hierarchy = this.batch.getHierarchy(this.hierarchyIdx);
        N_FactPageBitmapGutsContainer bitmapContainer = this.page.getBitmapContainer();
        MutableBoolean didSomething = new MutableBoolean();
        hierarchy.forEachEntry((memberIdx, rowBitmap) -> {
            if (!rowBitmap.isEmpty()) {
                bitmapContainer.appendToMemberBitmap(this.hierarchyIdx, (int)memberIdx, (BitSet)rowBitmap, rowOffset);
                didSomething.setValue(true);
            }
        });
        if (didSomething.booleanValue()) {
            bitmapContainer.registerIndexingLevels(this.hierarchyIdx, hierarchy.getLevels());
        }
    }

    private void processFactsColumns(N_CancellingContext context, int rowOffset) {
        OlapMeasureMember[] measureMembers = this.batch.getMeasureMembers();
        List<Object[]> measures = this.batch.getMeasures();
        int batchRowCount = this.batch.getBatchRowCount();
        for (int ii = 0; !context.isCancelling() && ii < measureMembers.length; ++ii) {
            OlapMeasureMember measure = measureMembers[ii];
            S_MeasureIndex index = measure.getMeasureIndex();
            if (index.isAlias()) continue;
            OlapScalarEntityFactColumn column = this.page.getFacts(index.getFactsColumnIndex());
            if (column == null) {
                throw new RuntimeException("internal error: missing facts column [" + this.page.getNameForStats() + "] [" + ii + "] [" + measure.getNameX() + "] [" + index.getDefIndex() + "] [" + index.getFactsColumnIndex() + "]");
            }
            int maxColumnRowCount = Integer.MAX_VALUE;
            int rowColumnCount = column.size();
            if (rowColumnCount + batchRowCount > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("max. size exceeded [maxColumnRowCount:2147483647] [columnRowCount:" + rowColumnCount + "] [batchRowCount:" + batchRowCount + "] for column : " + column.getId().toStringForError());
            }
            for (int row = 0; row < batchRowCount; ++row) {
                Object[] measureValues = measures.get(row);
                Object value = measureValues[ii];
                column.addNewValue(value);
            }
        }
    }
}

