/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts.tasks;

import crazydev.iccube.olap.entity.member.OlapMember;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.BitSet;
import java.util.function.BiConsumer;

public class N_FactPageBatchHierarchyInfo {
    final int hierarchyIdx;
    final int batchRowCount;
    final BitSet levels;
    final Int2ObjectOpenHashMap<BitSet> members;

    public N_FactPageBatchHierarchyInfo(int hierarchyIdx, int batchRowCount) {
        this.hierarchyIdx = hierarchyIdx;
        this.batchRowCount = batchRowCount;
        this.levels = new BitSet();
        this.members = new Int2ObjectOpenHashMap();
    }

    public int getHierarchyIdx() {
        return this.hierarchyIdx;
    }

    public BitSet getLevels() {
        return this.levels;
    }

    public void addLevel(int levelIdx) {
        this.levels.set(levelIdx);
    }

    public void addRow(OlapMember member, int batchRowIdx) {
        int memberIdx = member.getUniqueHierarchyMemberIndex();
        BitSet memberBitSet = (BitSet)this.members.get(memberIdx);
        if (memberBitSet == null) {
            memberBitSet = new BitSet(this.batchRowCount);
            this.members.put(memberIdx, (Object)memberBitSet);
        }
        memberBitSet.set(batchRowIdx);
    }

    public void forEachEntry(BiConsumer<? super Integer, ? super BitSet> procedure) {
        this.members.forEach(procedure);
    }

    public void clearRow(int rowIndex) {
        this.members.values().forEach(bits -> bits.clear(rowIndex));
    }
}

