/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts.cache;

import crazydev.common.cache.CdLRUCacheHelper;
import crazydev.common.cache.CdLRUCacheI;
import crazydev.common.cache.CdLRUCacheListener;
import crazydev.common.cache.CdLRUCacheStats;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderBaseFactBuilder;
import crazydev.iccube.builder.model.builders.facts.cache.N_FactPageMembers;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import org.jetbrains.annotations.Nullable;

public class N_FactPageResolvedMembersCache {
    public static int LRU_MAX_SIZE = 2048;
    @Nullable
    private final OlapSchemaFactsBuilderStats builderStats;
    private final CdLRUCacheI<Object, N_FactPageMembers>[] cachedMembers;
    private final CdLRUCacheStats[] stats;

    public N_FactPageResolvedMembersCache(OlapBuilderBaseFactBuilder builder) {
        this.builderStats = builder.getStats();
        OlapDimension[] resolvedDimensions = builder.getResolvedDimensions();
        IOlapBuilderDataViewLinksDef[] resolvedLinks = builder.getResolvedLinks();
        boolean[] resolvedBridges = builder.getResolvedBridges();
        boolean[] resolvedLTs = builder.getResolvedLTs();
        this.cachedMembers = new CdLRUCacheI[resolvedDimensions.length];
        this.stats = new CdLRUCacheStats[resolvedDimensions.length];
        for (int dimIdx = 0; dimIdx < resolvedDimensions.length; ++dimIdx) {
            OlapDimension dimension = resolvedDimensions[dimIdx];
            IOlapBuilderDataViewLinksDef links = resolvedLinks[dimIdx];
            boolean withBridge = resolvedBridges[dimIdx];
            boolean withLT = resolvedLTs[dimIdx];
            CdLRUCacheStats listener = new CdLRUCacheStats(dimension.getNameX(), withBridge, withLT);
            CdLRUCacheI cache = N_FactPageResolvedMembersCache.createCache(listener, dimension, dimIdx, links, withLT);
            this.cachedMembers[dimIdx] = cache;
            this.stats[dimIdx] = listener.withTypeInfo(cache.getTypeInfo());
        }
    }

    static <KEY, VALUE> CdLRUCacheI<KEY, VALUE> createCache(CdLRUCacheStats listener, OlapDimension dimension, int dimensionIndex, IOlapBuilderDataViewLinksDef links, boolean withLT) {
        OlapHierarchy hierarchy = dimension.getFactIndexingHierarchy();
        int maxUniqueMemberIndex = hierarchy.getMaxUniqueMemberIndex();
        if (!dimension.isIndexingByRange() && maxUniqueMemberIndex < LRU_MAX_SIZE) {
            return CdLRUCacheHelper.createWithoutLRU((boolean)withLT, (int)LRU_MAX_SIZE, (int)maxUniqueMemberIndex, (CdLRUCacheListener)listener);
        }
        return CdLRUCacheHelper.create((boolean)withLT, (int)LRU_MAX_SIZE, (CdLRUCacheListener)listener);
    }

    public CdLRUCacheI<Object, N_FactPageMembers> getCache(int dimensionIndex) {
        return this.cachedMembers[dimensionIndex];
    }

    public void put(int dimIdx, Object key, N_FactPageMembers member) {
        CdLRUCacheI<Object, N_FactPageMembers> members = this.cachedMembers[dimIdx];
        members.put(key, (Object)member);
    }

    @Nullable
    public N_FactPageMembers get(int dimIdx, Object key) {
        CdLRUCacheI<Object, N_FactPageMembers> members = this.cachedMembers[dimIdx];
        return (N_FactPageMembers)members.get(key);
    }

    public void onProcessingCompleted() {
        for (CdLRUCacheI<Object, N_FactPageMembers> cache : this.cachedMembers) {
            cache.onProcessingCompleted();
        }
        if (this.builderStats != null) {
            this.builderStats.reportResolveMemberCacheStats(this.stats);
        }
    }
}

