/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts;

import crazydev.common.cache.CdLRUCacheI;
import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdCollections;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.bridge.IOlapBridgeResolver;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderBaseFactBuilder;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactSolveRowError;
import crazydev.iccube.builder.model.builders.facts.cache.N_FactPageMembers;
import crazydev.iccube.builder.model.builders.facts.cache.N_FactPageResolvedMembersCache;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfo;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfoLP;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfoNP;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfoTP;
import crazydev.iccube.builder.model.builders.facts.view.OlapBuilderFactBuilderForView;
import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTableRowDecorator;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.configuration.component.properties.OlapProcessingFactsMode;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.OlapFactMemberLineHelper;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadStats;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.IMMUTABLE)
public class OlapBuilderFactBuilder
extends OlapBuilderBaseFactBuilder {
    public static final boolean FACTS_BATCH_PROCESSING_ACTIVATED = true;
    private final OlapRegularCube cube;
    protected final OlapFactMeasureGroupBaseManager facts;
    @Nullable
    private final AtomicBoolean withData = new AtomicBoolean(false);
    private final Set<IOlapBuilderTablePartitionKey> partitionsWithData = new HashSet<IOlapBuilderTablePartitionKey>();
    private final IOlapBuilderMeasureDef[] resolvedMeasureDefs;
    protected final OlapMeasureMember[] resolvedMeasureMembers;
    protected final List<Integer> indexingHierarchyIndicesAndM2M;
    private final OlapProcessingFactsMode factsProcessingMode;
    private final OlapBuilderFactBuilderForView viewBuilder;
    @Nullable
    private final OlapFactsLookupTableRowDecorator rowDecorator;
    private final Set<OlapDimension> unresolvedRowsLogged = new HashSet<OlapDimension>();

    public OlapBuilderFactBuilder(OlapBuilderContext context, OlapRegularCube cube, OlapBuilderFacts builderFacts) {
        super(context, OlapBuilderFactBuilder.setupStats(context, cube, builderFacts), builderFacts.getMeasureGroupName(), builderFacts.getDimensionMap());
        this.cube = cube;
        this.facts = cube.getFactManager(builderFacts.getMeasureGroupName());
        this.initialize(context, builderFacts);
        this.context.createClusterContext(this.facts);
        ArrayList<IOlapBuilderMeasureDef> resolvedMeasureDefs = new ArrayList<IOlapBuilderMeasureDef>();
        ArrayList<OlapMeasureMember> resolvedMeasureMembers = new ArrayList<OlapMeasureMember>();
        List<IOlapBuilderMeasureDef> measureDefs = builderFacts.getMeasures();
        for (IOlapBuilderMeasureDef measureDef : measureDefs) {
            OlapMeasureMember measureMember = this.lookupMeasure(measureDef);
            if (measureMember == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACTS_MEASURE_KEY_NOT_FOUND, new Serializable[]{this.getFactName(), measureDef.getKey()});
            }
            S_MeasureIndex index = measureMember.getMeasureIndex();
            if (index.isAlias()) continue;
            resolvedMeasureDefs.add(measureDef);
            resolvedMeasureMembers.add(measureMember);
        }
        this.resolvedMeasureDefs = resolvedMeasureDefs.toArray(new OlapBuilderMeasure[0]);
        this.resolvedMeasureMembers = resolvedMeasureMembers.toArray(new OlapMeasureMember[0]);
        this.indexingHierarchyIndicesAndM2M = this.indexingHierarchyIndices;
        OlapEngineRequestContext engineContext = context.getEngineContext();
        OlapProperties props = engineContext.getOlapEngineProperties();
        this.factsProcessingMode = props.getLoadProcessingFactsMode();
        this.viewBuilder = new OlapBuilderFactBuilderForView(this);
        this.rowDecorator = this.factsLookupTables != null ? OlapFactsLookupTableRowDecorator.create(this.resolvedDimensions.length, this.factsLookupTables) : null;
    }

    private static OlapSchemaFactsBuilderStats setupStats(OlapBuilderContext context, OlapRegularCube cube, OlapBuilderFacts builderFacts) {
        OlapSchemaFullLoadStats fullLoadStats = context.getFullLoadStats();
        if (fullLoadStats != null) {
            return fullLoadStats.createStats(cube, builderFacts);
        }
        OlapEngineRequestContext rContext = context.getRequestContext();
        OlapProperties props = rContext.getOlapEngineProperties();
        String configuration = OlapSchemaFullLoadStats.setupConfiguration(props);
        return new OlapSchemaFactsBuilderStats(configuration, cube, builderFacts);
    }

    @Nullable
    private OlapMeasureMember lookupMeasure(IOlapBuilderMeasureDef measureDef) {
        OlapMeasuresDimension measuresDim = this.cube.getMeasuresDimension();
        return measuresDim.unfilteredLookupMeasureByKey(this.nameContext, measureDef);
    }

    private void initialize(OlapBuilderContext context, OlapBuilderFacts builderFacts) {
        List<OlapDimension> resolvedDims = Arrays.asList(this.resolvedDimensions);
        this.facts.initLazyVariables(resolvedDims);
    }

    @Override
    public OlapFactMeasureGroupBaseManager getFacts() {
        return this.facts;
    }

    @Override
    public void onTableProcessingInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingInit(context, tabularData);
        OlapFactRowAggregationType aggr = this.facts.rowFactAggregationType();
        if (aggr == OlapFactRowAggregationType.ADD_ROW_CLEAR_ON_INCR_LOAD && context.getMode() == OlapBuilderContextMode.INCR_LOAD) {
            this.facts.clearOnIncrLoadFullReload(context);
        }
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData, IOlapBuilderTablePartitionKey tablePartitionKey) {
        this.facts.onTableRowsProcessingCompleted(context, tablePartitionKey);
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        this.facts.onTableRowsProcessingCompleted(context);
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingCompleted(context, tabularData);
        this.viewBuilder.onTableProcessingCompleted(context);
        if (this.stats != null) {
            this.stats.onFactsProcessingCompleted(context.getLoggers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData(@Nullable IOlapBuilderTablePartitionKey partition) {
        if (partition == null) {
            return this.withData.get();
        }
        Set<IOlapBuilderTablePartitionKey> set = this.partitionsWithData;
        synchronized (set) {
            return this.partitionsWithData.contains(partition);
        }
    }

    public void onNewEmptyRow(OlapBuilderContext builderContext, @Nullable IOlapBuilderTablePartitionKey partitionKey) {
        if (builderContext.isOfflineWriteOnly()) {
            return;
        }
        this.facts.addFactEmptyRow(this.context, partitionKey);
    }

    @Override
    public boolean onNewRow(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partitionKey, int rowNb, IOlapBuilderTableRow row) {
        this.viewBuilder.onNewRow(builderContext, originalTable, tabularData, columns, partitionKey, rowNb, row);
        return true;
    }

    @Override
    public boolean onNewRows(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partitionKey, int batchRowOffset, List<IOlapBuilderTableRow> rows) {
        return this.onMultipleRows(builderContext, originalTable, tabularData, columns, partitionKey, batchRowOffset, rows);
    }

    private boolean onMultipleRows(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partitionKey, int batchRowOffset, List<IOlapBuilderTableRow> rows) {
        if (this.factsProcessingMode == OlapProcessingFactsMode.NONE) {
            if (this.stats != null) {
                this.stats.onFullProcessed(builderContext, rows.size(), 0L);
            }
            return true;
        }
        long startNS = System.nanoTime();
        boolean ret = this.doOnMultipleRows(builderContext, tabularData, partitionKey, batchRowOffset, rows);
        if (this.stats != null) {
            this.stats.onFullProcessed(builderContext, rows.size(), System.nanoTime() - startNS);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOnMultipleRows(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partitionKey, int batchRowOffset, List<IOlapBuilderTableRow> rows) {
        if (builderContext.isOfflineWriteOnly() || rows.isEmpty()) {
            return true;
        }
        builderContext.assertNotCancelling("add-facts-rows");
        N_FactPageResolvedMembersCache resolverCache = builderContext.getOrCreateResolverCacheBP(this, Thread.currentThread());
        N_FactPageBatchInfo info = this.setupBatchInformation(rows.size(), partitionKey);
        long startNS_resolve = System.nanoTime();
        int batchRowCount2 = rows.size();
        for (int batchRowIdx = 0; batchRowIdx < batchRowCount2; ++batchRowIdx) {
            builderContext.setProcessingRowNumber(batchRowOffset + batchRowIdx);
            IOlapBuilderTableRow row = rows.get(batchRowIdx);
            this.addRowMembersAndMeasures(builderContext, tabularData, partitionKey, resolverCache, info, row);
        }
        builderContext.setProcessingRowNumber(-1);
        if (this.stats != null) {
            this.stats.onResolveProcessed(System.nanoTime() - startNS_resolve);
        }
        if (!info.hasData()) {
            return true;
        }
        this.withData.set(true);
        if (partitionKey != null) {
            Set<IOlapBuilderTablePartitionKey> batchRowCount2 = this.partitionsWithData;
            synchronized (batchRowCount2) {
                this.partitionsWithData.add(partitionKey);
            }
        }
        long startNS_bitmaps = System.nanoTime();
        this.facts.addFactRows(this.context, info);
        if (this.stats != null) {
            this.stats.onPageProcessed(System.nanoTime() - startNS_bitmaps);
        }
        return true;
    }

    private N_FactPageBatchInfo setupBatchInformation(int batchMaxRowCount, @Nullable IOlapBuilderTablePartitionKey partitionKey) {
        S_SchemaDef schemaDef = this.cube.getSchema().getClusterSchemaDef();
        int hierarchyCount = schemaDef.getIndexingHierarchyArraySize();
        IOlapBuilderBaseFactsDef factsDefinition = this.getFactsDefinition();
        OlapPartitioningType partitioningType = this.facts.getPartitionType();
        switch (partitioningType) {
            case NONE: {
                return this.createFactPageBatchInfoNP(batchMaxRowCount, hierarchyCount);
            }
            case DATA_TABLE_DEFINED: {
                return this.createFactPageBatchInfoTP(batchMaxRowCount, partitionKey, hierarchyCount);
            }
            case OLAP_LEVEL_DEFINED: {
                OlapLevel partitioningLevel = factsDefinition.getPartitioningLevel();
                OlapDimension partitioningDimension = partitioningLevel.getDimension();
                int partitioningDimensionIndex = -1;
                int dimensionCount = this.dimensions.size();
                for (int dimensionIndex = 0; dimensionIndex < dimensionCount; ++dimensionIndex) {
                    OlapDimension dimension = this.resolvedDimensions[dimensionIndex];
                    if (!partitioningDimension.equals(dimension)) continue;
                    partitioningDimensionIndex = dimensionIndex;
                    break;
                }
                if (partitioningDimensionIndex == -1) {
                    throw new RuntimeException("internal error: unexpected missing partitioning level [" + partitioningLevel.getNameX() + "] dimension");
                }
                return this.createFactPageBatchInfoLP(batchMaxRowCount, partitioningDimension, partitioningDimensionIndex, partitioningLevel, hierarchyCount);
            }
        }
        throw new RuntimeException("internal error: unexpected facts partitioning [" + String.valueOf((Object)partitioningType) + "]");
    }

    protected N_FactPageBatchInfo createFactPageBatchInfoNP(int batchMaxRowCount, int hierarchyCount) {
        return new N_FactPageBatchInfoNP(batchMaxRowCount, this.indexingHierarchyIndicesAndM2M, this.resolvedMeasureMembers, hierarchyCount);
    }

    protected N_FactPageBatchInfo createFactPageBatchInfoTP(int batchMaxRowCount, @Nullable IOlapBuilderTablePartitionKey partitionKey, int hierarchyCount) {
        return new N_FactPageBatchInfoTP(batchMaxRowCount, this.indexingHierarchyIndicesAndM2M, this.resolvedMeasureMembers, partitionKey, hierarchyCount);
    }

    protected N_FactPageBatchInfo createFactPageBatchInfoLP(int batchMaxRowCount, OlapDimension partitioningDimension, int partitioningDimensionIndex, OlapLevel partitioningLevel, int hierarchyCount) {
        return new N_FactPageBatchInfoLP(batchMaxRowCount, this.indexingHierarchyIndicesAndM2M, this.resolvedMeasureMembers, partitioningDimension, partitioningDimensionIndex, partitioningLevel, hierarchyCount);
    }

    private void addRowMembersAndMeasures(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partitionKey, N_FactPageResolvedMembersCache resolverCache, N_FactPageBatchInfo info, IOlapBuilderTableRow row) {
        Object levelPartition;
        if (info.isLevelPartitioning()) {
            IOlapBridgeResolver bridge;
            OlapLevel[] levels;
            IOlapBuilderDataViewLinksDef links;
            int dimensionIndex = info.getLevelPartitioningDimensionIndex();
            OlapDimension dimension = this.resolvedDimensions[dimensionIndex];
            OlapMember[] members = this.resolveLevelPartitionMembers(builderContext, tabularData, partitionKey, dimension, dimensionIndex, links = this.resolvedLinks[dimensionIndex], levels = this.resolvedLevels[dimensionIndex], bridge = this.resolvedBridges[dimensionIndex], row);
            if (members == null) {
                return;
            }
            levelPartition = info.resolveLevelPartition(this, members);
        } else {
            levelPartition = null;
        }
        int rowIndex = info.onRowStarted(levelPartition);
        int dimensionCount = this.dimensions.size();
        boolean resolved = true;
        row = this.rowDecorator != null ? this.rowDecorator.decorateRow(row) : row;
        for (int dimensionIndex = 0; dimensionIndex < dimensionCount; ++dimensionIndex) {
            OlapDimension dimension = this.resolvedDimensions[dimensionIndex];
            IOlapBuilderDataViewLinksDef links = this.resolvedLinks[dimensionIndex];
            OlapLevel[] levels = this.resolvedLevels[dimensionIndex];
            IOlapBridgeResolver bridge = this.resolvedBridges[dimensionIndex];
            boolean added = this.addRowMembers(builderContext, tabularData, partitionKey, resolverCache, info, levelPartition, dimension, dimensionIndex, links, levels, bridge, row, rowIndex);
            if (added) continue;
            resolved = false;
            for (int dimIdx = 0; dimIdx < dimensionIndex; ++dimIdx) {
                info.clearMember(levelPartition, this.resolvedDimensions[dimIdx], rowIndex);
            }
            break;
        }
        if (resolved) {
            Object[] measures = this.extractMeasures(row);
            info.addMeasures(levelPartition, measures, rowIndex);
            info.onRowAdded(levelPartition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logUnresolvedRows(OlapBuilderContext builderContext, @Nullable OlapDimension dimension, Supplier<String> errorMessage) {
        Logger logger = builderContext.getLoggers().builderFacts();
        if (logger.isDebugEnabled()) {
            if (dimension == null) {
                logger.debug((Object)errorMessage.get());
            }
            Set<OlapDimension> set = this.unresolvedRowsLogged;
            synchronized (set) {
                if (!this.unresolvedRowsLogged.contains(dimension)) {
                    logger.debug((Object)errorMessage.get());
                    this.unresolvedRowsLogged.add(dimension);
                }
            }
        }
    }

    @Nullable
    public OlapMember[] resolveLevelPartitionMembers(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partitionKey, OlapDimension dimension, int dimensionIndex, IOlapBuilderDataViewLinksDef links, OlapLevel[] levels, IOlapBridgeResolver bridge, IOlapBuilderTableRow row) {
        Object key;
        try {
            key = this.createMemberKey(dimension, bridge, row, links);
        }
        catch (OlapBuilderFactSolveRowError error) {
            if (this.isAcceptUnresolvedRows()) {
                this.logUnresolvedRows(builderContext, error.getDimension(), () -> error.getError().getMessage());
                builderContext.reportUnresolvedRow(this.cube, this.facts.getFactsDefinition(), tabularData, partitionKey, row);
                return null;
            }
            throw error.getError();
        }
        return this.resolveRowMembersFromKey(builderContext, tabularData, partitionKey, dimension, links, levels, row, key);
    }

    private boolean addRowMembers(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partitionKey, N_FactPageResolvedMembersCache resolverCache, N_FactPageBatchInfo info, @Nullable Object levelPartition, OlapDimension dimension, int dimensionIndex, IOlapBuilderDataViewLinksDef links, OlapLevel[] levels, @Nullable IOlapBridgeResolver bridge, IOlapBuilderTableRow row, int rowIndex) {
        List<IOlapBuilderDataColumnDef> keyColumns = links.getToColumns();
        Comparable nativeKeyValue = row.getJavaNativeDataValueForResolveMembers(dimensionIndex, keyColumns);
        if (keyColumns.size() == 1) {
            Comparable newKey = dimension.adaptKeyValue(nativeKeyValue);
            if (bridge != null && newKey != nativeKeyValue) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Dimension [" + dimension.getNameX() + "] :  Bridge not supported when adapting a Time column to a Date (please change input column to DATE)"});
            }
            nativeKeyValue = newKey;
        }
        try {
            CdLRUCacheI<Object, N_FactPageMembers> resolverCacheD = resolverCache.getCache(dimensionIndex);
            Comparable keyValueForCache = null;
            N_FactPageMembers cached = null;
            if (nativeKeyValue != null) {
                cached = (N_FactPageMembers)resolverCacheD.getPrev((Object)nativeKeyValue);
                if (cached == null) {
                    Comparable comparable = keyValueForCache = bridge != null ? bridge.getValuesForCache(nativeKeyValue, this.useUnknownMembers) : nativeKeyValue;
                    if (keyValueForCache != null) {
                        cached = (N_FactPageMembers)resolverCacheD.get((Object)keyValueForCache);
                        if (cached != null) {
                            resolverCacheD.putPrev((Object)nativeKeyValue, (Object)cached);
                        }
                    } else {
                        resolverCacheD.nil();
                    }
                }
            } else {
                resolverCacheD.nil();
            }
            if (cached != null) {
                return this.addRowMembersFromKeyFromCache_NG(links, info, levelPartition, cached, rowIndex);
            }
            Object key = this.createMemberKeyFromNativeKeyValue(dimension, bridge, links, nativeKeyValue);
            return this.addRowMembersFromKeyAndCache_NG(builderContext, tabularData, partitionKey, resolverCacheD, info, levelPartition, dimension, links, levels, nativeKeyValue, keyValueForCache, key, row, rowIndex);
        }
        catch (OlapBuilderFactSolveRowError error) {
            if (this.isAcceptUnresolvedRows()) {
                this.logUnresolvedRows(builderContext, error.getDimension(), () -> error.getError().getMessage());
                builderContext.reportUnresolvedRow(this.cube, this.facts.getFactsDefinition(), tabularData, partitionKey, row);
                return false;
            }
            throw error.getError();
        }
    }

    private boolean addRowMembersFromKeyFromCache_NG(IOlapBuilderDataViewLinksDef links, N_FactPageBatchInfo info, @Nullable Object levelPartition, N_FactPageMembers members, int rowIndex) {
        members.forEachMember(member -> info.addMember(links, levelPartition, (OlapMember)member, rowIndex));
        return true;
    }

    private boolean addRowMembersFromKeyAndCache_NG(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partitionKey, CdLRUCacheI<Object, N_FactPageMembers> resolverCache, N_FactPageBatchInfo info, @Nullable Object levelPartition, OlapDimension dimension, IOlapBuilderDataViewLinksDef links, OlapLevel[] levels, @Nullable Comparable nativeKeyValue, @Nullable Comparable keyValueForCache, @Nullable Object key, IOlapBuilderTableRow row, int rowIndex) {
        OlapMember[] members = this.resolveRowMembersFromKey(builderContext, tabularData, partitionKey, dimension, links, levels, row, key);
        if (members == null) {
            return false;
        }
        N_FactPageMembers cachedMembers = new N_FactPageMembers(links);
        if (!this.forKeyMemberIndexOnly()) {
            OlapFactMemberLineHelper.resolveMembersWithAction(builderContext, members, (CdAction<OlapMember>)((CdAction)member -> this.addRowMemberAndCache(links, info, cachedMembers, levelPartition, (OlapMember)member, rowIndex)));
        } else {
            for (OlapMember member2 : members) {
                this.addRowMemberAndCache(links, info, cachedMembers, levelPartition, member2, rowIndex);
            }
        }
        if (cachedMembers.isValid()) {
            if (nativeKeyValue != null) {
                resolverCache.putPrev((Object)nativeKeyValue, (Object)cachedMembers);
            }
            if (keyValueForCache != null) {
                resolverCache.put((Object)keyValueForCache, (Object)cachedMembers);
            }
        }
        return true;
    }

    protected boolean forKeyMemberIndexOnly() {
        return false;
    }

    private void addRowMemberAndCache(IOlapBuilderDataViewLinksDef links, N_FactPageBatchInfo info, N_FactPageMembers cachedMembers, @Nullable Object levelPartition, OlapMember member, int rowIndex) {
        this.addRowMemberAndCacheWithoutM2M(links, info, cachedMembers, levelPartition, member, rowIndex);
    }

    private void addRowMemberAndCacheWithoutM2M(IOlapBuilderDataViewLinksDef links, N_FactPageBatchInfo info, N_FactPageMembers cachedMembers, @Nullable Object levelPartition, OlapMember member, int rowIndex) {
        cachedMembers.addMember(member);
        info.addMember(links, levelPartition, member, rowIndex);
    }

    @Nullable
    private OlapMember[] resolveRowMembersFromKey(OlapBuilderContext builderContext, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partitionKey, OlapDimension dimension, IOlapBuilderDataViewLinksDef links, OlapLevel[] levels, IOlapBuilderTableRow row, @Nullable Object key) {
        OlapMember member;
        if (key == null) {
            OlapMember member2;
            OlapMember olapMember = member2 = this.useUnknownMembers ? dimension.getUnknownMemberForFacts() : null;
            if (member2 == null) {
                throw new RuntimeException("internal error: unexpected missing unknown member");
            }
            return new OlapMember[]{member2};
        }
        OlapMember[] members = this.lookupMemberByKey(dimension, levels, links, key);
        if (members != null) {
            return members;
        }
        OlapMember olapMember = member = this.useUnknownMembers ? dimension.getUnknownMemberForFacts() : null;
        if (member != null) {
            return new OlapMember[]{member};
        }
        if (this.isAcceptUnresolvedRows()) {
            this.logUnresolvedRows(builderContext, dimension, () -> "facts [" + this.getFactName() + "] unresolved row for dimension [" + dimension.getName(OlapNameContext.DEFAULT_VALUES) + "] ( reporting first row only : unresolved member key [" + String.valueOf(key) + "] )");
            builderContext.reportUnresolvedRow(this.cube, this.facts.getFactsDefinition(), tabularData, partitionKey, row);
            return null;
        }
        OlapMemberKey memberKey = OlapBuilderFactBuilder.buildKey(links, key);
        String keyColumns = CdCollections.toString(links.getToColumns(), (String)"");
        if (levels == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACTS_MEMBER_KEY_NOT_FOUND, new Serializable[]{this.getFactName(), memberKey.toString(), dimension.getName(this.nameContext), keyColumns, dimension.isIndexingByRange() ? ", is Indexing by Range" : ""});
        }
        String names = ONames.name4Log(Arrays.asList(levels));
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACTS_MEMBER_KEY_NOT_FOUND_WITH_LEVEL, new Serializable[]{this.getFactName(), memberKey.toString(), dimension.getName(this.nameContext), names, keyColumns});
    }

    private Object[] extractMeasures(IOlapBuilderTableRow row) {
        Object[] values = new Object[this.resolvedMeasureDefs.length];
        for (int idx = 0; idx < values.length; ++idx) {
            IOlapBuilderMeasureDef measureDef = this.resolvedMeasureDefs[idx];
            IOlapBuilderDataColumnDef measureColumn = measureDef.getColumn();
            values[idx] = row.getJavaNativeDataValue(measureColumn);
        }
        return values;
    }

    @Override
    protected String getFactName() {
        return this.facts.getName();
    }

    @Override
    public IOlapBuilderBaseFactsDef getFactsDefinition() {
        return this.facts.getFactsDefinition();
    }

    public boolean isTablePartitioned() {
        return this.facts.isTablePartitioned();
    }
}

